/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import es.superstrellaa.cinematictools.client.CinematicToolsClient;
import es.superstrellaa.cinematictools.client.KeyHandler;
import es.superstrellaa.cinematictools.client.SceneException;
import es.superstrellaa.cinematictools.client.mixin.GameRendererAccessor;
import es.superstrellaa.cinematictools.common.math.interpolation.CamInterpolation;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.math.point.CamPoints;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import es.superstrellaa.cinematictools.common.scene.mode.OutsideMode;
import es.superstrellaa.cinematictools.common.target.CamTarget;
import io.github.fabricators_of_create.porting_lib.features.CameraSetupCallback;
import io.github.fabricators_of_create.porting_lib.features.FieldOfViewEvents;
import io.github.fabricators_of_create.porting_lib.features.RenderTickStartCallback;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_8251;
import net.minecraft.class_863;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CamEventHandlerClient {
    public static final class_310 MC = class_310.method_1551();
    public static final double ZOOM_STEP = 0.005;
    public static final float ROLL_STEP = 1.5f;
    public static final double MAX_FOV = 170.0;
    public static final double MIN_FOV = 0.1;
    public static final double FOV_RANGE = 169.9;
    public static final double FOV_RANGE_HALF = 84.95;
    public static class_1297 camera = null;
    private static double fov = 0.0;
    private static float roll = 0.0f;
    private static Consumer<CamTarget> selectingTarget = null;
    private static boolean renderingHand = false;
    private static boolean skipFov = false;

    public static void startSelectionMode(Consumer<CamTarget> selectingTarget) {
        CamEventHandlerClient.selectingTarget = selectingTarget;
    }

    public static void resetRoll() {
        roll = 0.0f;
    }

    public static float roll() {
        return roll;
    }

    public static void roll(float roll) {
        CamEventHandlerClient.roll = roll;
    }

    public static void resetFOV() {
        fov = 0.0;
    }

    public static double fovExactVanilla(float partialTickTime) {
        try {
            skipFov = true;
            double d = ((GameRendererAccessor)CamEventHandlerClient.MC.field_1773).callGetFov(CamEventHandlerClient.MC.field_1773.method_19418(), partialTickTime, true);
            return d;
        }
        finally {
            skipFov = false;
        }
    }

    public static double fovExact(float partialTickTime) {
        return CamEventHandlerClient.fovExactVanilla(partialTickTime) + fov;
    }

    public static void fov(double fov) {
        CamEventHandlerClient.fov = fov;
    }

    public CamEventHandlerClient() {
        ClientTickEvents.START_CLIENT_TICK.register(this::onClientTick);
        RenderTickStartCallback.EVENT.register(this::onRenderTick);
        FieldOfViewEvents.COMPUTE.register(this::fov);
        WorldRenderEvents.AFTER_ENTITIES.register(this::worldRender);
        CameraSetupCallback.EVENT.register(this::cameraRoll);
        UseBlockCallback.EVENT.register(this::onPlayerUseBlock);
        UseEntityCallback.EVENT.register(this::onPlayerUseEntity);
    }

    public void onClientTick(class_310 MC) {
        if (MC.field_1724 != null && MC.field_1687 != null && !MC.method_1493() && CinematicToolsClient.isPlaying()) {
            CinematicToolsClient.gameTickPath((class_1937)MC.field_1687);
        }
    }

    private double calculatePointInCurve(double fov) {
        fov -= 0.1;
        fov /= 84.95;
        fov = class_3532.method_15350((double)fov, (double)0.0, (double)2.0);
        return Math.asin(fov - 1.0) / Math.PI + 0.5;
    }

    private double transformFov(double x) {
        if (x <= 0.0) {
            return 0.1;
        }
        if (x >= 1.0) {
            return 170.0;
        }
        return (Math.sin((x - 0.5) * Math.PI) + 1.0) * 84.95 + 0.1;
    }

    public void onRenderTick() {
        if (CamEventHandlerClient.MC.field_1687 == null) {
            CinematicToolsClient.resetServerAvailability();
            CinematicToolsClient.resetTargetMarker();
        }
        float renderTickTime = MC.method_1534();
        renderingHand = false;
        if (CamEventHandlerClient.MC.field_1724 != null && CamEventHandlerClient.MC.field_1687 != null && !MC.method_1493()) {
            if (CinematicToolsClient.isPlaying()) {
                while (CamEventHandlerClient.MC.field_1690.field_1903.method_1436()) {
                    if (!CinematicToolsClient.isPlaying() || CinematicToolsClient.getScene().mode.outside()) continue;
                    CinematicToolsClient.getScene().togglePause();
                }
                CinematicToolsClient.renderTickPath((class_1937)CamEventHandlerClient.MC.field_1687, renderTickTime);
            } else {
                double multiplier;
                CinematicToolsClient.noTickPath((class_1937)CamEventHandlerClient.MC.field_1687, renderTickTime);
                double timeFactor = MC.method_1534();
                double vanillaFov = CamEventHandlerClient.fovExactVanilla(renderTickTime);
                double currentFov = vanillaFov + fov;
                double x = this.calculatePointInCurve(currentFov);
                double d = multiplier = CamEventHandlerClient.MC.field_1724.method_18276() ? 5.0 : 1.0;
                while (KeyHandler.pointKey.method_1436()) {
                    if (!CinematicToolsClient.isOp) {
                        CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                    }
                    CamPoint point = CamPoint.createLocal();
                    if (CinematicToolsClient.getScene().posTarget != null) {
                        CamPoint vec = CinematicToolsClient.getTargetMarker();
                        if (vec == null) {
                            CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43469((String)"scene.follow.no_marker", (Object[])new Object[]{CinematicToolsClient.getPoints().size()}));
                            continue;
                        }
                        point.sub(vec);
                    }
                    CinematicToolsClient.getPoints().add(point);
                    CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43469((String)"scene.add", (Object[])new Object[]{CinematicToolsClient.getPoints().size()}));
                }
            }
            if (KeyHandler.startStop.method_1436()) {
                if (CinematicToolsClient.isPlaying()) {
                    CinematicToolsClient.stop();
                } else {
                    try {
                        if (!CinematicToolsClient.isOp) {
                            CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                        }
                        CinematicToolsClient.start(CinematicToolsClient.createScene());
                    }
                    catch (SceneException e) {
                        CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43471((String)e.getMessage()));
                    }
                }
            }
            while (KeyHandler.clearPoint.method_1436()) {
                if (!CinematicToolsClient.isOp) {
                    CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                }
                CinematicToolsClient.getPoints().clear();
                CamEventHandlerClient.MC.field_1724.method_43496((class_2561)class_2561.method_43471((String)"scene.clear"));
            }
        }
    }

    public double fov(class_757 renderer, class_4184 camera, double partialTicks, boolean usedFovSetting, double fov) {
        if (skipFov) {
            return fov;
        }
        double newFov = fov;
        if (!renderingHand) {
            newFov = CinematicToolsClient.isPlaying() ? fov : fov + CamEventHandlerClient.fov;
            newFov = class_3532.method_15350((double)newFov, (double)0.1, (double)170.0);
        }
        renderingHand = !renderingHand;
        return newFov;
    }

    public void worldRender(WorldRenderContext context) {
        if (CinematicToolsClient.isPlaying()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        class_243 view = CamEventHandlerClient.MC.field_1773.method_19418().method_19326();
        RenderSystem.setProjectionMatrix((Matrix4f)context.projectionMatrix(), (class_8251)class_8251.field_43361);
        class_4587 mat = RenderSystem.getModelViewStack();
        mat.method_22903();
        mat.method_34426();
        mat.method_34425(context.matrixStack().method_23760().method_23761());
        mat.method_22904(-view.method_10216(), -view.method_10214(), -view.method_10215());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)false);
        if (CinematicToolsClient.hasTargetMarker()) {
            CamPoint point = CinematicToolsClient.getTargetMarker();
            CamEventHandlerClient.renderHitbox(mat, MC.method_22940().method_23000().getBuffer(class_1921.method_23594()), new class_238(point.x - 0.3, point.y - 1.62, point.z - 0.3, point.x + 0.3, point.y + 0.18, point.z + 0.3), CamEventHandlerClient.MC.field_1724.method_5751(), point, point.calculateViewVector());
        }
        boolean shouldRender = false;
        for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
            if (!movement.isRenderingEnabled) continue;
            shouldRender = true;
            break;
        }
        class_4587 pose = new class_4587();
        if (shouldRender && CinematicToolsClient.getPoints().size() > 0) {
            for (int i = 0; i < CinematicToolsClient.getPoints().size(); ++i) {
                CamPoint point = CinematicToolsClient.getPoints().get(i);
                if (CinematicToolsClient.hasTargetMarker()) {
                    point = point.copy();
                    point.add(CinematicToolsClient.getTargetMarker());
                }
                class_863.method_23098((class_4587)pose, (class_4597)MC.method_22940().method_23000(), (double)(point.x - 0.05), (double)(point.y - 0.05), (double)(point.z - 0.05), (double)(point.x + 0.05), (double)(point.y + 0.05), (double)(point.z + 0.05), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                class_863.method_23105((class_4587)pose, (class_4597)MC.method_22940().method_23000(), (String)("" + (i + 1)), (double)(point.x + view.field_1352), (double)(point.y + 0.2 + view.field_1351), (double)(point.z + view.field_1350), (int)-1);
                RenderSystem.depthMask((boolean)false);
            }
            MC.method_22940().method_23000().method_37104();
            try {
                mat.method_22903();
                CamScene scene = CinematicToolsClient.createScene();
                for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
                    if (!movement.isRenderingEnabled) continue;
                    this.renderPath(pose, movement, scene);
                }
                mat.method_22909();
            }
            catch (SceneException sceneException) {
                // empty catch block
            }
        }
        mat.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
    }

    public void renderPath(class_4587 mat, CamInterpolation inter, CamScene scene) {
        double steps = 20 * (scene.points.size() - 1);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.lineWidth((float)1.0f);
        Vec3d color = inter.color.toVec();
        bufferbuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        CamPoints points = new CamPoints(scene.points);
        if (scene.lookTarget != null) {
            scene.lookTarget.start((class_1937)CamEventHandlerClient.MC.field_1687);
        }
        if (scene.posTarget != null) {
            scene.posTarget.start((class_1937)CamEventHandlerClient.MC.field_1687);
        }
        double[] times = points.createTimes(scene);
        Interpolation<Vec3d> interpolation = inter.create(times, scene, null, new ArrayList<CamPoint>(scene.points), null, CamAttribute.POSITION);
        int i = 0;
        while ((double)i < steps) {
            Vec3d pos = (Vec3d)interpolation.valueAt((double)i / steps);
            if (CinematicToolsClient.hasTargetMarker()) {
                pos.add((Vec3d)CinematicToolsClient.getTargetMarker());
            }
            bufferbuilder.method_22912((double)((float)pos.x), (double)((float)pos.y), (double)((float)pos.z)).method_22915((float)color.x, (float)color.y, (float)color.z, 1.0f).method_1344();
            ++i;
        }
        CamPoint last = scene.points.get(scene.points.size() - 1).copy();
        if (CinematicToolsClient.hasTargetMarker()) {
            last.add(CinematicToolsClient.getTargetMarker());
        }
        bufferbuilder.method_22912((double)((float)last.x), (double)((float)last.y), (double)((float)last.z)).method_22915((float)color.x, (float)color.y, (float)color.z, 1.0f).method_1344();
        tessellator.method_1350();
        if (scene.lookTarget != null) {
            scene.lookTarget.finish();
        }
        if (scene.posTarget != null) {
            scene.posTarget.finish();
        }
    }

    private static void renderHitbox(class_4587 pMatrixStack, class_4588 pBuffer, class_238 aabb, float eyeHeight, Vec3d origin, Vec3d view) {
        class_761.method_22982((class_4587)pMatrixStack, (class_4588)pBuffer, (class_238)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 0.01f;
        class_761.method_22980((class_4587)pMatrixStack, (class_4588)pBuffer, (double)aabb.field_1323, (double)(aabb.field_1322 + (double)(eyeHeight - f)), (double)aabb.field_1321, (double)aabb.field_1320, (double)(aabb.field_1322 + (double)(eyeHeight + f)), (double)aabb.field_1324, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix4f matrix4f = pMatrixStack.method_23760().method_23761();
        Matrix3f matrix3f = pMatrixStack.method_23760().method_23762();
        pBuffer.method_22918(matrix4f, (float)origin.x, (float)origin.y, (float)origin.z).method_1336(0, 0, 255, 255).method_23763(matrix3f, (float)view.x, (float)view.y, (float)view.z).method_1344();
        pBuffer.method_22918(matrix4f, (float)(origin.x + view.x * 2.0), (float)(origin.y + view.y * 2.0), (float)(origin.z + view.z * 2.0)).method_1336(0, 0, 255, 255).method_23763(matrix3f, (float)view.x, (float)view.y, (float)view.z).method_1344();
    }

    public boolean cameraRoll(CameraSetupCallback.CameraInfo event) {
        event.roll = roll;
        return false;
    }

    public class_1269 onPlayerUseEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        if (hitResult == null) {
            return class_1269.field_5811;
        }
        this.interact(player, world, null, hitResult.method_17782());
        return class_1269.field_5811;
    }

    public class_1269 onPlayerUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        this.interact(player, world, hitResult.method_17777(), null);
        return class_1269.field_5811;
    }

    public void interact(class_1657 player, class_1937 level, @Nullable class_2338 pos, @Nullable class_1297 target) {
        if (selectingTarget == null || !level.field_9236) {
            return;
        }
        if (target != null) {
            selectingTarget.accept(new CamTarget.EntityTarget(target));
            player.method_43496((class_2561)class_2561.method_43469((String)"scene.look.target.entity", (Object[])new Object[]{target.method_5845()}));
            selectingTarget = null;
        }
        if (pos != null) {
            selectingTarget.accept(new CamTarget.BlockTarget(pos));
            player.method_43496((class_2561)class_2561.method_43469((String)"scene.look.target.pos", (Object[])new Object[]{pos.method_23854()}));
            selectingTarget = null;
        }
    }

    public static void setupMouseHandlerBefore() {
        if (CinematicToolsClient.isPlaying() && CinematicToolsClient.getScene().mode instanceof OutsideMode) {
            camera = CamEventHandlerClient.MC.field_1719;
            CamEventHandlerClient.MC.field_1719 = CamEventHandlerClient.MC.field_1724;
        }
    }

    public static void setupMouseHandlerAfter() {
        if (CinematicToolsClient.isPlaying() && CinematicToolsClient.getScene().mode instanceof OutsideMode) {
            CamEventHandlerClient.MC.field_1719 = camera;
            camera = null;
        }
    }
}

