/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.client.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import es.superstrellaa.cinematictools.client.SceneException;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.target.CamTarget;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.TickUtils;

public interface ClientCamCommandProcessor {
    public CamScene getScene(CommandContext<FabricClientCommandSource> var1);

    public boolean canSelectTarget();

    public void selectTarget(CommandContext<FabricClientCommandSource> var1, boolean var2) throws SceneException;

    default public void setTarget(CommandContext<FabricClientCommandSource> context, CamTarget target, boolean look) throws SceneException {
        if (look) {
            this.getScene(context).lookTarget = target;
        } else {
            this.checkFollowTarget(context, target != null);
            this.getScene(context).posTarget = target;
        }
    }

    default public void checkFollowTarget(CommandContext<FabricClientCommandSource> context, boolean shouldFollow) throws SceneException {
        CamScene scene = this.getScene(context);
        if (scene.points.isEmpty()) {
            return;
        }
        if (shouldFollow && scene.posTarget == null) {
            throw new SceneException("scene.follow.absolute_fail");
        }
        if (!shouldFollow && scene.posTarget != null) {
            throw new SceneException("scene.follow.relative_fail");
        }
    }

    public boolean canCreatePoint(CommandContext<FabricClientCommandSource> var1);

    public CamPoint createPoint(CommandContext<FabricClientCommandSource> var1);

    default public void makeRelative(CamScene scene, class_1937 level, CamPoint point) throws SceneException {
        if (scene.posTarget != null) {
            Vec3d vec = scene.posTarget.position(level, TickUtils.getFrameTime((class_1936)level));
            if (vec == null) {
                throw new SceneException("scene.follow.not_found");
            }
            point.sub(vec);
        }
    }

    public boolean requiresSceneName();

    public boolean requiresPlayer();

    public void start(CommandContext<FabricClientCommandSource> var1) throws SceneException;

    public void teleport(CommandContext<FabricClientCommandSource> var1, int var2);

    public void markDirty(CommandContext<FabricClientCommandSource> var1);

    public class_1657 getPlayer(CommandContext<FabricClientCommandSource> var1, String var2) throws CommandSyntaxException;

    public class_1297 getEntity(CommandContext<FabricClientCommandSource> var1, String var2) throws CommandSyntaxException;
}

