/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.client.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import es.superstrellaa.cinematictools.client.command.ClientCamCommandProcessor;
import es.superstrellaa.cinematictools.client.command.builder.ClientFollowArgumentBuilder;
import es.superstrellaa.cinematictools.client.command.builder.ClientPointArgumentBuilder;
import es.superstrellaa.cinematictools.client.command.builder.ClientTargetArgumentBuilder;
import es.superstrellaa.cinematictools.common.command.argument.CamModeArgument;
import es.superstrellaa.cinematictools.common.command.argument.CamPitchModeArgument;
import es.superstrellaa.cinematictools.common.command.argument.DurationArgument;
import es.superstrellaa.cinematictools.common.command.argument.InterpolationArgument;
import es.superstrellaa.cinematictools.common.math.interpolation.CamInterpolation;
import es.superstrellaa.cinematictools.common.math.interpolation.CamPitchMode;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import org.apache.logging.log4j.util.TriConsumer;

public class ClientSceneCommandBuilder {
    public static void scene(ArgumentBuilder<FabricClientCommandSource, ?> origin, ClientCamCommandProcessor processor) {
        LiteralArgumentBuilder tpO;
        RequiredArgumentBuilder original = origin;
        if (processor.requiresSceneName()) {
            origin = ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string());
        }
        origin.then(ClientCommandManager.literal((String)"clear").executes(x -> {
            processor.getScene((CommandContext<FabricClientCommandSource>)x).points.clear();
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"scene.clear"));
            return 0;
        }));
        origin.then((ArgumentBuilder)new ClientPointArgumentBuilder("add", (x, point) -> {
            processor.getScene((CommandContext<FabricClientCommandSource>)x).points.add((CamPoint)((Object)point));
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.add", (Object[])new Object[]{processor.getScene((CommandContext<FabricClientCommandSource>)x).points.size()}));
        }, processor));
        origin.then((ArgumentBuilder)new ClientPointArgumentBuilder("insert", (TriConsumer<CommandContext<FabricClientCommandSource>, CamPoint, Integer>)((TriConsumer)(x, point, index) -> {
            processor.getScene((CommandContext<FabricClientCommandSource>)x).points.add((int)index, (CamPoint)((Object)point));
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.insert", (Object[])new Object[]{index + 1}));
        }), processor));
        origin.then((ArgumentBuilder)new ClientPointArgumentBuilder("set", (TriConsumer<CommandContext<FabricClientCommandSource>, CamPoint, Integer>)((TriConsumer)(x, point, index) -> {
            processor.getScene((CommandContext<FabricClientCommandSource>)x).points.set((int)index, (CamPoint)((Object)point));
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.set", (Object[])new Object[]{index + 1}));
        }), processor));
        origin.then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            int index = IntegerArgumentType.getInteger((CommandContext)x, (String)"index") - 1;
            CamScene scene = processor.getScene((CommandContext<FabricClientCommandSource>)x);
            if (index >= 0 && index < scene.points.size()) {
                scene.points.remove(index);
            } else {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43469((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            return 0;
        })));
        origin.then(ClientCommandManager.literal((String)"duration").then(ClientCommandManager.argument((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            long duration = DurationArgument.getDuration(x, "duration");
            if (duration > 0L) {
                processor.getScene((CommandContext<FabricClientCommandSource>)x).duration = duration;
            }
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.duration", (Object[])new Object[]{duration}));
            return 0;
        })));
        origin.then(ClientCommandManager.literal((String)"loops").then(ClientCommandManager.argument((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            int loop;
            processor.getScene((CommandContext<FabricClientCommandSource>)x).loop = loop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            if (loop == 0) {
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.add", (Object[])new Object[]{processor.getScene((CommandContext<FabricClientCommandSource>)x).points.size()}));
            } else if (loop < 0) {
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"scene.loops.endless"));
            } else {
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.loops", (Object[])new Object[]{loop}));
            }
            return 0;
        })));
        LiteralArgumentBuilder tp = tpO = ClientCommandManager.literal((String)"goto");
        if (processor.requiresPlayer()) {
            tp = ClientCommandManager.argument((String)"players", (ArgumentType)class_2186.method_9308());
        }
        tp.then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(x -> {
            int index = IntegerArgumentType.getInteger((CommandContext)x, (String)"index") - 1;
            CamScene scene = processor.getScene((CommandContext<FabricClientCommandSource>)x);
            if (index >= 0 && index < scene.points.size()) {
                processor.teleport((CommandContext<FabricClientCommandSource>)x, index);
            } else {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43469((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
            return 0;
        }));
        if (processor.requiresPlayer()) {
            origin.then(tpO.then((ArgumentBuilder)tp));
        } else {
            origin.then((ArgumentBuilder)tpO);
        }
        origin.then(ClientCommandManager.literal((String)"mode").then(ClientCommandManager.argument((String)"mode", (ArgumentType)CamModeArgument.mode()).executes(x -> {
            processor.getScene((CommandContext<FabricClientCommandSource>)x).setMode(StringArgumentType.getString((CommandContext)x, (String)"mode"));
            return 0;
        })));
        origin.then((ArgumentBuilder)new ClientTargetArgumentBuilder("target", true, processor));
        origin.then((ArgumentBuilder)new ClientTargetArgumentBuilder("follow", false, processor));
        origin.then((ArgumentBuilder)new ClientFollowArgumentBuilder(CamAttribute.PITCH, processor)).then((ArgumentBuilder)new ClientFollowArgumentBuilder(CamAttribute.YAW, processor)).then((ArgumentBuilder)new ClientFollowArgumentBuilder(CamAttribute.POSITION, processor));
        origin.then(ClientCommandManager.literal((String)"interpolation").then(ClientCommandManager.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolation()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            processor.getScene((CommandContext<FabricClientCommandSource>)x).interpolation = (CamInterpolation)CamInterpolation.REGISTRY.get(interpolation);
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.interpolation", (Object[])new Object[]{interpolation}));
            return 0;
        })));
        origin.then(ClientCommandManager.literal((String)"smooth_start").then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            boolean value;
            processor.getScene((CommandContext<FabricClientCommandSource>)x).smoothBeginning = value = BoolArgumentType.getBool((CommandContext)x, (String)"value");
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.smooth_beginning", (Object[])new Object[]{value}));
            return 0;
        })));
        origin.then(ClientCommandManager.literal((String)"spinning_fix").then(ClientCommandManager.argument((String)"mode", (ArgumentType)CamPitchModeArgument.pitchMode()).executes(x -> {
            CamPitchMode mode;
            processor.getScene((CommandContext<FabricClientCommandSource>)x).pitchMode = mode = CamPitchModeArgument.getMode(x, "mode");
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.pitch_mode", (Object[])new Object[]{mode}));
            return 0;
        })));
        origin.then(ClientCommandManager.literal((String)"distance_timing").then(ClientCommandManager.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            boolean value;
            processor.getScene((CommandContext<FabricClientCommandSource>)x).distanceBasedTiming = value = BoolArgumentType.getBool((CommandContext)x, (String)"value");
            processor.markDirty((CommandContext<FabricClientCommandSource>)x);
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.distance_timing", (Object[])new Object[]{value}));
            return 0;
        })));
        if (processor.requiresSceneName()) {
            original.then((ArgumentBuilder)origin);
        }
    }
}

