/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.client.mixin;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import es.superstrellaa.cinematictools.client.EntitySelectorClient;
import io.github.fabricators_of_create.porting_lib.features.LevelExtensions;
import io.github.fabricators_of_create.porting_lib.features.entity.PartEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2096;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5575;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_2300.class})
public abstract class EntitySelectorMixin
implements EntitySelectorClient {
    @Shadow
    @Final
    private int field_10822;
    @Shadow
    @Final
    private boolean field_10830;
    @Shadow
    @Final
    private boolean field_10829;
    @Shadow
    @Final
    private Predicate<class_1297> field_10820;
    @Shadow
    @Final
    private class_2096.class_2099 field_10825;
    @Shadow
    @Final
    private Function<class_243, class_243> field_10823;
    @Shadow
    @Final
    @Nullable
    private class_238 field_10824;
    @Shadow
    @Final
    private BiConsumer<class_243, List<? extends class_1297>> field_10826;
    @Shadow
    @Final
    private boolean field_10828;
    @Shadow
    @Final
    @Nullable
    private String field_10831;
    @Shadow
    @Final
    @Nullable
    private UUID field_10821;
    @Shadow
    @Final
    private class_5575<class_1297, ?> field_10832;
    @Shadow
    @Final
    private boolean field_10827;

    @Unique
    private void checkPermissions(FabricClientCommandSource source) throws CommandSyntaxException {
        if (this.field_10827 && !source.method_9259(2)) {
            throw class_2186.field_9862.create();
        }
    }

    @Shadow
    private Predicate<class_1297> method_9817(class_243 vec) {
        return null;
    }

    @Shadow
    public abstract boolean method_9821();

    @Shadow
    private <T extends class_1297> List<T> method_9814(class_243 vec, List<T> list) {
        return null;
    }

    @Override
    public class_1297 findSingleEntityClient(FabricClientCommandSource source) throws CommandSyntaxException {
        this.checkPermissions(source);
        List<? extends class_1297> list = this.findEntitiesClient(source);
        if (list.isEmpty()) {
            throw class_2186.field_9863.create();
        }
        if (list.size() > 1) {
            throw class_2186.field_9860.create();
        }
        return list.get(0);
    }

    @Override
    public List<? extends class_1297> findEntitiesClient(FabricClientCommandSource source) throws CommandSyntaxException {
        this.checkPermissions(source);
        if (!this.field_10830) {
            return this.findPlayersClient(source);
        }
        if (this.field_10831 != null) {
            for (class_1657 player : source.getWorld().method_18456()) {
                if (!player.method_7334().getName().equalsIgnoreCase(this.field_10831)) continue;
                return Lists.newArrayList((Object[])new class_1657[]{player});
            }
            return Collections.emptyList();
        }
        if (this.field_10821 != null) {
            class_638 level = source.getWorld();
            for (class_1297 entity : level.method_18112()) {
                if (!entity.method_5667().equals(this.field_10821)) continue;
                return Lists.newArrayList((Object[])new class_1297[]{entity});
            }
            return Collections.emptyList();
        }
        class_243 vec3 = this.field_10823.apply(source.getPosition());
        Predicate<class_1297> predicate = this.method_9817(vec3);
        if (this.field_10828) {
            return source.getEntity() != null && predicate.test(source.getEntity()) ? Lists.newArrayList((Object[])new class_1297[]{source.getEntity()}) : Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        class_638 level = source.getWorld();
        if (this.field_10824 != null) {
            list.addAll(level.method_18023(this.field_10832, this.field_10824.method_997(vec3), predicate));
        } else {
            for (class_1297 entity : level.method_18112()) {
                if (predicate.test(entity)) {
                    list.add(entity);
                }
                for (PartEntity<?> p : ((LevelExtensions)level).getPartEntities()) {
                    class_1297 t = (class_1297)this.field_10832.method_31796(p);
                    if (t == null || !predicate.test(t)) continue;
                    list.add(t);
                }
            }
        }
        return this.method_9814(vec3, list);
    }

    @Override
    public class_1657 findSinglePlayerClient(FabricClientCommandSource source) throws CommandSyntaxException {
        this.checkPermissions(source);
        List<class_1657> list = this.findPlayersClient(source);
        if (list.size() != 1) {
            throw class_2186.field_9856.create();
        }
        return list.get(0);
    }

    @Override
    public List<class_1657> findPlayersClient(FabricClientCommandSource source) throws CommandSyntaxException {
        this.checkPermissions(source);
        if (this.field_10831 != null) {
            for (class_1657 player : source.getWorld().method_18456()) {
                if (!player.method_7334().getName().equalsIgnoreCase(this.field_10831)) continue;
                return Lists.newArrayList((Object[])new class_1657[]{player});
            }
            return Collections.emptyList();
        }
        if (this.field_10821 != null) {
            class_1657 player = source.getWorld().method_18470(this.field_10821);
            return player == null ? Collections.emptyList() : Lists.newArrayList((Object[])new class_1657[]{player});
        }
        class_243 vec3 = this.field_10823.apply(source.getPosition());
        Predicate<class_1297> predicate = this.method_9817(vec3);
        if (this.field_10828) {
            class_1657 player;
            class_1297 class_12972 = source.getEntity();
            if (class_12972 instanceof class_1657 && predicate.test((class_1297)(player = (class_1657)class_12972))) {
                return Lists.newArrayList((Object[])new class_1657[]{player});
            }
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (class_1657 player : source.getWorld().method_18456()) {
            if (!predicate.test((class_1297)player)) continue;
            list.add(player);
        }
        return this.method_9814(vec3, list);
    }
}

