/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.command.argument;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;

public class DurationArgument
implements ArgumentType<Long> {
    public static final List<String> EXAMPLES = Arrays.asList("10s", "30s", "1m", "500ms");

    public static DurationArgument duration() {
        return new DurationArgument();
    }

    public static long getDuration(CommandContext<?> context, String name) {
        return (Long)context.getArgument(name, Long.TYPE);
    }

    public Long parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        long time = reader.readLong();
        String type = reader.readString();
        int factor = 0;
        if (type.equalsIgnoreCase("ms")) {
            factor = 1;
        } else if (type.equalsIgnoreCase("s")) {
            factor = 1000;
        } else if (type.equalsIgnoreCase("m")) {
            factor = 60000;
        } else if (type.equalsIgnoreCase("h")) {
            factor = 3600000;
        } else if (type.equalsIgnoreCase("d")) {
            factor = 86400000;
        } else {
            reader.setCursor(start);
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid time format try out 10s (for 10 seconds)")), (Message)class_2561.method_43471((String)"invalid_time_format"));
        }
        return time * (long)factor;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

