/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import es.superstrellaa.cinematictools.client.SceneException;
import es.superstrellaa.cinematictools.common.command.CamCommandProcessor;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import java.util.function.BiConsumer;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.apache.logging.log4j.util.TriConsumer;

public class PointArgumentBuilder
extends ArgumentBuilder<class_2168, PointArgumentBuilder> {
    private final String literal;
    private final TriConsumer<CommandContext<class_2168>, CamPoint, Integer> indexConsumer;
    private final BiConsumer<CommandContext<class_2168>, CamPoint> consumer;
    private final CamCommandProcessor processor;

    public PointArgumentBuilder(String literal, TriConsumer<CommandContext<class_2168>, CamPoint, Integer> consumer, CamCommandProcessor processor) {
        this.literal = literal;
        this.indexConsumer = consumer;
        this.consumer = null;
        this.processor = processor;
    }

    public PointArgumentBuilder(String literal, BiConsumer<CommandContext<class_2168>, CamPoint> consumer, CamCommandProcessor processor) {
        this.literal = literal;
        this.indexConsumer = null;
        this.consumer = consumer;
        this.processor = processor;
    }

    public String getLiteral() {
        return this.literal;
    }

    protected PointArgumentBuilder getThis() {
        return this;
    }

    private void processPoint(CommandContext<class_2168> x, CamPoint point) {
        if (this.indexConsumer != null) {
            int index = IntegerArgumentType.getInteger(x, (String)"index") - 1;
            CamScene scene = this.processor.getScene(x);
            if (index >= 0 && index < scene.points.size()) {
                this.indexConsumer.accept(x, (Object)point, (Object)index);
            } else {
                ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43469((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
        } else {
            this.consumer.accept(x, point);
        }
    }

    public CommandNode<class_2168> build() {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)this.literal);
        if (this.indexConsumer != null) {
            builder.then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
                if (this.processor.canCreatePoint((CommandContext<class_2168>)x)) {
                    CamPoint point = this.processor.createPoint((CommandContext<class_2168>)x);
                    CamScene scene = this.processor.getScene((CommandContext<class_2168>)x);
                    if (scene.posTarget != null) {
                        try {
                            this.processor.makeRelative(this.processor.getScene((CommandContext<class_2168>)x), (class_1937)((class_2168)x.getSource()).method_9225(), point);
                        }
                        catch (SceneException e) {
                            ((class_2168)x.getSource()).method_9213(e.getComponent());
                        }
                    }
                    this.processPoint((CommandContext<class_2168>)x, point);
                }
                return 0;
            }));
        } else {
            builder.executes(x -> {
                if (this.processor.canCreatePoint((CommandContext<class_2168>)x)) {
                    CamPoint point = this.processor.createPoint((CommandContext<class_2168>)x);
                    CamScene scene = this.processor.getScene((CommandContext<class_2168>)x);
                    if (scene.posTarget != null) {
                        try {
                            this.processor.makeRelative(this.processor.getScene((CommandContext<class_2168>)x), (class_1937)((class_2168)x.getSource()).method_9225(), point);
                        }
                        catch (SceneException e) {
                            ((class_2168)x.getSource()).method_9213(e.getComponent());
                        }
                    }
                    this.processPoint((CommandContext<class_2168>)x, point);
                }
                return 0;
            });
        }
        builder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(x -> {
            class_243 vec = class_2277.method_9736((CommandContext)x, (String)"location");
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0, 70.0);
            this.processPoint((CommandContext<class_2168>)x, point);
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(x -> {
            class_243 vec = class_2277.method_9736((CommandContext)x, (String)"location");
            class_241 rotation = class_2270.method_9716((CommandContext)x, (String)"rotation").method_9709((class_2168)x.getSource());
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, rotation.field_1342, rotation.field_1343, 0.0, 70.0);
            this.processPoint((CommandContext<class_2168>)x, point);
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"roll", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            class_243 vec = class_2277.method_9736((CommandContext)x, (String)"location");
            class_241 rotation = class_2270.method_9716((CommandContext)x, (String)"rotation").method_9709((class_2168)x.getSource());
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, rotation.field_1342, rotation.field_1343, DoubleArgumentType.getDouble((CommandContext)x, (String)"roll"), 70.0);
            this.processPoint((CommandContext<class_2168>)x, point);
            return 0;
        })).then(class_2170.method_9244((String)"fov", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            class_243 vec = class_2277.method_9736((CommandContext)x, (String)"location");
            class_241 rotation = class_2270.method_9716((CommandContext)x, (String)"rotation").method_9709((class_2168)x.getSource());
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, rotation.field_1342, rotation.field_1343, DoubleArgumentType.getDouble((CommandContext)x, (String)"roll"), DoubleArgumentType.getDouble((CommandContext)x, (String)"fov"));
            this.processPoint((CommandContext<class_2168>)x, point);
            return 0;
        })))));
        return builder.build();
    }
}

