/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import es.superstrellaa.cinematictools.client.CinematicToolsClient;
import es.superstrellaa.cinematictools.common.command.CamCommandProcessor;
import es.superstrellaa.cinematictools.common.command.argument.CamModeArgument;
import es.superstrellaa.cinematictools.common.command.argument.CamPitchModeArgument;
import es.superstrellaa.cinematictools.common.command.argument.DurationArgument;
import es.superstrellaa.cinematictools.common.command.argument.InterpolationArgument;
import es.superstrellaa.cinematictools.common.command.builder.FollowArgumentBuilder;
import es.superstrellaa.cinematictools.common.command.builder.PointArgumentBuilder;
import es.superstrellaa.cinematictools.common.command.builder.TargetArgumentBuilder;
import es.superstrellaa.cinematictools.common.math.interpolation.CamInterpolation;
import es.superstrellaa.cinematictools.common.math.interpolation.CamPitchMode;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import org.apache.logging.log4j.util.TriConsumer;

public class SceneCommandBuilder {
    public static void scene(ArgumentBuilder<class_2168, ?> origin, CamCommandProcessor processor) {
        LiteralArgumentBuilder tpO;
        RequiredArgumentBuilder original = origin;
        if (processor.requiresSceneName()) {
            origin = class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string());
        }
        origin.then(class_2170.method_9247((String)"clear").executes(x -> {
            processor.getScene((CommandContext<class_2168>)x).points.clear();
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43471((String)"scene.clear"), false);
            return 0;
        }));
        origin.then((ArgumentBuilder)new PointArgumentBuilder("add", (x, point) -> {
            processor.getScene((CommandContext<class_2168>)x).points.add((CamPoint)((Object)point));
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.add", (Object[])new Object[]{processor.getScene((CommandContext<class_2168>)x).points.size()}), false);
        }, processor));
        origin.then((ArgumentBuilder)new PointArgumentBuilder("insert", (TriConsumer<CommandContext<class_2168>, CamPoint, Integer>)((TriConsumer)(x, point, index) -> {
            processor.getScene((CommandContext<class_2168>)x).points.add((int)index, (CamPoint)((Object)point));
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.insert", (Object[])new Object[]{index + 1}), false);
        }), processor));
        origin.then((ArgumentBuilder)new PointArgumentBuilder("set", (TriConsumer<CommandContext<class_2168>, CamPoint, Integer>)((TriConsumer)(x, point, index) -> {
            processor.getScene((CommandContext<class_2168>)x).points.set((int)index, (CamPoint)((Object)point));
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.set", (Object[])new Object[]{index + 1}), false);
        }), processor));
        origin.then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
            int index = IntegerArgumentType.getInteger((CommandContext)x, (String)"index") - 1;
            CamScene scene = processor.getScene((CommandContext<class_2168>)x);
            if (index >= 0 && index < scene.points.size()) {
                scene.points.remove(index);
            } else {
                ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43469((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
            processor.markDirty((CommandContext<class_2168>)x);
            return 0;
        })));
        origin.then(class_2170.method_9247((String)"duration").then(class_2170.method_9244((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            long duration = DurationArgument.getDuration(x, "duration");
            if (duration > 0L) {
                processor.getScene((CommandContext<class_2168>)x).duration = duration;
            }
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.duration", (Object[])new Object[]{duration}), false);
            return 0;
        })));
        origin.then(class_2170.method_9247((String)"loops").then(class_2170.method_9244((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            int loop;
            processor.getScene((CommandContext<class_2168>)x).loop = loop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
            processor.markDirty((CommandContext<class_2168>)x);
            if (loop == 0) {
                ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.add", (Object[])new Object[]{processor.getScene((CommandContext<class_2168>)x).points.size()}), false);
            } else if (loop < 0) {
                ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43471((String)"scene.loops.endless"), false);
            } else {
                ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.loops", (Object[])new Object[]{loop}), false);
            }
            return 0;
        })));
        LiteralArgumentBuilder tp = tpO = class_2170.method_9247((String)"goto");
        if (processor.requiresPlayer()) {
            tp = class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308());
        }
        tp.then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(x -> {
            if (!CinematicToolsClient.isOp) {
                ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            int index = IntegerArgumentType.getInteger((CommandContext)x, (String)"index") - 1;
            CamScene scene = processor.getScene((CommandContext<class_2168>)x);
            if (index >= 0 && index < scene.points.size()) {
                processor.teleport((CommandContext<class_2168>)x, index);
            } else {
                ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43469((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
            return 0;
        }));
        if (processor.requiresPlayer()) {
            origin.then(tpO.then((ArgumentBuilder)tp));
        } else {
            origin.then((ArgumentBuilder)tpO);
        }
        origin.then(class_2170.method_9247((String)"mode").then(class_2170.method_9244((String)"mode", (ArgumentType)CamModeArgument.mode()).executes(x -> {
            processor.getScene((CommandContext<class_2168>)x).setMode(StringArgumentType.getString((CommandContext)x, (String)"mode"));
            return 0;
        })));
        origin.then((ArgumentBuilder)new TargetArgumentBuilder("target", true, processor));
        origin.then((ArgumentBuilder)new TargetArgumentBuilder("follow", false, processor));
        origin.then((ArgumentBuilder)new FollowArgumentBuilder(CamAttribute.PITCH, processor)).then((ArgumentBuilder)new FollowArgumentBuilder(CamAttribute.YAW, processor)).then((ArgumentBuilder)new FollowArgumentBuilder(CamAttribute.POSITION, processor));
        origin.then(class_2170.method_9247((String)"interpolation").then(class_2170.method_9244((String)"interpolation", (ArgumentType)InterpolationArgument.interpolation()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            processor.getScene((CommandContext<class_2168>)x).interpolation = (CamInterpolation)CamInterpolation.REGISTRY.get(interpolation);
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.interpolation", (Object[])new Object[]{interpolation}), false);
            return 0;
        })));
        origin.then(class_2170.method_9247((String)"smooth_start").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            boolean value;
            processor.getScene((CommandContext<class_2168>)x).smoothBeginning = value = BoolArgumentType.getBool((CommandContext)x, (String)"value");
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.smooth_beginning", (Object[])new Object[]{value}), false);
            return 0;
        })));
        origin.then(class_2170.method_9247((String)"spinning_fix").then(class_2170.method_9244((String)"mode", (ArgumentType)CamPitchModeArgument.pitchMode()).executes(x -> {
            CamPitchMode mode;
            processor.getScene((CommandContext<class_2168>)x).pitchMode = mode = CamPitchModeArgument.getMode(x, "mode");
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.pitch_mode", (Object[])new Object[]{mode}), false);
            return 0;
        })));
        origin.then(class_2170.method_9247((String)"distance_timing").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(x -> {
            boolean value;
            processor.getScene((CommandContext<class_2168>)x).distanceBasedTiming = value = BoolArgumentType.getBool((CommandContext)x, (String)"value");
            processor.markDirty((CommandContext<class_2168>)x);
            ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.distance_timing", (Object[])new Object[]{value}), false);
            return 0;
        })));
        if (processor.requiresSceneName()) {
            original.then((ArgumentBuilder)origin);
        }
    }
}

