/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.math.interpolation;

import es.superstrellaa.cinematictools.common.math.interpolation.CircularCamInterpolation;
import es.superstrellaa.cinematictools.common.math.interpolation.CircularInterpolation;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import es.superstrellaa.cinematictools.common.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class ClientCircularCamInterpolation
extends CircularCamInterpolation {
    public ClientCircularCamInterpolation(boolean clockwise) {
        super(clockwise);
    }

    @Environment(value=EnvType.CLIENT)
    public <T extends VecNd> Interpolation<T> createClient(double[] timed, CamScene scene, T before, List<T> points, T after, CamAttribute<T> attribute) {
        return (Interpolation)EnvExecutor.safeCallWhenOn(EnvType.CLIENT, () -> () -> {
            class_310 mc = class_310.method_1551();
            Vec3d center = scene.lookTarget.position((class_1937)mc.field_1687, mc.method_1534());
            if (center != null) {
                List points3 = points;
                points.add((VecNd)points.get(0));
                Vec3d firstPoint = new Vec3d(((Vec3d)points3.get((int)0)).x, ((Vec3d)points3.get((int)0)).y, ((Vec3d)points3.get((int)0)).z);
                Vec3d centerPoint = new Vec3d(center.x, center.y, center.z);
                Vec3d sphereOrigin = new Vec3d(firstPoint);
                sphereOrigin.sub(centerPoint);
                double radius = sphereOrigin.length();
                ArrayList<Vec1d> vecs = new ArrayList<Vec1d>();
                ArrayList<Double> times = new ArrayList<Double>();
                times.add(0.0);
                vecs.add(new Vec1d(firstPoint.y));
                ArrayList<Vec3d> newPointsSorted = new ArrayList<Vec3d>();
                newPointsSorted.add((Vec3d)points3.get(0));
                for (int i = 1; i < points.size() - 1; ++i) {
                    Vec3d point = new Vec3d(((Vec3d)points3.get((int)i)).x, firstPoint.y, ((Vec3d)points3.get((int)i)).z);
                    point.sub(centerPoint);
                    double dot = point.dot(sphereOrigin);
                    double det = point.x * sphereOrigin.z - point.z * sphereOrigin.x;
                    double angle = Math.toDegrees(Math.atan2(det, dot));
                    if (angle < 0.0) {
                        angle += 360.0;
                    }
                    double time = angle / 360.0;
                    if (!this.clockwise) {
                        time = 1.0 - time;
                    }
                    for (int j = 0; j < times.size(); ++j) {
                        if (!((Double)times.get(j) > time)) continue;
                        times.add(j, time);
                        vecs.add(j, new Vec1d(((Vec3d)points3.get((int)i)).y));
                        newPointsSorted.add(j, (Vec3d)points3.get(i));
                        break;
                    }
                    newPointsSorted.add((Vec3d)points3.get(i));
                    times.add(time);
                    vecs.add(new Vec1d(((Vec3d)points3.get((int)i)).y));
                }
                if (scene.loop == 0) {
                    newPointsSorted.add(((Vec3d)newPointsSorted.get(0)).copy());
                }
                times.add(1.0);
                vecs.add(new Vec1d(firstPoint.y));
                return new CircularInterpolation(this.clockwise, points, scene.lookTarget, sphereOrigin, radius, (HermiteInterpolation<Vec1d>)new HermiteInterpolation(ArrayUtils.toPrimitive((Double[])times.toArray(new Double[0])), (VecNd[])vecs.toArray(new Vec1d[0])));
            }
            return null;
        });
    }

    @Override
    public <T extends VecNd> Interpolation<T> create(double[] timed, CamScene scene, T before, List<T> points, T after, CamAttribute<T> attribute) {
        return (Interpolation)EnvExecutor.safeCallWhenOn(EnvType.CLIENT, () -> () -> {
            Interpolation<VecNd> result;
            if (attribute == CamAttribute.POSITION && scene.lookTarget != null && (result = this.createClient(timed, scene, before, points, after, attribute)) != null) {
                return result;
            }
            return new HermiteInterpolation(points);
        });
    }
}

