/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.math.point;

import es.superstrellaa.cinematictools.common.math.interpolation.CamPitchMode;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_3532;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.type.itr.ConsecutiveIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;

public class CamPoints
implements Iterable<CamPoint> {
    private CamPoint before;
    private List<CamPoint> content;
    private CamPoint after;

    public CamPoints(Collection<CamPoint> collection) {
        this.content = new ArrayList<CamPoint>(collection);
    }

    public CamPoints() {
        this.content = new ArrayList<CamPoint>();
    }

    public boolean add(CamPoint point) {
        return this.content.add(point);
    }

    public boolean addAll(Collection<CamPoint> points) {
        return this.content.addAll(points);
    }

    public CamPoint before() {
        return this.before;
    }

    public void before(CamPoint point) {
        this.before = point;
    }

    public CamPoint after() {
        return this.after;
    }

    public void after(CamPoint point) {
        this.after = point;
    }

    public void fixSpinning(CamPitchMode mode) {
        if (mode == CamPitchMode.FIX) {
            this.fixSpinning();
        } else if (mode == CamPitchMode.FIX_KEEP_DIRECTION) {
            this.fixSpinningKeepDirection();
        }
    }

    public void fixSpinning() {
        double wrappedYaw = 180.0;
        double lastYaw = 0.0;
        Iterator<CamPoint> iterator = this.iteratorAll();
        while (iterator.hasNext()) {
            double leftDistance;
            double rightDistance;
            CamPoint point = iterator.next();
            double wrappedYawCurrent = class_3532.method_15338((double)point.rotationYaw) + 180.0;
            if (wrappedYaw > wrappedYawCurrent) {
                rightDistance = 360.0 - wrappedYaw + wrappedYawCurrent;
                leftDistance = wrappedYaw - wrappedYawCurrent;
            } else {
                rightDistance = wrappedYawCurrent - wrappedYaw;
                leftDistance = 360.0 - wrappedYawCurrent + wrappedYaw;
            }
            lastYaw = rightDistance < leftDistance ? (lastYaw += rightDistance) : (lastYaw -= leftDistance);
            wrappedYaw = wrappedYawCurrent;
            point.rotationYaw = lastYaw;
        }
    }

    public void fixSpinningKeepDirection() {
        double lastYaw = 0.0;
        double originalYaw = 0.0;
        Iterator<CamPoint> iterator = this.iteratorAll();
        while (iterator.hasNext()) {
            CamPoint point = iterator.next();
            originalYaw = point.rotationYaw;
            point.rotationYaw = lastYaw += (point.rotationYaw - originalYaw) % 360.0;
        }
    }

    @Override
    public Iterator<CamPoint> iterator() {
        return this.content.iterator();
    }

    public Iterator<CamPoint> iteratorAll() {
        return new ConsecutiveIterator(new Iterator[]{new SingleIterator((Object)this.before), this.content.iterator(), new SingleIterator((Object)this.after)});
    }

    public double estimateLength() {
        double distance = 0.0;
        for (int i = 0; i < this.content.size() - 1; ++i) {
            distance += this.content.get(i).distance(this.content.get(i + 1));
        }
        return distance;
    }

    public <T extends VecNd> Interpolation<T> interpolate(double[] times, CamScene scene, CamAttribute<T> attribute) {
        ArrayList<T> vecs = new ArrayList<T>(this.content.size());
        for (CamPoint point : this.content) {
            vecs.add(attribute.get(point));
        }
        Interpolation<Object> inter = scene.interpolation.create(times, scene, this.before != null ? (VecNd)attribute.get(this.before) : null, vecs, this.after != null ? (VecNd)attribute.get(this.after) : null, attribute);
        return inter;
    }

    public double[] createTimes(CamScene scene) {
        double stepLength;
        double endTime;
        double[] times = new double[this.size()];
        double startTime = 0.0;
        times[times.length - 1] = endTime = 1.0;
        double time = stepLength = 1.0 / (double)(this.size() - 1);
        if (this.size() > 2) {
            for (int i = 1; i < times.length - 1; ++i) {
                times[i] = time;
                time += stepLength;
            }
        } else {
            return times;
        }
        if (scene.distanceBasedTiming) {
            Interpolation<Vec3d> inter = this.interpolate(times, scene, CamAttribute.POSITION);
            double[] data = inter.estimateDistance();
            double totalDistance = data[0];
            double duration = endTime - startTime;
            double speed = duration / totalDistance;
            time = startTime;
            for (int i = 1; i < data.length - 1; ++i) {
                times[i] = time += data[i] * speed;
            }
        }
        return times;
    }

    public int size() {
        return this.content.size();
    }
}

