/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.mod.minema;

import es.superstrellaa.cinematictools.common.mod.minema.MinemaAddon;
import es.superstrellaa.cinematictools.common.scene.timer.RunTimer;
import java.util.concurrent.TimeUnit;

public class MinemaTimer
extends RunTimer {
    private long lastResumed = System.currentTimeMillis();
    private long timeSinceLastStage = 0L;
    private long timePlayed;

    @Override
    public long position(boolean running, float partialTick) {
        if (MinemaAddon.isCapturing()) {
            return TimeUnit.NANOSECONDS.toMillis(MinemaAddon.getVideoTime() - this.timeSinceLastStage);
        }
        if (running) {
            return this.timePlayed + (System.currentTimeMillis() - this.lastResumed);
        }
        return this.timePlayed;
    }

    @Override
    public void pause() {
        if (MinemaAddon.isCapturing()) {
            MinemaAddon.pauseCapture();
        } else {
            this.timePlayed += System.currentTimeMillis() - this.lastResumed;
        }
    }

    @Override
    public void resume() {
        if (MinemaAddon.isCapturing()) {
            MinemaAddon.resumeCapture();
        } else {
            this.lastResumed = System.currentTimeMillis();
        }
    }

    @Override
    public void tick(boolean running) {
    }

    @Override
    public void stageCompleted() {
        if (MinemaAddon.isCapturing()) {
            this.timeSinceLastStage = MinemaAddon.getVideoTime();
        } else {
            this.lastResumed = System.currentTimeMillis();
        }
    }
}

