/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.scene.mode;

import es.superstrellaa.cinematictools.client.CamEventHandlerClient;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.scene.mode.ClientDefaultMode;
import es.superstrellaa.cinematictools.common.scene.mode.DefaultMode;
import es.superstrellaa.cinematictools.common.scene.mode.OutsideMode;
import es.superstrellaa.cinematictools.common.scene.run.CamRun;
import es.superstrellaa.cinematictools.common.utils.EnvExecutor;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CamMode {
    public static final NamedTypeRegistry<CamMode> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[]{CamScene.class});
    public final CamScene scene;

    public CamMode(CamScene scene) {
        this.scene = scene;
    }

    public void started(CamRun run) {
    }

    public void finished(CamRun run) {
        EnvExecutor.safeRunWhenOn(EnvType.CLIENT, () -> () -> {
            CamEventHandlerClient.resetFOV();
            CamEventHandlerClient.resetRoll();
        });
    }

    public abstract class_1297 getCamera();

    public void process(CamPoint point) {
        EnvExecutor.safeRunWhenOn(EnvType.CLIENT, () -> () -> {
            CamEventHandlerClient.roll((float)point.roll);
            CamEventHandlerClient.fov(point.zoom);
            class_1297 camera = this.getCamera();
            if (camera instanceof class_1657) {
                ((class_1657)camera).method_31549().field_7479 = true;
            }
            camera.method_5641(point.x, point.y - (double)camera.method_5751(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
            camera.field_5982 = (float)point.rotationYaw;
            camera.field_6004 = (float)point.rotationPitch;
            camera.method_5808(point.x, point.y - (double)camera.method_5751(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
        });
    }

    public abstract boolean outside();

    public void correctTargetPosition(Vec3d vec) {
    }

    static {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            REGISTRY.register("default", ClientDefaultMode.class);
        } else {
            REGISTRY.register("default", DefaultMode.class);
        }
        REGISTRY.register("outside", OutsideMode.class);
    }
}

