/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import es.superstrellaa.cinematictools.CinematicToolsConfig;
import es.superstrellaa.cinematictools.common.command.argument.CamModeArgument;
import es.superstrellaa.cinematictools.common.command.argument.CamPitchModeArgument;
import es.superstrellaa.cinematictools.common.command.argument.DurationArgument;
import es.superstrellaa.cinematictools.common.command.argument.InterpolationArgument;
import es.superstrellaa.cinematictools.common.command.builder.SceneCommandBuilder;
import es.superstrellaa.cinematictools.common.command.builder.SceneStartCommandBuilder;
import es.superstrellaa.cinematictools.common.entity.ModEntities;
import es.superstrellaa.cinematictools.common.entity.NPCEntity;
import es.superstrellaa.cinematictools.common.network.ServerPacketHandler;
import es.superstrellaa.cinematictools.common.packet.ConnectPacket;
import es.superstrellaa.cinematictools.common.packet.GetPathPacket;
import es.superstrellaa.cinematictools.common.packet.PausePathPacket;
import es.superstrellaa.cinematictools.common.packet.ResumePathPacket;
import es.superstrellaa.cinematictools.common.packet.SetPathPacket;
import es.superstrellaa.cinematictools.common.packet.StartPathPacket;
import es.superstrellaa.cinematictools.common.packet.StopPathPacket;
import es.superstrellaa.cinematictools.common.packet.TeleportPathPacket;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.common.utils.DolphinLogger;
import es.superstrellaa.cinematictools.fabric.ArgumentTypeInfosHelper;
import es.superstrellaa.cinematictools.server.CamEventHandler;
import es.superstrellaa.cinematictools.server.CinematicToolsServer;
import io.github.fabricators_of_create.porting_lib.features.LevelExtensions;
import io.github.fabricators_of_create.porting_lib.features.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.features.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.features.registry.LazyRegistrar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import net.neoforged.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.network.CreativePacket;

@Mod(value="cinematictools")
public class CinematicTools
implements ModInitializer {
    public static final String MODID = "cinematictools";
    private static final Logger LOGGER = LogManager.getLogger((String)"cinematictools");
    public static final CreativeNetwork NETWORK = new CreativeNetwork(1, LOGGER, new class_2960("cinematictools", "main"));
    public static final CinematicToolsConfig CONFIG = new CinematicToolsConfig();
    public static final LazyRegistrar<class_2314<?, ?>> COMMAND_ARGUMENT_TYPES = LazyRegistrar.create(class_7924.field_41262, "cinematictools");
    public static final Map<String, NPCEntity> npcMap = new HashMap<String, NPCEntity>();

    private void initPartEntity() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            PartEntity<?>[] parts;
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity() && (parts = partEntity.getParts()) != null) {
                for (PartEntity<?> part : parts) {
                    ((LevelExtensions)world).getPartEntityMap().put(part.method_5628(), part);
                }
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            PartEntity<?>[] parts;
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity() && (parts = partEntity.getParts()) != null) {
                for (PartEntity<?> part : parts) {
                    ((LevelExtensions)world).getPartEntityMap().remove(part.method_5628());
                }
            }
        });
    }

    public void onInitialize() {
        ServerPacketHandler.registerPackets();
        DolphinLogger.logModInfo();
        ModEntities.registerAttributes();
        this.initPartEntity();
        this.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.commands((CommandDispatcher<class_2168>)dispatcher));
        COMMAND_ARGUMENT_TYPES.register("duration", (class_2314<?, ?>)((Supplier<class_2319>)() -> ArgumentTypeInfosHelper.registerByClass(DurationArgument.class, class_2319.method_41999(() -> DurationArgument.duration()))));
        COMMAND_ARGUMENT_TYPES.register("cam_mode", (class_2314<?, ?>)((Supplier<class_2319>)() -> ArgumentTypeInfosHelper.registerByClass(CamModeArgument.class, class_2319.method_41999(() -> CamModeArgument.mode()))));
        COMMAND_ARGUMENT_TYPES.register("interpolation", (class_2314<?, ?>)((Supplier<class_2319>)() -> ArgumentTypeInfosHelper.registerByClass(InterpolationArgument.class, class_2319.method_41999(() -> InterpolationArgument.interpolation()))));
        COMMAND_ARGUMENT_TYPES.register("all_interpolation", (class_2314<?, ?>)((Supplier<class_2319>)() -> ArgumentTypeInfosHelper.registerByClass(InterpolationArgument.AllInterpolationArgument.class, class_2319.method_41999(() -> InterpolationArgument.interpolationAll()))));
        COMMAND_ARGUMENT_TYPES.register("pitch_mode", (class_2314<?, ?>)((Supplier<class_2319>)() -> ArgumentTypeInfosHelper.registerByClass(CamPitchModeArgument.class, class_2319.method_41999(() -> CamPitchModeArgument.pitchMode()))));
        COMMAND_ARGUMENT_TYPES.register();
        DolphinLogger.info("CinematicTools from Utils loaded successfully!");
    }

    private void init() {
        NETWORK.registerType(ConnectPacket.class, ConnectPacket::new);
        NETWORK.registerType(GetPathPacket.class, GetPathPacket::new);
        NETWORK.registerType(SetPathPacket.class, SetPathPacket::new);
        NETWORK.registerType(StartPathPacket.class, StartPathPacket::new);
        NETWORK.registerType(StopPathPacket.class, StopPathPacket::new);
        NETWORK.registerType(TeleportPathPacket.class, TeleportPathPacket::new);
        NETWORK.registerType(PausePathPacket.class, PausePathPacket::new);
        NETWORK.registerType(ResumePathPacket.class, ResumePathPacket::new);
        new CamEventHandler();
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
    }

    private void commands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder camServer = class_2170.method_9247((String)"cinematic-server");
        LiteralArgumentBuilder npcCommand = class_2170.method_9247((String)"npc");
        npcCommand.then(class_2170.method_9247((String)"summon").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                class_2168 source = (class_2168)context.getSource();
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                class_243 position = source.method_9222();
                float yaw = source.method_9210().field_1342;
                float pitch = source.method_9210().field_1343;
                return this.summonNPC(source, name, position, yaw, pitch);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                class_2168 source = (class_2168)context.getSource();
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                class_243 position = class_2277.method_9736((CommandContext)context, (String)"pos");
                float yaw = source.method_9210().field_1342;
                float pitch = source.method_9210().field_1343;
                return this.summonNPC(source, name, position, yaw, pitch);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })).then(class_2170.method_9244((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)-180.0f, (float)180.0f)).then(class_2170.method_9244((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                class_2168 source = (class_2168)context.getSource();
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                class_243 position = class_2277.method_9736((CommandContext)context, (String)"pos");
                float yaw = FloatArgumentType.getFloat((CommandContext)context, (String)"yaw");
                float pitch = FloatArgumentType.getFloat((CommandContext)context, (String)"pitch");
                return this.summonNPC(source, name, position, yaw, pitch);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))))));
        npcCommand.then(class_2170.method_9247((String)"walk").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                class_2168 source = (class_2168)context.getSource();
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                class_243 position = class_2277.method_9736((CommandContext)context, (String)"pos");
                return this.walkNPC(source, name, position);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))));
        npcCommand.then(class_2170.method_9247((String)"run").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                class_2168 source = (class_2168)context.getSource();
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                class_243 position = class_2277.method_9736((CommandContext)context, (String)"pos");
                return this.runNPC(source, name, position);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))));
        npcCommand.then(class_2170.method_9247((String)"jump").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                class_2168 source = (class_2168)context.getSource();
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                return this.jumpNPC(source, name);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })));
        npcCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"animation").then(class_2170.method_9247((String)"play").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"animation", (ArgumentType)StringArgumentType.string()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                String animation = StringArgumentType.getString((CommandContext)context, (String)"animation");
                return this.playAnimation((class_2168)context.getSource(), name, animation);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))))).then(class_2170.method_9247((String)"stop").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"animation", (ArgumentType)StringArgumentType.string()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                String animation = StringArgumentType.getString((CommandContext)context, (String)"animation");
                return this.stopAnimation((class_2168)context.getSource(), name, animation);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))))).then(class_2170.method_9247((String)"resume").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"animation", (ArgumentType)StringArgumentType.string()).executes(context -> {
            if (((class_2168)context.getSource()).method_9259(2)) {
                String name = StringArgumentType.getString((CommandContext)context, (String)"name");
                String animation = StringArgumentType.getString((CommandContext)context, (String)"animation");
                return this.resumeAnimation((class_2168)context.getSource(), name, animation);
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })))));
        camServer.then((ArgumentBuilder)npcCommand);
        SceneStartCommandBuilder.start(camServer, CinematicToolsServer.PROCESSOR);
        LiteralArgumentBuilder get = class_2170.method_9247((String)"get");
        SceneCommandBuilder.scene(get, CinematicToolsServer.PROCESSOR);
        camServer.then((ArgumentBuilder)get);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)camServer.then(class_2170.method_9247((String)"stop").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                StopPathPacket packet = new StopPathPacket();
                for (class_3222 player : class_2186.method_9312((CommandContext)x, (String)"players")) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })))).then(class_2170.method_9247((String)"pause").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                PausePathPacket packet = new PausePathPacket();
                for (class_3222 player : class_2186.method_9312((CommandContext)x, (String)"players")) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })))).then(class_2170.method_9247((String)"resume").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                ResumePathPacket packet = new ResumePathPacket();
                for (class_3222 player : class_2186.method_9312((CommandContext)x, (String)"players")) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })))).then(class_2170.method_9247((String)"list").executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                Collection<String> names = CinematicToolsServer.getSavedPaths((class_1937)((class_2168)x.getSource()).method_9225());
                ((class_2168)x.getSource()).method_45068((class_2561)class_2561.method_43469((String)"scenes.list", (Object[])new Object[]{names.size(), String.join((CharSequence)", ", names)}));
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))).then(class_2170.method_9247((String)"clear").executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                CinematicToolsServer.clearPaths((class_1937)((class_2168)x.getSource()).method_9225());
                ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43471((String)"scenes.clear"), true);
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                String name = StringArgumentType.getString((CommandContext)x, (String)"name");
                if (CinematicToolsServer.removePath((class_1937)((class_2168)x.getSource()).method_9225(), name)) {
                    ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.remove", (Object[])new Object[]{name}), true);
                } else {
                    ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43469((String)"scene.remove_fail", (Object[])new Object[]{name}));
                }
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        })))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            if (((class_2168)x.getSource()).method_9259(2)) {
                String name = StringArgumentType.getString((CommandContext)x, (String)"name");
                if (CinematicToolsServer.get((class_1937)((class_2168)x.getSource()).method_9225(), name) != null) {
                    ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.exists", (Object[])new Object[]{name}), true);
                } else {
                    CinematicToolsServer.set((class_1937)((class_2168)x.getSource()).method_9225(), name, CamScene.createDefault());
                    ((class_2168)x.getSource()).method_9226(() -> class_2561.method_43469((String)"scene.create", (Object[])new Object[]{name}), true);
                }
                return 0;
            }
            ((class_2168)x.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
            return 0;
        }))));
    }

    private int playAnimation(class_2168 source, String name, String animation) {
        class_3218 level = source.method_9225();
        NPCEntity npc = this.findNPCByName(name);
        if (npc == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"npc.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        npc.playAnimation(animation);
        source.method_9226(() -> class_2561.method_43469((String)"npc.animation.success", (Object[])new Object[]{name, animation}), true);
        return 1;
    }

    private int stopAnimation(class_2168 source, String name, String animation) {
        class_3218 level = source.method_9225();
        NPCEntity npc = this.findNPCByName(name);
        if (npc == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"npc.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        npc.stopAnimation();
        source.method_9226(() -> class_2561.method_43469((String)"npc.animation.stopped", (Object[])new Object[]{name}), true);
        return 1;
    }

    private int resumeAnimation(class_2168 source, String name, String animation) {
        class_3218 level = source.method_9225();
        NPCEntity npc = this.findNPCByName(name);
        if (npc == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"npc.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        npc.resumeAnimation();
        source.method_9226(() -> class_2561.method_43469((String)"npc.animation.resumed", (Object[])new Object[]{name}), true);
        return 1;
    }

    private int summonNPC(class_2168 source, String name, class_243 position, float yaw, float pitch) {
        class_3218 level = source.method_9225();
        double x = position.method_10216();
        double y = position.method_10214();
        double z = position.method_10215();
        NPCEntity npc = new NPCEntity(ModEntities.NPC, (class_1937)level);
        npc.method_5814(x, y, z);
        npc.method_36456(yaw);
        npc.method_36457(pitch);
        npc.setName(name);
        npc.setSkinURL("https://mc-heads.net/skin/" + name + ".png");
        level.method_8649((class_1297)npc);
        npcMap.put(name, npc);
        source.method_9226(() -> class_2561.method_43469((String)"npc.summon.success", (Object[])new Object[]{name, x, y, z, Float.valueOf(yaw), Float.valueOf(pitch)}), true);
        return 1;
    }

    private int walkNPC(class_2168 source, String name, class_243 position) {
        class_3218 level = source.method_9225();
        NPCEntity npc = this.findNPCByName(name);
        if (npc == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"npc.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        double x = position.method_10216();
        double y = position.method_10214();
        double z = position.method_10215();
        npc.setRunning(false);
        npc.method_5942().method_6337(x, y, z, 1.0);
        source.method_9226(() -> class_2561.method_43469((String)"npc.walk.success", (Object[])new Object[]{name, x, y, z}), true);
        return 1;
    }

    private int runNPC(class_2168 source, String name, class_243 position) {
        class_3218 level = source.method_9225();
        NPCEntity npc = this.findNPCByName(name);
        if (npc == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"npc.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        double x = position.method_10216();
        double y = position.method_10214();
        double z = position.method_10215();
        npc.method_5942().method_6337(x, y, z, 1.5);
        npc.setRunning(true);
        source.method_9226(() -> class_2561.method_43469((String)"npc.run.success", (Object[])new Object[]{name, x, y, z}), true);
        return 1;
    }

    private int jumpNPC(class_2168 source, String name) {
        class_3218 level = source.method_9225();
        NPCEntity npc = this.findNPCByName(name);
        if (npc == null) {
            source.method_9213((class_2561)class_2561.method_43469((String)"npc.not_found", (Object[])new Object[]{name}));
            return 0;
        }
        npc.method_6100(true);
        source.method_9226(() -> class_2561.method_43469((String)"npc.jump.success", (Object[])new Object[]{name}), true);
        return 1;
    }

    private NPCEntity findNPCByName(String name) {
        return npcMap.get(name);
    }
}

