/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import es.superstrellaa.cinematictools.CinematicTools;
import es.superstrellaa.cinematictools.client.CamEventHandlerClient;
import es.superstrellaa.cinematictools.client.ClientCamCommandProcessorClient;
import es.superstrellaa.cinematictools.client.KeyHandler;
import es.superstrellaa.cinematictools.client.OutsidePlayerRenderHandler;
import es.superstrellaa.cinematictools.client.SceneException;
import es.superstrellaa.cinematictools.client.command.ClientCamCommandProcessor;
import es.superstrellaa.cinematictools.client.command.builder.ClientPointArgumentBuilder;
import es.superstrellaa.cinematictools.client.command.builder.ClientSceneCommandBuilder;
import es.superstrellaa.cinematictools.client.command.builder.ClientSceneStartCommandBuilder;
import es.superstrellaa.cinematictools.client.mixin.MinecraftAccessor;
import es.superstrellaa.cinematictools.client.render.NPCEntityRenderer;
import es.superstrellaa.cinematictools.common.command.argument.InterpolationArgument;
import es.superstrellaa.cinematictools.common.entity.ModEntities;
import es.superstrellaa.cinematictools.common.math.interpolation.CamInterpolation;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.network.ModPackets;
import es.superstrellaa.cinematictools.common.packet.GetPathPacket;
import es.superstrellaa.cinematictools.common.packet.SetPathPacket;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import io.github.fabricators_of_create.porting_lib.features.LevelExtensions;
import io.github.fabricators_of_create.porting_lib.features.MinecraftClientUtil;
import io.github.fabricators_of_create.porting_lib.features.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.features.entity.PartEntity;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.network.CreativePacket;

public class CinematicToolsClient
implements ClientModInitializer {
    public static final class_310 mc = class_310.method_1551();
    public static final ClientCamCommandProcessorClient PROCESSOR = new ClientCamCommandProcessorClient();
    public static final HashMap<String, CamScene> SCENES = new HashMap();
    private static final CamScene scene = CamScene.createDefault();
    private static CamScene playing;
    private static boolean serverAvailable;
    private static boolean hideGuiCache;
    private static boolean hasTargetMarker;
    private static CamPoint targetMarker;
    public static boolean isOp;

    public static void resetServerAvailability() {
        serverAvailable = false;
    }

    public static void setServerAvailability() {
        serverAvailable = true;
    }

    public static void registerClientPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ModPackets.CHECK_OP_PACKET, (client, handler, buf, sender) -> {
            boolean receivedOpStatus = buf.readBoolean();
            client.execute(() -> {
                isOp = receivedOpStatus;
            });
        });
    }

    public static void checkOpStatus() {
        if (mc.method_1562() != null) {
            ClientPlayNetworking.send((class_2960)ModPackets.CHECK_OP_PACKET, (class_2540)new class_2540(Unpooled.buffer()));
        }
    }

    private void initPartEntity() {
        ClientEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                for (PartEntity<?> part : partEntity.getParts()) {
                    ((LevelExtensions)world).getPartEntityMap().put(part.method_5628(), part);
                }
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            MultiPartEntity partEntity;
            if (entity instanceof MultiPartEntity && (partEntity = (MultiPartEntity)entity).isMultipartEntity()) {
                for (PartEntity<?> part : partEntity.getParts()) {
                    ((LevelExtensions)world).getPartEntityMap().remove(part.method_5628());
                }
            }
        });
    }

    public void onInitializeClient() {
        CinematicToolsClient.registerClientPackets();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> CinematicToolsClient.checkOpStatus());
        EntityRendererRegistry.register(ModEntities.NPC, NPCEntityRenderer::new);
        OutsidePlayerRenderHandler.register();
        this.initPartEntity();
        new CamEventHandlerClient();
        CreativeCoreClient.registerClientConfig((String)"cinematictools");
        CinematicToolsClient.load();
    }

    public static void load() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CinematicToolsClient.commands((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        KeyHandler.registerKeys();
    }

    public static void commands(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralArgumentBuilder cam = ClientCommandManager.literal((String)"cinematic-client");
        ClientSceneStartCommandBuilder.start(cam, PROCESSOR);
        ClientSceneCommandBuilder.scene(cam, PROCESSOR);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)cam.then(ClientCommandManager.literal((String)"stop").executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            CinematicToolsClient.stop();
            return 0;
        }))).then(ClientCommandManager.literal((String)"pause").executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            CinematicToolsClient.pause();
            return 0;
        }))).then(ClientCommandManager.literal((String)"resume").executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            CinematicToolsClient.resume();
            return 0;
        }))).then(ClientCommandManager.literal((String)"show").then(ClientCommandManager.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            if (!interpolation.equalsIgnoreCase("all")) {
                ((CamInterpolation)CamInterpolation.REGISTRY.get((String)interpolation)).isRenderingEnabled = true;
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.interpolation.show", (Object[])new Object[]{interpolation}));
            } else {
                for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
                    movement.isRenderingEnabled = true;
                }
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"scene.interpolation.show_all"));
            }
            return 0;
        })))).then(ClientCommandManager.literal((String)"hide").then(ClientCommandManager.argument((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            if (!interpolation.equalsIgnoreCase("all")) {
                ((CamInterpolation)CamInterpolation.REGISTRY.get((String)interpolation)).isRenderingEnabled = false;
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scene.interpolation.hide", (Object[])new Object[]{interpolation}));
            } else {
                for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
                    movement.isRenderingEnabled = false;
                }
                ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"scene.interpolation.hide_all"));
            }
            return 0;
        })))).then(ClientCommandManager.literal((String)"list").executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            if (serverAvailable) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"scenes.list_fail"));
                return 0;
            }
            ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scenes.list", (Object[])new Object[]{SCENES.size(), String.join((CharSequence)", ", SCENES.keySet())}));
            return 0;
        }))).then(ClientCommandManager.literal((String)"load").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            if (serverAvailable) {
                CinematicTools.NETWORK.sendToServer((CreativePacket)new GetPathPacket(pathArg));
            } else {
                CamScene scene = SCENES.get(pathArg);
                if (scene != null) {
                    CinematicToolsClient.set(scene);
                    ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scenes.load", (Object[])new Object[]{pathArg}));
                } else {
                    ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43469((String)"scenes.load_fail", (Object[])new Object[]{pathArg}));
                }
            }
            return 0;
        })))).then(ClientCommandManager.literal((String)"save").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            try {
                CamScene scene = CinematicToolsClient.createScene();
                if (serverAvailable) {
                    CinematicTools.NETWORK.sendToServer((CreativePacket)new SetPathPacket(pathArg, scene));
                } else {
                    SCENES.put(pathArg, scene);
                    ((FabricClientCommandSource)x.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"scenes.save", (Object[])new Object[]{pathArg}));
                }
            }
            catch (SceneException e) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)e.getMessage()));
            }
            return 0;
        })))).then(new ClientPointArgumentBuilder("follow_center", (x, y) -> {
            targetMarker = y;
        }, (ClientCamCommandProcessor)PROCESSOR).executes(x -> {
            if (!isOp) {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.permission.failure"));
                return 0;
            }
            targetMarker = CamPoint.createLocal();
            return 0;
        })));
    }

    public static CamScene getScene() {
        if (CinematicToolsClient.isPlaying()) {
            return playing;
        }
        return scene;
    }

    public static CamScene getConfigScene() {
        return scene;
    }

    public static boolean isPlaying() {
        return playing != null;
    }

    public static List<CamPoint> getPoints() {
        return CinematicToolsClient.scene.points;
    }

    public static void set(CamScene scene) {
        CinematicToolsClient.scene.set(scene);
        CinematicToolsClient.checkTargetMarker();
    }

    public static void checkTargetMarker() {
        boolean bl = hasTargetMarker = CinematicToolsClient.scene.posTarget != null;
        if (hasTargetMarker && targetMarker == null) {
            targetMarker = CamPoint.createLocal();
        }
    }

    public static void start(CamScene scene) {
        if (scene.points.isEmpty()) {
            return;
        }
        if (scene.points.size() == 1) {
            scene.points.add(scene.points.get(0));
        }
        playing = scene;
        playing.play();
    }

    public static void pause() {
        if (playing != null) {
            playing.pause();
        }
    }

    public static void resume() {
        if (playing != null) {
            playing.resume();
        }
    }

    public static void stop() {
        if (playing == null) {
            return;
        }
        if (playing.serverSynced()) {
            return;
        }
        playing.finish((class_1937)CinematicToolsClient.mc.field_1687);
        playing = null;
    }

    public static void stopServer() {
        if (playing == null) {
            return;
        }
        playing.finish((class_1937)CinematicToolsClient.mc.field_1687);
        playing = null;
    }

    public static void noTickPath(class_1937 level, float renderTickTime) {
        hideGuiCache = CinematicToolsClient.mc.field_1690.field_1842;
    }

    public static void gameTickPath(class_1937 level) {
        playing.gameTick(level);
    }

    public static void renderTickPath(class_1937 level, float renderTickTime) {
        playing.renderTick(level, renderTickTime);
        if (!playing.playing()) {
            playing = null;
        }
    }

    public static void resetTargetMarker() {
        targetMarker = null;
    }

    public static boolean hasTargetMarker() {
        return hasTargetMarker && targetMarker != null && CinematicToolsClient.scene.posTarget != null;
    }

    public static CamPoint getTargetMarker() {
        return targetMarker;
    }

    public static CamScene createScene() throws SceneException {
        if (CinematicToolsClient.scene.points.size() < 1) {
            throw new SceneException("scene.create_fail");
        }
        CamScene newScene = scene.copy();
        if (newScene.points.size() == 1) {
            newScene.points.add(newScene.points.get(0));
        }
        return newScene;
    }

    public static void teleportTo(CamPoint point) {
        class_310 mc = class_310.method_1551();
        mc.field_1724.method_31549().field_7479 = true;
        float partialTick = mc.method_1493() ? MinecraftClientUtil.getRenderPartialTicksPaused(mc) : ((MinecraftAccessor)mc).getTimer().field_1970;
        CamEventHandlerClient.roll((float)point.roll);
        CamEventHandlerClient.fov(point.zoom - CamEventHandlerClient.fovExactVanilla(partialTick));
        mc.field_1724.method_5641(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
        mc.field_1724.method_5641(point.x, point.y - (double)mc.field_1724.method_5751(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
    }

    static {
        serverAvailable = false;
        isOp = false;
    }
}

