/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.client.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import es.superstrellaa.cinematictools.client.SceneException;
import es.superstrellaa.cinematictools.client.command.ClientCamCommandProcessor;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.CamScene;
import es.superstrellaa.cinematictools.fabric.PosArgHelper;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import org.apache.logging.log4j.util.TriConsumer;

public class ClientPointArgumentBuilder
extends ArgumentBuilder<FabricClientCommandSource, ClientPointArgumentBuilder> {
    private final String literal;
    private final TriConsumer<CommandContext<FabricClientCommandSource>, CamPoint, Integer> indexConsumer;
    private final BiConsumer<CommandContext<FabricClientCommandSource>, CamPoint> consumer;
    private final ClientCamCommandProcessor processor;

    public ClientPointArgumentBuilder(String literal, TriConsumer<CommandContext<FabricClientCommandSource>, CamPoint, Integer> consumer, ClientCamCommandProcessor processor) {
        this.literal = literal;
        this.indexConsumer = consumer;
        this.consumer = null;
        this.processor = processor;
    }

    public ClientPointArgumentBuilder(String literal, BiConsumer<CommandContext<FabricClientCommandSource>, CamPoint> consumer, ClientCamCommandProcessor processor) {
        this.literal = literal;
        this.indexConsumer = null;
        this.consumer = consumer;
        this.processor = processor;
    }

    public String getLiteral() {
        return this.literal;
    }

    protected ClientPointArgumentBuilder getThis() {
        return this;
    }

    private void processPoint(CommandContext<FabricClientCommandSource> x, CamPoint point) {
        if (this.indexConsumer != null) {
            int index = IntegerArgumentType.getInteger(x, (String)"index") - 1;
            CamScene scene = this.processor.getScene(x);
            if (index >= 0 && index < scene.points.size()) {
                this.indexConsumer.accept(x, (Object)point, (Object)index);
            } else {
                ((FabricClientCommandSource)x.getSource()).sendError((class_2561)class_2561.method_43469((String)"scene.index", (Object[])new Object[]{index + 1}));
            }
        } else {
            this.consumer.accept(x, point);
        }
    }

    public CommandNode<FabricClientCommandSource> build() {
        LiteralArgumentBuilder builder = ClientCommandManager.literal((String)this.literal);
        if (this.indexConsumer != null) {
            builder.then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(x -> {
                if (this.processor.canCreatePoint((CommandContext<FabricClientCommandSource>)x)) {
                    CamPoint point = this.processor.createPoint((CommandContext<FabricClientCommandSource>)x);
                    CamScene scene = this.processor.getScene((CommandContext<FabricClientCommandSource>)x);
                    if (scene.posTarget != null) {
                        try {
                            this.processor.makeRelative(this.processor.getScene((CommandContext<FabricClientCommandSource>)x), (class_1937)((FabricClientCommandSource)x.getSource()).getWorld(), point);
                        }
                        catch (SceneException e) {
                            ((FabricClientCommandSource)x.getSource()).sendError(e.getComponent());
                        }
                    }
                    this.processPoint((CommandContext<FabricClientCommandSource>)x, point);
                }
                return 0;
            }));
        } else {
            builder.executes(x -> {
                if (this.processor.canCreatePoint((CommandContext<FabricClientCommandSource>)x)) {
                    CamPoint point = this.processor.createPoint((CommandContext<FabricClientCommandSource>)x);
                    CamScene scene = this.processor.getScene((CommandContext<FabricClientCommandSource>)x);
                    if (scene.posTarget != null) {
                        try {
                            this.processor.makeRelative(this.processor.getScene((CommandContext<FabricClientCommandSource>)x), (class_1937)((FabricClientCommandSource)x.getSource()).getWorld(), point);
                        }
                        catch (SceneException e) {
                            ((FabricClientCommandSource)x.getSource()).sendError(e.getComponent());
                        }
                    }
                    this.processPoint((CommandContext<FabricClientCommandSource>)x, point);
                }
                return 0;
            });
        }
        builder.then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"location", (ArgumentType)class_2277.method_9737()).executes(x -> {
            class_243 vec = PosArgHelper.getVec3((CommandContext<FabricClientCommandSource>)x, "location");
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0, 70.0);
            this.processPoint((CommandContext<FabricClientCommandSource>)x, point);
            return 0;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(x -> {
            class_243 vec = PosArgHelper.getVec3((CommandContext<FabricClientCommandSource>)x, "location");
            class_241 rotation = PosArgHelper.getRotation((CommandContext<FabricClientCommandSource>)x, "rotation");
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, rotation.field_1342, rotation.field_1343, 0.0, 70.0);
            this.processPoint((CommandContext<FabricClientCommandSource>)x, point);
            return 0;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"roll", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            class_243 vec = PosArgHelper.getVec3((CommandContext<FabricClientCommandSource>)x, "location");
            class_241 rotation = PosArgHelper.getRotation((CommandContext<FabricClientCommandSource>)x, "rotation");
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, rotation.field_1342, rotation.field_1343, DoubleArgumentType.getDouble((CommandContext)x, (String)"roll"), 70.0);
            this.processPoint((CommandContext<FabricClientCommandSource>)x, point);
            return 0;
        })).then(ClientCommandManager.argument((String)"fov", (ArgumentType)DoubleArgumentType.doubleArg()).executes(x -> {
            class_243 vec = PosArgHelper.getVec3((CommandContext<FabricClientCommandSource>)x, "location");
            class_241 rotation = PosArgHelper.getRotation((CommandContext<FabricClientCommandSource>)x, "rotation");
            CamPoint point = new CamPoint(vec.field_1352, vec.field_1351, vec.field_1350, rotation.field_1342, rotation.field_1343, DoubleArgumentType.getDouble((CommandContext)x, (String)"roll"), DoubleArgumentType.getDouble((CommandContext)x, (String)"fov"));
            this.processPoint((CommandContext<FabricClientCommandSource>)x, point);
            return 0;
        })))));
        return builder.build();
    }
}

