/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.entity;

import es.superstrellaa.cinematictools.CinematicTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NPCEntity
extends class_1314
implements GeoEntity {
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("walk");
    protected static final RawAnimation RUN_ANIM = RawAnimation.begin().thenLoop("sprint");
    protected static final RawAnimation JUMP_ANIM = RawAnimation.begin().thenPlay("jump");
    protected static final RawAnimation HANDSBACK_ANIM = RawAnimation.begin().thenLoop("hands_back");
    protected static final RawAnimation TALK_ANIM = RawAnimation.begin().thenLoop("speak");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Boolean> IS_RUNNING = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_JUMPING = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> NAME = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> SKIN_URL = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13326);
    private int jumpTicks = 0;
    private int animationTicks = 0;
    private boolean animationTriggered = false;
    private boolean isAnimationPaused = false;
    private String lastAnimation = null;
    private class_2960 skinTexture;

    public NPCEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.method_5971();
    }

    public void setName(String name) {
        this.field_6011.method_12778(NAME, (Object)name);
    }

    public void setSkinURL(String url) {
        this.field_6011.method_12778(SKIN_URL, (Object)url);
    }

    public String getSkinURL() {
        return (String)this.field_6011.method_12789(SKIN_URL);
    }

    public String getNPCName() {
        return (String)this.field_6011.method_12789(NAME);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        CinematicTools.npcMap.remove(this.getNPCName());
        if (this.method_37908().field_9236) {
            this.skinTexture = null;
        }
    }

    public class_2960 getSkinTexture() {
        if ("_SUIT".equals(this.getNPCName())) {
            return new class_2960("cinematictools", "textures/entity/npc.suit.png");
        }
        return this.skinTexture;
    }

    protected class_3414 method_6002() {
        return null;
    }

    protected class_3414 method_6011(class_1282 source) {
        return null;
    }

    protected class_3414 method_5994() {
        return null;
    }

    public boolean method_5701() {
        return true;
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
    }

    public boolean method_6034() {
        return this.method_37908() != null && !this.method_37908().field_9236 && this.method_37908().method_8503() != null;
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.method_37908().field_9236 && key.equals(SKIN_URL)) {
            this.skinTexture = null;
            this.downloadAndApplySkin();
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(NAME, (Object)"");
        this.field_6011.method_12784(SKIN_URL, (Object)"");
        this.field_6011.method_12784(IS_RUNNING, (Object)false);
        this.field_6011.method_12784(IS_JUMPING, (Object)false);
    }

    public void setRunning(boolean running) {
        this.field_6011.method_12778(IS_RUNNING, (Object)running);
    }

    public boolean isRunning() {
        return (Boolean)this.field_6011.method_12789(IS_RUNNING);
    }

    public void method_6100(boolean jumping) {
        if (jumping && !this.isJumping() && !this.animationTriggered) {
            this.triggerAnim("Movement", "jump");
            this.animationTriggered = true;
            this.animationTicks = 10;
        }
    }

    public void playAnimation(String animationName) {
        this.lastAnimation = animationName;
        this.isAnimationPaused = false;
        this.triggerAnim("Movement", animationName);
    }

    public void stopAnimation() {
        this.isAnimationPaused = true;
    }

    public void resumeAnimation() {
        this.isAnimationPaused = false;
        if (this.lastAnimation != null) {
            this.triggerAnim("Movement", this.lastAnimation);
        }
    }

    public void downloadAndApplySkin() {
        if (!this.method_37908().field_9236 || this.skinTexture != null) {
            return;
        }
        String skinURL = this.getSkinURL();
        if (skinURL == null || skinURL.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try (InputStream inputStream = new URL(skinURL).openStream();){
                class_1011 skinImage = class_1011.method_4309((InputStream)inputStream);
                class_1043 dynamicTexture = new class_1043(skinImage);
                class_310.method_1551().execute(() -> {
                    class_2960 textureLocation;
                    this.skinTexture = textureLocation = class_310.method_1551().method_1531().method_4617("npc_skin_" + this.method_5628(), dynamicTexture);
                });
            }
            catch (IOException e) {
                System.err.println("[NPCEntity] Failed to load skin from URL: " + skinURL);
                e.printStackTrace();
            }
        });
    }

    public boolean isJumping() {
        return (Boolean)this.field_6011.method_12789(IS_JUMPING);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Movement", 10, this::handleAnimations).triggerableAnim("jump", JUMP_ANIM).triggerableAnim("walk", WALK_ANIM).triggerableAnim("run", RUN_ANIM).triggerableAnim("hands_back", HANDSBACK_ANIM).triggerableAnim("talk", TALK_ANIM)});
    }

    private <T extends GeoAnimatable> PlayState handleAnimations(AnimationState<T> state) {
        if (this.isAnimationPaused) {
            return PlayState.STOP;
        }
        if (this.isJumping()) {
            return state.setAndContinue(JUMP_ANIM);
        }
        if (state.isMoving()) {
            if (this.isRunning()) {
                return state.setAndContinue(RUN_ANIM);
            }
            return state.setAndContinue(WALK_ANIM);
        }
        return state.setAndContinue(IDLE_ANIM);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5942().method_23966()) {
            this.method_5942().method_6360();
        }
        if (this.isJumping()) {
            --this.jumpTicks;
            if (this.jumpTicks <= 0) {
                if (this.method_24828()) {
                    this.method_6100(false);
                } else {
                    this.jumpTicks = 2;
                }
            }
        }
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(IS_JUMPING, (Object)(this.jumpTicks > 0 ? 1 : 0));
        }
        if (this.method_37908().field_9236 && this.skinTexture == null) {
            this.downloadAndApplySkin();
        }
        if (this.animationTriggered) {
            if (this.animationTicks > 0) {
                --this.animationTicks;
            } else {
                if (!this.isJumping()) {
                    this.field_6011.method_12778(IS_JUMPING, (Object)true);
                    this.jumpTicks = 10;
                    this.method_18800(this.method_18798().field_1352, 0.5, this.method_18798().field_1350);
                    this.field_6007 = true;
                }
                this.animationTriggered = false;
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

