/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.math.follow;

import es.superstrellaa.cinematictools.common.math.follow.CamFollowConfig;
import es.superstrellaa.cinematictools.common.math.follow.CamFollowStepDistance;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CamFollow<T extends VecNd> {
    public static final NamedTypeRegistry<CamFollow> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[]{CamFollowConfig.class});
    protected T current;
    public CamFollowConfig<T> config;

    public CamFollow(CamFollowConfig<T> config) {
        this.config = config;
    }

    public void setInitial(T initial) {
        this.current = initial;
    }

    private void makeInBounds(T vec) {
        for (int i = 0; i < vec.dimensions(); ++i) {
            double value = vec.get(i);
            double min = this.config.attribute.getMin().get(i);
            double max = this.config.attribute.getMax().get(i);
            if (value >= min && value <= max) continue;
            value -= min;
            if ((value %= max - min) < 0.0) {
                value += max - min;
            }
            vec.set(i, value += min);
        }
    }

    public T follow(T target) {
        if (this.config.attribute.getMin() != null) {
            this.makeInBounds(target);
            this.makeInBounds(this.current);
            for (int i = 0; i < target.dimensions(); ++i) {
                double valueT = target.get(i);
                double valueC = this.current.get(i);
                double min = this.config.attribute.getMin().get(i);
                double max = this.config.attribute.getMax().get(i);
                if (valueC > valueT) {
                    if (valueC - valueT > max - valueC + valueT - min) {
                        valueT += max - min;
                    }
                } else if (valueC < valueT && valueT - valueC > max - valueT + valueC - min) {
                    valueT -= max - min;
                }
                target.set(i, valueT);
            }
        }
        return this.followInternal(target);
    }

    protected abstract T followInternal(T var1);

    static {
        REGISTRY.register("step", CamFollowStepDistance.class);
    }
}

