/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.math.follow;

import es.superstrellaa.cinematictools.common.math.follow.CamFollow;
import es.superstrellaa.cinematictools.common.math.follow.CamFollowStepDistance;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import net.minecraft.class_2487;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class CamFollowConfig<T extends VecNd> {
    public final CamAttribute attribute;
    public String type = "step";
    public double div = 20.0;
    public double threshold;
    public double maxSpeed;

    public CamFollowConfig(CamAttribute attribute) {
        this.attribute = attribute;
    }

    public CamFollowConfig(CamAttribute attribute, double div) {
        this(attribute);
        this.div = div;
    }

    public CamFollowConfig(CamAttribute attribute, String type, double div) {
        this(attribute, div);
        this.type = type;
    }

    public CamFollow<T> create(T initial) {
        if (this.div < 1.0) {
            this.div = 1.0;
        }
        CamFollow follow = (CamFollow)CamFollow.REGISTRY.createSafe(CamFollowStepDistance.class, this.type, new Object[]{this});
        follow.setInitial(initial);
        return follow;
    }

    public void load(class_2487 nbt) {
        this.type = nbt.method_10558("type");
        this.div = Math.max(1.0, nbt.method_10574("div"));
        this.threshold = nbt.method_10574("threshold");
        this.maxSpeed = nbt.method_10574("max_speed");
    }

    public class_2487 save(class_2487 nbt) {
        nbt.method_10582("type", this.type);
        nbt.method_10549("div", this.div);
        if (this.threshold > 0.0) {
            nbt.method_10549("threshold", this.threshold);
        }
        if (this.maxSpeed > 0.0) {
            nbt.method_10549("max_speed", this.maxSpeed);
        }
        return nbt;
    }

    public CamFollowConfig<T> copy() {
        CamFollowConfig<T> copy = new CamFollowConfig<T>(this.attribute);
        copy.type = this.type;
        copy.div = this.div;
        copy.threshold = this.threshold;
        copy.maxSpeed = this.maxSpeed;
        return copy;
    }
}

