/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.math.interpolation;

import es.superstrellaa.cinematictools.common.target.CamTarget;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CircularInterpolation
extends HermiteInterpolation<Vec3d> {
    public Vec3d sphereOrigin;
    public double radius;
    public CamTarget target;
    public HermiteInterpolation<Vec1d> yAxis;
    public final boolean clockwise;

    public CircularInterpolation(boolean clockwise, List<Vec3d> points, CamTarget target, Vec3d sphereOrigin, double radius, HermiteInterpolation<Vec1d> yAxis) {
        super(points);
        this.clockwise = clockwise;
        this.target = target;
        this.sphereOrigin = sphereOrigin;
        this.radius = radius;
        this.yAxis = yAxis;
    }

    public Vec3d valueAt(double t) {
        class_310 mc = class_310.method_1551();
        Vec3d center = this.target.position((class_1937)mc.field_1687, mc.method_1534());
        if (center != null) {
            Vec3d centerPoint = new Vec3d(center.x, center.y, center.z);
            if (!this.clockwise) {
                t = 1.0 - t;
            }
            double angle = t * 360.0;
            Vec3d newPoint = new Vec3d(this.sphereOrigin);
            newPoint.y = 0.0;
            Matrix3 matrix = new Matrix3();
            matrix.rotY(Math.toRadians(angle));
            matrix.transform(newPoint);
            newPoint.y = ((Vec1d)this.yAxis.valueAt((double)t)).x - center.y;
            newPoint.normalize();
            newPoint.scale(this.radius);
            newPoint.add(centerPoint);
            return newPoint;
        }
        return (Vec3d)super.valueAt(t);
    }
}

