/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.scene;

import es.superstrellaa.cinematictools.common.math.follow.CamFollowConfig;
import es.superstrellaa.cinematictools.common.math.interpolation.CamInterpolation;
import es.superstrellaa.cinematictools.common.math.interpolation.CamPitchMode;
import es.superstrellaa.cinematictools.common.math.point.CamPoint;
import es.superstrellaa.cinematictools.common.scene.attribute.CamAttribute;
import es.superstrellaa.cinematictools.common.scene.mode.CamMode;
import es.superstrellaa.cinematictools.common.scene.mode.DefaultMode;
import es.superstrellaa.cinematictools.common.scene.run.CamRun;
import es.superstrellaa.cinematictools.common.target.CamTarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public class CamScene {
    private boolean started = false;
    private boolean serverSynced = false;
    public long duration;
    public int loop = 0;
    public CamMode mode;
    public CamInterpolation interpolation;
    public CamTarget lookTarget;
    public CamFollowConfig<Vec1d> pitchFollowConfig = new CamFollowConfig(CamAttribute.PITCH, 10.0);
    public CamFollowConfig<Vec1d> yawFollowConfig = new CamFollowConfig(CamAttribute.YAW, 10.0);
    public CamTarget posTarget;
    public CamFollowConfig<Vec3d> posFollowConfig = new CamFollowConfig(CamAttribute.POSITION, 2.0);
    public List<CamPoint> points;
    public boolean smoothBeginning = true;
    public CamPitchMode pitchMode = CamPitchMode.FIX_KEEP_DIRECTION;
    public boolean distanceBasedTiming = false;
    public CamRun run;

    public static CamScene createDefault() {
        return new CamScene(10000L, 0, "default", new ArrayList<CamPoint>(), CamInterpolation.HERMITE);
    }

    public CamScene(long duration, int loop, String mode, List<CamPoint> points, CamInterpolation interpolation) {
        this.duration = duration;
        this.setMode(mode);
        this.points = points;
        this.interpolation = interpolation;
    }

    public CamScene(class_2487 nbt) throws RegistryException {
        this.duration = nbt.method_10537("duration");
        this.loop = nbt.method_10550("loop");
        this.setMode(nbt.method_10558("mode"));
        this.interpolation = (CamInterpolation)CamInterpolation.REGISTRY.get(nbt.method_10558("inter"));
        this.lookTarget = nbt.method_10545("look_target") ? CamTarget.load(nbt.method_10562("look_target")) : null;
        this.pitchFollowConfig.load(nbt.method_10562("pitch"));
        this.yawFollowConfig.load(nbt.method_10562("yaw"));
        this.posTarget = nbt.method_10545("pos_target") ? CamTarget.load(nbt.method_10562("pos_target")) : null;
        this.posFollowConfig.load(nbt.method_10562("pos"));
        class_2499 list = nbt.method_10554("points", 10);
        this.points = new ArrayList<CamPoint>();
        for (class_2520 point : list) {
            this.points.add(new CamPoint((class_2487)point));
        }
        this.smoothBeginning = nbt.method_10577("smooth_start");
        this.pitchMode = CamPitchMode.values()[nbt.method_10550("pitch_mode")];
        this.distanceBasedTiming = nbt.method_10577("d_timing");
    }

    public void setServerSynced() {
        this.serverSynced = true;
    }

    public class_2487 save(class_2487 nbt) {
        nbt.method_10544("duration", this.duration);
        nbt.method_10569("loop", this.loop);
        nbt.method_10582("mode", CamMode.REGISTRY.getId((Object)this.mode));
        nbt.method_10582("inter", CamInterpolation.REGISTRY.getId((Object)this.interpolation));
        if (this.lookTarget != null) {
            nbt.method_10566("look_target", (class_2520)this.lookTarget.save(new class_2487()));
        }
        nbt.method_10566("pitch", (class_2520)this.pitchFollowConfig.save(new class_2487()));
        nbt.method_10566("yaw", (class_2520)this.yawFollowConfig.save(new class_2487()));
        if (this.posTarget != null) {
            nbt.method_10566("pos_target", (class_2520)this.posTarget.save(new class_2487()));
        }
        nbt.method_10566("pos", (class_2520)this.posFollowConfig.save(new class_2487()));
        class_2499 list = new class_2499();
        for (CamPoint point : this.points) {
            list.add((Object)point.save(new class_2487()));
        }
        nbt.method_10566("points", (class_2520)list);
        nbt.method_10556("smooth_start", this.smoothBeginning);
        nbt.method_10569("pitch_mode", this.pitchMode.ordinal());
        nbt.method_10556("d_timing", this.distanceBasedTiming);
        return nbt;
    }

    public boolean endless() {
        return this.loop < 0;
    }

    public boolean serverSynced() {
        return this.serverSynced;
    }

    public void play() {
        this.started = true;
    }

    public boolean paused() {
        return !this.run.playing();
    }

    public void togglePause() {
        if (this.playing()) {
            if (this.paused()) {
                this.resume();
            } else {
                this.pause();
            }
        }
    }

    public void pause() {
        this.run.pause();
    }

    public void resume() {
        this.run.resume();
    }

    public void stop() {
        this.run.stop();
    }

    public boolean playing() {
        return this.run != null;
    }

    protected void started(class_1937 level) {
        if (this.lookTarget != null) {
            this.lookTarget.start(level);
        }
        if (this.posTarget != null) {
            this.posTarget.start(level);
        }
        if (level.field_9236) {
            this.run = new CamRun(level, this);
            this.mode.started(this.run);
        }
    }

    public void finish(class_1937 level) {
        if (this.lookTarget != null) {
            this.lookTarget.finish();
        }
        if (this.posTarget != null) {
            this.posTarget.finish();
        }
        this.stop();
        if (level.field_9236) {
            this.mode.finished(this.run);
            this.run.finish();
            this.run = null;
        }
        this.started = false;
    }

    public void renderTick(class_1937 level, float deltaTime) {
        if (this.started) {
            this.started = false;
            this.started(level);
        }
        this.run.renderTick(level, deltaTime);
    }

    public void gameTick(class_1937 level) {
        if (this.started) {
            this.started = false;
            this.started(level);
        }
        this.run.gameTick(level);
    }

    public void set(CamScene scene) {
        this.duration = scene.duration;
        this.loop = scene.loop;
        this.setMode(CamMode.REGISTRY.getId((Object)scene.mode));
        this.points = scene.copyPoints();
        this.interpolation = scene.interpolation;
        this.serverSynced = scene.serverSynced;
        this.lookTarget = scene.lookTarget;
        this.pitchFollowConfig = scene.pitchFollowConfig;
        this.yawFollowConfig = scene.yawFollowConfig;
        this.posTarget = scene.posTarget;
        this.posFollowConfig = scene.posFollowConfig;
        this.smoothBeginning = scene.smoothBeginning;
        this.pitchMode = scene.pitchMode;
        this.distanceBasedTiming = scene.distanceBasedTiming;
    }

    public void setMode(String mode) {
        this.mode = (CamMode)CamMode.REGISTRY.createSafe(DefaultMode.class, mode, new Object[]{this});
    }

    private List<CamPoint> copyPoints() {
        ArrayList<CamPoint> newPoints = new ArrayList<CamPoint>(this.points.size());
        for (int i = 0; i < this.points.size(); ++i) {
            newPoints.add(this.points.get(i).copy());
        }
        return newPoints;
    }

    public CamScene copy() {
        CamScene scene = new CamScene(this.duration, this.loop, CamMode.REGISTRY.getId((Object)this.mode), this.copyPoints(), this.interpolation);
        scene.set(this);
        return scene;
    }

    public <T extends VecNd> CamFollowConfig<T> getConfig(CamAttribute<T> attribute) {
        if (attribute == CamAttribute.POSITION) {
            return this.posFollowConfig;
        }
        if (attribute == CamAttribute.PITCH) {
            return this.pitchFollowConfig;
        }
        if (attribute == CamAttribute.YAW) {
            return this.yawFollowConfig;
        }
        return null;
    }
}

