/*
 * Decompiled with CFR 0.152.
 */
package es.superstrellaa.cinematictools.common.target;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_638;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public abstract class CamTarget {
    public static final NamedTypeRegistry<CamTarget> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);

    public static CamTarget load(class_2487 nbt) {
        try {
            CamTarget target = (CamTarget)REGISTRY.create(nbt.method_10558("id"), new Object[0]);
            target.loadExtra(nbt);
            return target;
        }
        catch (RegistryException e) {
            return null;
        }
    }

    public abstract Vec3d position(class_1937 var1, float var2);

    protected abstract void saveExtra(class_2487 var1);

    protected abstract void loadExtra(class_2487 var1);

    public class_2487 save(class_2487 nbt) {
        nbt.method_10582("id", REGISTRY.getId((Object)this));
        this.saveExtra(nbt);
        return nbt;
    }

    public void start(class_1937 level) {
    }

    public void finish() {
    }

    static {
        REGISTRY.register("pos", BlockTarget.class);
        REGISTRY.register("entity", EntityTarget.class);
        REGISTRY.register("self", SelfTarget.class);
        REGISTRY.register("player", PlayerTarget.class);
    }

    public static class BlockTarget
    extends CamTarget {
        public class_2338 pos;

        public BlockTarget() {
        }

        public BlockTarget(class_2338 pos) {
            this.pos = pos;
        }

        @Override
        public Vec3d position(class_1937 level, float partialTicks) {
            return new Vec3d((double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264() + 0.5, (double)this.pos.method_10260() + 0.5);
        }

        @Override
        protected void saveExtra(class_2487 nbt) {
            nbt.method_10539("data", new int[]{this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260()});
        }

        @Override
        protected void loadExtra(class_2487 nbt) {
            int[] array = nbt.method_10561("data");
            if (array == null || array.length != 3) {
                throw new IllegalArgumentException("Invalid block target data=" + String.valueOf(array));
            }
            this.pos = new class_2338(array[0], array[1], array[2]);
        }
    }

    public static class EntityTarget
    extends CamTarget {
        public class_1297 cachedEntity;
        public UUID uuid;

        public EntityTarget() {
        }

        public EntityTarget(class_1297 entity) {
            this.uuid = entity.method_5667();
        }

        @Override
        public void start(class_1937 level) {
            if (level instanceof class_3218) {
                this.cachedEntity = ((class_3218)level).method_14190(this.uuid);
            } else {
                for (class_1297 entity : ((class_638)level).method_18112()) {
                    if (!entity.method_5667().equals(this.uuid)) continue;
                    this.cachedEntity = entity;
                    break;
                }
            }
        }

        @Override
        public void finish() {
            this.cachedEntity = null;
        }

        @Override
        public Vec3d position(class_1937 level, float partialTicks) {
            if (this.cachedEntity != null && !this.cachedEntity.method_5805()) {
                this.cachedEntity = null;
            }
            if (this.cachedEntity != null) {
                return new Vec3d(this.cachedEntity.method_5836(partialTicks));
            }
            return null;
        }

        @Override
        protected void saveExtra(class_2487 nbt) {
            nbt.method_10582("uuid", this.uuid.toString());
        }

        @Override
        protected void loadExtra(class_2487 nbt) {
            this.uuid = UUID.fromString(nbt.method_10558("uuid"));
        }
    }

    public static class SelfTarget
    extends CamTarget {
        @Override
        protected void saveExtra(class_2487 nbt) {
        }

        @Override
        protected void loadExtra(class_2487 nbt) {
        }

        @Override
        public Vec3d position(class_1937 level, float partialTicks) {
            return new Vec3d(class_310.method_1551().field_1724.method_5836(partialTicks));
        }
    }

    public static class PlayerTarget
    extends CamTarget {
        public class_1657 cachedPlayer;
        public UUID uuid;

        public PlayerTarget() {
        }

        public PlayerTarget(class_1657 player) {
            this.cachedPlayer = player;
            this.uuid = player.method_5667();
        }

        @Override
        public void start(class_1937 level) {
            this.cachedPlayer = level.method_18470(this.uuid);
        }

        @Override
        public void finish() {
            this.cachedPlayer = null;
        }

        @Override
        public Vec3d position(class_1937 level, float partialTicks) {
            if (this.cachedPlayer == null || !this.cachedPlayer.method_5805()) {
                return null;
            }
            return new Vec3d(this.cachedPlayer.method_5836(partialTicks));
        }

        @Override
        protected void saveExtra(class_2487 nbt) {
            nbt.method_10582("uuid", this.uuid.toString());
        }

        @Override
        protected void loadExtra(class_2487 nbt) {
            this.uuid = UUID.fromString(nbt.method_10558("uuid"));
        }
    }
}

