/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.features.registry;

import io.github.fabricators_of_create.porting_lib.features.registry.RegistryObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class LazyRegistrar<T> {
    @Deprecated
    public final String mod_id;
    public final String modId;
    private final class_5321<? extends class_2378<T>> registryKey;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private Supplier<class_2378<T>> cachedHolder;

    LazyRegistrar(class_5321<? extends class_2378<T>> registryKey, String modid) {
        this.registryKey = registryKey;
        this.modId = this.mod_id = modid;
    }

    public static <R> LazyRegistrar<R> create(class_2378<R> registry, String id) {
        return new LazyRegistrar(registry.method_30517(), id);
    }

    public static <B> LazyRegistrar<B> create(class_5321<? extends class_2378<B>> registry, String id) {
        return new LazyRegistrar(registry, id);
    }

    public static <B> LazyRegistrar<B> create(class_2960 registryName, String id) {
        return new LazyRegistrar(class_5321.method_29180((class_2960)registryName), id);
    }

    public Supplier<class_2378<T>> makeRegistry() {
        if (this.cachedHolder == null) {
            this.cachedHolder = new RegistryHolder<T>(this.getRegistryKey());
        }
        return this.cachedHolder;
    }

    public <R extends T> RegistryObject<R> register(String id, Supplier<? extends R> entry) {
        return this.register(new class_2960(this.modId, id), entry);
    }

    public <R extends T> RegistryObject<R> register(class_2960 id, Supplier<? extends R> entry) {
        RegistryObject<? extends R> obj = new RegistryObject<R>(id, class_5321.method_29179(this.getRegistryKey(), (class_2960)id));
        obj.setGetter(entry);
        if (this.entries.putIfAbsent(obj, entry) != null) {
            throw new IllegalArgumentException("Duplicate registration " + String.valueOf(id));
        }
        return obj;
    }

    public void register() {
        class_2378 registry = this.makeRegistry().get();
        this.entries.forEach((entry, sup) -> class_2378.method_10230((class_2378)registry, (class_2960)entry.getId(), entry.get()));
    }

    public <B extends class_2248> RegistryObject<T> register(String name, T b) {
        return this.register(name, (T)((Supplier<Object>)() -> b));
    }

    @NotNull
    public class_6862<T> createTagKey(@NotNull String path) {
        Objects.requireNonNull(path);
        return this.createTagKey(new class_2960(this.modId, path));
    }

    @NotNull
    public class_6862<T> createTagKey(@NotNull class_2960 location) {
        if (this.registryKey == null) {
            throw new IllegalStateException("The registry name was not set, cannot create a tag key");
        }
        Objects.requireNonNull(location);
        return class_6862.method_40092(this.registryKey, (class_2960)location);
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    public class_5321<? extends class_2378<T>> getRegistryKey() {
        return this.registryKey;
    }

    private static class RegistryHolder<V>
    implements Supplier<class_2378<V>> {
        private final class_5321<? extends class_2378<V>> registryKey;
        private final List<class_2378<? extends class_2378<?>>> registries;
        private class_2378<V> registry = null;

        private RegistryHolder(class_5321<? extends class_2378<V>> registryKey) {
            this.registryKey = registryKey;
            this.registries = new ArrayList();
            this.registerRegistry(class_7923.field_41167);
        }

        public void registerRegistry(class_2378<? extends class_2378<?>> registry) {
            this.registries.add(registry);
        }

        @Override
        public class_2378<V> get() {
            this.registries.forEach(reg -> {
                if (reg.method_10250(this.registryKey.method_29177())) {
                    this.registry = (class_2378)reg.method_10223(this.registryKey.method_29177());
                }
            });
            if (this.registry == null) {
                this.registry = FabricRegistryBuilder.createSimple(null, (class_2960)this.registryKey.method_29177()).buildAndRegister();
            }
            return this.registry;
        }
    }
}

