/*
 * Decompiled with CFR 0.152.
 */
package com.aric3435.defaultdarkmodepatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultDarkModePatcher
implements ClientModInitializer {
    public static final String MOD_ID = "default_dark_mode_patcher";
    public static final String DEFAULT_PACK_FILENAME = "Default-Dark-Mode-1.21.6-2025.6.0.zip";
    public static final String PATCHED_PACK_FILENAME = "Default-Dark-Mode-25w41a-2025.10.0.zip";
    private static final Logger LOGGER = LogManager.getLogger((String)"default_dark_mode_patcher");
    private static final String UPDATED_PACK_MCMETA = "{\n    \"pack\": {\n        \"pack_format\": 63,\n        \"supported_formats\": {\n            \"min_inclusive\": 63,\n            \"max_inclusive\": 70\n        },\n        \"description\": \"Welcome to the dark side!\\n\\u00a78by nebulr \\u2022 1.21.11 \\u2022 2025.10.0\"\n    }\n}\n";

    public void onInitializeClient() {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            Path gameDir = client.field_1697.toPath();
            Path resourcePacksDir = gameDir.resolve("resourcepacks");
            Path defaultPackPath = resourcePacksDir.resolve(DEFAULT_PACK_FILENAME);
            if (Files.exists(defaultPackPath, new LinkOption[0])) {
                LOGGER.info("Found Default Dark Mode resource pack at: {}", (Object)defaultPackPath);
                new Thread(() -> {
                    this.patchResourcePack(defaultPackPath);
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Default Dark Mode has been patched to 25w41a (1.21.11)."), false);
                        }
                    });
                }).start();
            } else {
                LOGGER.info("Default Dark Mode resource pack not found, skipping patch.");
            }
        });
    }

    private void patchResourcePack(Path packPath) {
        LOGGER.info("Starting patch process for resource pack: {}", (Object)packPath);
        try {
            Path tempDir = Files.createTempDirectory("ddm_patch_", new FileAttribute[0]);
            LOGGER.info("Created temporary directory: {}", (Object)tempDir);
            this.unzip(packPath.toFile(), tempDir.toFile());
            LOGGER.info("Extracted resource pack to temporary directory.");
            Path packMcmeta = tempDir.resolve("pack.mcmeta");
            Files.writeString(packMcmeta, (CharSequence)UPDATED_PACK_MCMETA, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            LOGGER.info("Updated pack.mcmeta with pack_format 63 and max_inclusive 70.");
            this.injectSlotTexture(tempDir, "nautilus_armor.png");
            this.injectSlotTexture(tempDir, "spear.png");
            Path patchedPackPath = packPath.getParent().resolve(PATCHED_PACK_FILENAME);
            File patchedZip = patchedPackPath.toFile();
            this.zipDirectory(tempDir.toFile(), patchedZip);
            LOGGER.info("Repackaged patched resource pack as: {}", (Object)patchedPackPath);
            try {
                Files.deleteIfExists(packPath);
                LOGGER.info("Deleted original resource pack: {}", (Object)packPath);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to delete original resource pack: {}", (Object)packPath, (Object)e);
            }
            this.deleteDirectoryRecursively(tempDir.toFile());
            LOGGER.info("Cleaned up temporary files.");
        }
        catch (Exception e) {
            LOGGER.error("Error during patching: ", (Throwable)e);
        }
    }

    private void injectSlotTexture(Path tempDir, String fileName) throws IOException {
        Path targetDir = tempDir.resolve("assets/minecraft/textures/gui/sprites/container/slot");
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (InputStream in = DefaultDarkModePatcher.class.getResourceAsStream("/assets/defaultdarkmodepatcher/slot/" + fileName);){
            if (in == null) {
                LOGGER.warn("Missing bundled texture: {}", (Object)fileName);
                return;
            }
            Files.copy(in, targetDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.info("Injected slot texture: {}", (Object)fileName);
        }
    }

    private void unzip(File zipFile, File targetDir) throws IOException {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = this.newFile(targetDir, entry);
                if (entry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(newFile));
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(parent));
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target directory: " + zipEntry.getName());
        }
        return destFile;
    }

    private void zipDirectory(File sourceDir, File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.zipFile(sourceDir, sourceDir, zos);
        }
    }

    private void zipFile(File rootDir, File sourceFile, ZipOutputStream zos) throws IOException {
        if (sourceFile.isDirectory()) {
            for (File file : sourceFile.listFiles()) {
                this.zipFile(rootDir, file, zos);
            }
        } else {
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                int len;
                String zipEntryName = rootDir.toURI().relativize(sourceFile.toURI()).getPath();
                ZipEntry zipEntry = new ZipEntry(zipEntryName);
                zos.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
            }
        }
    }

    private void deleteDirectoryRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.deleteDirectoryRecursively(child);
            }
        }
        if (!file.delete()) {
            LOGGER.warn("Unable to delete: {}", (Object)file.getAbsolutePath());
        }
    }
}

