/*
 * Decompiled with CFR 0.152.
 */
package com.aric3435.defaultdarkmodepatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultDarkModePatcher
implements ClientModInitializer {
    public static final String MOD_ID = "default_dark_mode_patcher";
    private static final Logger LOGGER = LogManager.getLogger((String)"default_dark_mode_patcher");
    public static final String DEFAULT_PACK_FILENAME = "Default-Dark-Mode-1.21.6-2025.6.0.zip";
    public static final String DEFAULT_PACK_BAK_FILENAME = "Default-Dark-Mode-1.21.6-2025.6.0.zip.bak";
    public static final String PATCHED_PACK_FILENAME = "Default-Dark-Mode-25w46a-2025.11.0.zip";
    private static final String EXPECTED_SHA256 = "7DFF817B040D9942CBBE3228714075881736337E20713555ADCA62F546077741";
    private static final String UPDATED_PACK_MCMETA = "{\n    \"pack\": {\n        \"pack_format\": 63,\n        \"supported_formats\": {\n            \"min_inclusive\": 63,\n            \"max_inclusive\": 74\n        },\n        \"min_format\": 63,\n        \"max_format\": 74,\n        \"description\": \"Welcome to the dark side!\\n\\u00a78by nebulr \\u2022 1.21.11 \\u2022 2025.11.0\"\n    }\n}\n";

    public void onInitializeClient() {
        class_310 client = class_310.method_1551();
        client.execute(() -> {
            Path gameDir = client.field_1697.toPath();
            Path resourcePacksDir = gameDir.resolve("resourcepacks");
            Path zipPath = resourcePacksDir.resolve(DEFAULT_PACK_FILENAME);
            Path bakPath = resourcePacksDir.resolve(DEFAULT_PACK_BAK_FILENAME);
            Path patchedPath = resourcePacksDir.resolve(PATCHED_PACK_FILENAME);
            if (!Files.exists(zipPath, new LinkOption[0])) {
                LOGGER.info("Default Dark Mode resource pack not found at {}. Skipping.", (Object)zipPath);
                return;
            }
            new Thread(() -> {
                boolean patched = this.patchWithVerification(zipPath, bakPath, patchedPath);
                client.execute(() -> {
                    if (client.field_1724 != null) {
                        if (patched) {
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Default Dark Mode patched to 25w46a (1.21.11)."), false);
                        } else {
                            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Default Dark Mode patch skipped. See logs for details."), false);
                        }
                    }
                });
            }).start();
        });
    }

    private boolean patchWithVerification(Path zipPath, Path bakPath, Path patchedPath) {
        try {
            boolean bakIsOriginal;
            boolean zipIsOriginal = DefaultDarkModePatcher.verifySha256(zipPath, EXPECTED_SHA256);
            boolean bakExists = Files.exists(bakPath, new LinkOption[0]);
            boolean bl = bakIsOriginal = bakExists && DefaultDarkModePatcher.verifySha256(bakPath, EXPECTED_SHA256);
            if (zipIsOriginal) {
                boolean ok;
                if (!bakExists) {
                    Files.copy(zipPath, bakPath, StandardCopyOption.COPY_ATTRIBUTES);
                    LOGGER.info("Created backup .bak: {}", (Object)bakPath);
                }
                if (ok = this.patchFromSourceToZip(zipPath, patchedPath)) {
                    Files.deleteIfExists(zipPath);
                }
                return ok;
            }
            if (bakIsOriginal) {
                boolean ok = this.patchFromSourceToZip(bakPath, patchedPath);
                if (ok && Files.exists(zipPath, new LinkOption[0])) {
                    Files.deleteIfExists(zipPath);
                }
                return ok;
            }
            LOGGER.warn("Neither .zip nor .bak match expected SHA-256. Aborting patch.");
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Patch verification failed: ", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean patchFromSourceToZip(Path sourceZip, Path targetZip) {
        Path tempDir = null;
        try {
            tempDir = Files.createTempDirectory("ddm_patch_", new FileAttribute[0]);
            this.unzip(sourceZip.toFile(), tempDir.toFile());
            Path packMcmeta = tempDir.resolve("pack.mcmeta");
            Files.writeString(packMcmeta, (CharSequence)UPDATED_PACK_MCMETA, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            this.injectSlotTexture(tempDir, "nautilus_armor.png");
            this.injectSlotTexture(tempDir, "spear.png");
            this.injectGuiTexture(tempDir, "nautilus.png");
            this.zipDirectory(tempDir.toFile(), targetZip.toFile());
            LOGGER.info("Repackaged patched resource pack as: {}", (Object)targetZip);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Error during patching: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (tempDir != null) {
                try {
                    this.deleteDirectoryRecursively(tempDir.toFile());
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void injectSlotTexture(Path tempDir, String fileName) throws IOException {
        Path targetDir = tempDir.resolve("assets/minecraft/textures/gui/sprites/container/slot");
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (InputStream in = DefaultDarkModePatcher.class.getResourceAsStream("/assets/defaultdarkmodepatcher/slot/" + fileName);){
            if (in != null) {
                Files.copy(in, targetDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Injected slot texture: {}", (Object)fileName);
            } else {
                LOGGER.warn("Missing bundled texture: {}", (Object)fileName);
            }
        }
    }

    private void injectGuiTexture(Path tempDir, String fileName) throws IOException {
        Path targetDir = tempDir.resolve("assets/minecraft/textures/gui/container");
        Files.createDirectories(targetDir, new FileAttribute[0]);
        try (InputStream in = DefaultDarkModePatcher.class.getResourceAsStream("/assets/defaultdarkmodepatcher/gui/container/" + fileName);){
            if (in != null) {
                Files.copy(in, targetDir.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("Injected GUI texture: {}", (Object)fileName);
            } else {
                LOGGER.warn("Missing bundled GUI texture: {}", (Object)fileName);
            }
        }
    }

    private static boolean verifySha256(Path file, String expectedUpperHex) {
        try {
            String actual = DefaultDarkModePatcher.computeSHA256(file);
            return expectedUpperHex.equalsIgnoreCase(actual);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String computeSHA256(Path file) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, bytesRead);
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    private void unzip(File zipFile, File targetDir) throws IOException {
        byte[] buffer = new byte[4096];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File newFile = this.newFile(targetDir, entry);
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    newFile.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target directory: " + zipEntry.getName());
        }
        return destFile;
    }

    private void zipDirectory(File sourceDir, File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.zipFileRecursive(sourceDir, sourceDir, zos);
        }
    }

    private void zipFileRecursive(File rootDir, File sourceFile, ZipOutputStream zos) throws IOException {
        block8: {
            block7: {
                if (!sourceFile.isDirectory()) break block7;
                File[] children = sourceFile.listFiles();
                if (children == null) break block8;
                for (File file : children) {
                    this.zipFileRecursive(rootDir, file, zos);
                }
                break block8;
            }
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                int len;
                String zipEntryName = rootDir.toURI().relativize(sourceFile.toURI()).getPath();
                ZipEntry zipEntry = new ZipEntry(zipEntryName);
                zos.putNextEntry(zipEntry);
                byte[] buffer = new byte[4096];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
            }
        }
    }

    private void deleteDirectoryRecursively(File file) throws IOException {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteDirectoryRecursively(child);
            }
        }
        if (!file.delete()) {
            LOGGER.warn("Unable to delete: {}", (Object)file.getAbsolutePath());
        }
    }
}

