/*
 * Decompiled with CFR 0.152.
 */
package xyz.pupbrained.drop_confirm.mixin;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1268;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pupbrained.drop_confirm.DropConfirm;
import xyz.pupbrained.drop_confirm.config.ConfirmationMode;
import xyz.pupbrained.drop_confirm.config.DropConfirmConfig;
import xyz.pupbrained.drop_confirm.screens.PopupScreen;
import xyz.pupbrained.drop_confirm.util.ComponentUtils;

@Mixin(value={class_746.class})
public class ItemDropMixin {
    @Unique
    private static final ScheduledExecutorService drop_confirm$scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "DropConfirm-Scheduler");
        thread.setDaemon(true);
        return thread;
    });
    @Shadow
    @Final
    protected class_310 field_3937;

    @Inject(method={"swing"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandSwing(class_1268 hand, CallbackInfo ci) {
        if (DropConfirm.isConfirmed()) {
            ci.cancel();
        }
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    private void onItemDrop(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        class_2846.class_2847 action;
        class_746 player = (class_746)this;
        class_1661 inventory = player.method_31548();
        class_1799 itemStack = inventory.method_7391();
        if (!DropConfirmConfig.isEnabled() || itemStack.method_7960()) {
            return;
        }
        class_2846.class_2847 class_28472 = action = entireStack ? class_2846.class_2847.field_12970 : class_2846.class_2847.field_12975;
        if (DropConfirmConfig.getBlacklistedItems().contains(itemStack.method_7909()) ^ DropConfirmConfig.shouldTreatAsWhitelist()) {
            return;
        }
        if (!DropConfirm.isConfirmed()) {
            String keyMessage = this.field_3937.field_1690.field_1869.method_16007().getString();
            ConfirmationMode mode = DropConfirmConfig.getConfirmationMode();
            switch (mode) {
                case POPUP: {
                    this.field_3937.method_1507((class_437)new PopupScreen(itemStack));
                    break;
                }
                case ACTIONBAR: {
                    player.method_7353((class_2561)ComponentUtils.translatable("drop_confirm.confirmation", keyMessage), true);
                    break;
                }
                case CHAT: {
                    player.method_7353((class_2561)ComponentUtils.translatable("drop_confirm.confirmation", keyMessage), false);
                }
            }
            DropConfirm.setConfirmed(true);
            if (mode != ConfirmationMode.POPUP) {
                drop_confirm$scheduler.schedule(() -> {
                    Class<DropConfirm> clazz = DropConfirm.class;
                    synchronized (DropConfirm.class) {
                        DropConfirm.setConfirmed(false);
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                }, (long)(DropConfirmConfig.getResetDelay() * 1000.0), TimeUnit.MILLISECONDS);
            }
        } else {
            DropConfirm.setConfirmed(false);
            itemStack = inventory.method_37417(entireStack);
            this.field_3937.field_1705.method_1758(ComponentUtils.empty(), false);
            if (DropConfirmConfig.shouldPlaySounds()) {
                player.method_5783(class_3417.field_34375, 1.0f, 1.0f);
            }
            player.field_3944.method_52787((class_2596)new class_2846(action, class_2338.field_10980, class_2350.field_11033));
        }
        cir.setReturnValue((Object)(!itemStack.method_7960() ? 1 : 0));
    }
}

