/*
 * Decompiled with CFR 0.152.
 */
package xyz.pupbrained.drop_confirm.mixin;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pupbrained.drop_confirm.DropConfirm;
import xyz.pupbrained.drop_confirm.config.ConfirmationMode;
import xyz.pupbrained.drop_confirm.config.DropConfirmConfig;
import xyz.pupbrained.drop_confirm.screens.PopupScreen;
import xyz.pupbrained.drop_confirm.util.ComponentUtils;

@Mixin(value={LocalPlayer.class})
public class ItemDropMixin {
    @Unique
    private static final ScheduledExecutorService drop_confirm$scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "DropConfirm-Scheduler");
        thread.setDaemon(true);
        return thread;
    });
    @Shadow
    @Final
    protected Minecraft f_108619_;

    @Inject(method={"swing"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandSwing(InteractionHand hand, CallbackInfo ci) {
        if (DropConfirm.isConfirmed()) {
            ci.cancel();
        }
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    private void onItemDrop(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        ServerboundPlayerActionPacket.Action action;
        LocalPlayer player = (LocalPlayer)this;
        Inventory inventory = player.m_150109_();
        ItemStack itemStack = inventory.m_36056_();
        if (!DropConfirmConfig.isEnabled() || itemStack.m_41619_()) {
            return;
        }
        ServerboundPlayerActionPacket.Action action2 = action = entireStack ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
        if (DropConfirmConfig.getBlacklistedItems().contains(itemStack.m_41720_()) ^ DropConfirmConfig.shouldTreatAsWhitelist()) {
            return;
        }
        if (!DropConfirm.isConfirmed()) {
            String keyMessage = this.f_108619_.f_91066_.f_92094_.m_90863_().getString().toUpperCase();
            ConfirmationMode mode = DropConfirmConfig.getConfirmationMode();
            switch (mode) {
                case POPUP: {
                    this.f_108619_.m_91152_((Screen)new PopupScreen(itemStack));
                    break;
                }
                case ACTIONBAR: {
                    player.m_5661_((Component)ComponentUtils.translatable("drop_confirm.confirmation", keyMessage), true);
                    break;
                }
                case CHAT: {
                    player.m_5661_((Component)ComponentUtils.translatable("drop_confirm.confirmation", keyMessage), false);
                }
            }
            DropConfirm.setConfirmed(true);
            if (mode != ConfirmationMode.POPUP) {
                drop_confirm$scheduler.schedule(() -> {
                    Class<DropConfirm> clazz = DropConfirm.class;
                    synchronized (DropConfirm.class) {
                        DropConfirm.setConfirmed(false);
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                }, (long)(DropConfirmConfig.getResetDelay() * 1000.0f), TimeUnit.MILLISECONDS);
            }
        } else {
            DropConfirm.setConfirmed(false);
            itemStack = inventory.m_7407_(inventory.f_35977_, entireStack && !inventory.m_36056_().m_41619_() ? inventory.m_36056_().m_41613_() : 1);
            this.f_108619_.f_91065_.m_93063_(ComponentUtils.empty(), false);
            if (DropConfirmConfig.shouldPlaySounds()) {
                player.m_5496_(SoundEvents.f_184214_, 1.0f, 1.0f);
            }
            player.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(action, BlockPos.f_121853_, Direction.DOWN));
        }
        cir.setReturnValue((Object)(!itemStack.m_41619_() ? 1 : 0));
    }
}

