/*
 * Decompiled with CFR 0.152.
 */
package xyz.pupbrained.drop_confirm.mixin;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pupbrained.drop_confirm.DropConfirm;
import xyz.pupbrained.drop_confirm.config.ConfirmationMode;
import xyz.pupbrained.drop_confirm.config.DropConfirmConfig;
import xyz.pupbrained.drop_confirm.screens.PopupScreen;
import xyz.pupbrained.drop_confirm.util.ComponentUtils;

@Mixin(value={LocalPlayer.class})
public class ItemDropMixin {
    @Unique
    private static final ScheduledExecutorService drop_confirm$scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r, "DropConfirm-Scheduler");
        thread.setDaemon(true);
        return thread;
    });
    @Shadow
    @Final
    protected Minecraft minecraft;

    @Inject(method={"swing"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandSwing(InteractionHand hand, CallbackInfo ci) {
        if (DropConfirm.isConfirmed()) {
            ci.cancel();
        }
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    private void onItemDrop(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        ServerboundPlayerActionPacket.Action action;
        LocalPlayer player = (LocalPlayer)this;
        Inventory inventory = player.getInventory();
        ItemStack itemStack = inventory.getSelected();
        if (!DropConfirmConfig.isEnabled() || itemStack.isEmpty()) {
            return;
        }
        ServerboundPlayerActionPacket.Action action2 = action = entireStack ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
        if (DropConfirmConfig.getBlacklistedItems().contains(itemStack.getItem()) ^ DropConfirmConfig.shouldTreatAsWhitelist()) {
            return;
        }
        if (!DropConfirm.isConfirmed()) {
            String keyMessage = this.minecraft.options.keyDrop.getTranslatedKeyMessage().getString();
            ConfirmationMode mode = DropConfirmConfig.getConfirmationMode();
            switch (mode) {
                case POPUP: {
                    this.minecraft.setScreen((Screen)new PopupScreen(itemStack));
                    break;
                }
                case ACTIONBAR: {
                    player.displayClientMessage((Component)ComponentUtils.translatable("drop_confirm.confirmation", keyMessage), true);
                    break;
                }
                case CHAT: {
                    player.displayClientMessage((Component)ComponentUtils.translatable("drop_confirm.confirmation", keyMessage), false);
                }
            }
            DropConfirm.setConfirmed(true);
            if (mode != ConfirmationMode.POPUP) {
                drop_confirm$scheduler.schedule(() -> {
                    Class<DropConfirm> clazz = DropConfirm.class;
                    synchronized (DropConfirm.class) {
                        DropConfirm.setConfirmed(false);
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                }, (long)(DropConfirmConfig.getResetDelay() * 1000.0), TimeUnit.MILLISECONDS);
            }
        } else {
            DropConfirm.setConfirmed(false);
            itemStack = inventory.removeFromSelected(entireStack);
            this.minecraft.gui.setOverlayMessage(ComponentUtils.empty(), false);
            if (DropConfirmConfig.shouldPlaySounds()) {
                player.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 1.0f, 1.0f);
            }
            player.connection.send((Packet)new ServerboundPlayerActionPacket(action, BlockPos.ZERO, Direction.DOWN));
        }
        cir.setReturnValue((Object)(!itemStack.isEmpty() ? 1 : 0));
    }
}

