/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.commands;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SleepCommand
implements CommandExecutor,
TabCompleter {
    private final EasySleep plugin;

    public SleepCommand(EasySleep plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("easysleep.admin")) {
            MessageUtils.sendMessage(sender, "&cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                return this.handleSetCommand(sender, args);
            }
            case "get": {
                return this.handleGetCommand(sender);
            }
            case "status": {
                return this.handleStatusCommand(sender);
            }
            case "reset": {
                return this.handleResetCommand(sender);
            }
            case "reload": {
                return this.handleReloadCommand(sender);
            }
            case "help": {
                this.sendHelpMessage(sender);
                return true;
            }
        }
        MessageUtils.sendMessage(sender, "&cUnknown subcommand: " + subCommand);
        this.sendHelpMessage(sender);
        return true;
    }

    private boolean handleSetCommand(CommandSender sender, String[] args) {
        int percentage;
        if (args.length < 2) {
            MessageUtils.sendMessage(sender, "&cUsage: /sleep set <percentage>");
            return true;
        }
        try {
            percentage = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            MessageUtils.sendMessage(sender, "&cInvalid number: " + args[1]);
            return true;
        }
        if (percentage < 0 || percentage > 100) {
            MessageUtils.sendMessage(sender, "&cPercentage must be between 0 and 100!");
            return true;
        }
        World world = this.getTargetWorld(sender);
        if (world == null) {
            MessageUtils.sendMessage(sender, "&cCould not determine target world!");
            return true;
        }
        world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)percentage);
        MessageUtils.sendMessage(sender, "&aSuccessfully set sleep percentage to &e" + percentage + "% &ain world &e" + world.getName());
        this.plugin.getLogger().info(sender.getName() + " set sleep percentage to " + percentage + "% in world " + world.getName());
        return true;
    }

    private boolean handleGetCommand(CommandSender sender) {
        World world = this.getTargetWorld(sender);
        if (world == null) {
            MessageUtils.sendMessage(sender, "&cCould not determine target world!");
            return true;
        }
        Integer currentPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
        if (currentPercentage == null) {
            MessageUtils.sendMessage(sender, "&cCould not retrieve sleep percentage!");
            return true;
        }
        MessageUtils.sendMessage(sender, "&aCurrent sleep percentage in &e" + world.getName() + "&a: &e" + currentPercentage + "%");
        return true;
    }

    private boolean handleStatusCommand(CommandSender sender) {
        World world = this.getTargetWorld(sender);
        if (world == null) {
            MessageUtils.sendMessage(sender, "&cCould not determine target world!");
            return true;
        }
        Integer currentPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
        int totalPlayers = world.getPlayers().size();
        int sleepingPlayers = world.getPlayers().stream().mapToInt(p -> p.isSleeping() ? 1 : 0).sum();
        MessageUtils.sendMessage(sender, "&6\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        MessageUtils.sendMessage(sender, "&6\u2551 &b\u26a1 &f&lSLEEP PROTOCOL STATUS &b\u26a1 &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage(sender, "&6\u2551 &fWorld: &e" + world.getName() + String.format("%" + (28 - world.getName().length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fSleep Percentage: &a" + (currentPercentage != null ? currentPercentage + "%" : "Unknown") + String.format("%" + (18 - String.valueOf(currentPercentage != null ? currentPercentage : 0).length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fOnline Players: &e" + totalPlayers + String.format("%" + (20 - String.valueOf(totalPlayers).length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fCurrently Sleeping: &b" + sleepingPlayers + String.format("%" + (16 - String.valueOf(sleepingPlayers).length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fTime: &e" + this.getTimeString(world.getTime()) + String.format("%" + (25 - this.getTimeString(world.getTime()).length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fStatus: " + (world.getTime() > 12000L ? "&cNight" : "&aDay") + String.format("%" + (26 - (world.getTime() > 12000L ? "Night" : "Day").length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fAnimations: " + (this.plugin.getConfigManager().areAnimationsEnabled() ? "&aEnabled" : "&cDisabled") + String.format("%" + (19 - (this.plugin.getConfigManager().areAnimationsEnabled() ? "Enabled" : "Disabled").length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &fDay Counter: " + (this.plugin.getConfigManager().isDayCounterEnabled() ? "&aDay " + this.plugin.getDayCounterManager().getCurrentDay(world) : "&cDisabled") + String.format("%" + (15 - (this.plugin.getConfigManager().isDayCounterEnabled() ? "Day " + this.plugin.getDayCounterManager().getCurrentDay(world) : "Disabled").length()) + "s", "") + "&6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage(sender, "&6\u2551 &7System operational since plugin load     &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        return true;
    }

    private String getTimeString(long time) {
        if (time >= 0L && time < 6000L) {
            return "Morning";
        }
        if (time >= 6000L && time < 12000L) {
            return "Day";
        }
        if (time >= 12000L && time < 18000L) {
            return "Evening";
        }
        return "Night";
    }

    private boolean handleResetCommand(CommandSender sender) {
        World world = this.getTargetWorld(sender);
        if (world == null) {
            MessageUtils.sendMessage(sender, "&cCould not determine target world!");
            return true;
        }
        world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)1);
        MessageUtils.sendMessage(sender, "&a\u2713 &fSleep percentage &areset to optimal value &e(1%) &ain world &e" + world.getName());
        this.plugin.getLogger().info(sender.getName() + " reset sleep percentage to 1% in world " + world.getName());
        return true;
    }

    private boolean handleReloadCommand(CommandSender sender) {
        try {
            this.plugin.getConfigManager().reloadConfig();
            MessageUtils.sendMessage(sender, "&a\u2713 &fConfiguration &areloaded successfully&f!");
            this.plugin.getLogger().info(sender.getName() + " reloaded EasySleep configuration");
        }
        catch (Exception e) {
            MessageUtils.sendMessage(sender, "&c\u2717 &fFailed to reload configuration: " + e.getMessage());
            this.plugin.getLogger().warning("Failed to reload configuration: " + e.getMessage());
        }
        return true;
    }

    private World getTargetWorld(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getWorld();
        }
        return (World)this.plugin.getServer().getWorlds().get(0);
    }

    private void sendHelpMessage(CommandSender sender) {
        MessageUtils.sendMessage(sender, "&6\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        MessageUtils.sendMessage(sender, "&6\u2551 &b\u26a1 &f&lEASYSLEEP COMMAND MATRIX &b\u26a1 &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage(sender, "&6\u2551 &e/sleep set <0-100> &7- Configure sleep %  &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &e/sleep get &7- View current settings     &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &e/sleep status &7- Live system monitor    &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &e/sleep reset &7- Reset to optimal (1%)   &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &e/sleep reload &7- Hot-reload config      &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &e/sleep help &7- Show this matrix         &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage(sender, "&6\u2551 &7Aliases: &e/sleepmanager, /sleepmgr      &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2551 &7         &e/nightskip                    &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage(sender, "&6\u2551 &7EasySleep &ev" + this.plugin.getDescription().getVersion() + " &7by &eTurjo              &6\u2551");
        MessageUtils.sendMessage(sender, "&6\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block4: {
            block3: {
                completions = new ArrayList<String>();
                if (!sender.hasPermission("easysleep.admin")) {
                    return completions;
                }
                if (args.length != 1) break block3;
                String partial = args[0].toLowerCase();
                List<String> subCommands = Arrays.asList("set", "get", "status", "reset", "reload", "help");
                for (String subCommand : subCommands) {
                    if (!subCommand.startsWith(partial)) continue;
                    completions.add(subCommand);
                }
                break block4;
            }
            if (args.length != 2 || !args[0].equalsIgnoreCase("set")) break block4;
            String partial = args[1];
            List<String> suggestions = Arrays.asList("1", "10", "25", "50", "75", "100");
            for (String suggestion : suggestions) {
                if (!suggestion.startsWith(partial)) continue;
                completions.add(suggestion);
            }
        }
        return completions;
    }
}

