/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.listeners;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.managers.AnimationManager;
import com.turjo.easysleep.utils.MessageUtils;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepEventListener
implements Listener {
    private final EasySleep plugin;
    private final AnimationManager animationManager;

    public SleepEventListener(EasySleep plugin) {
        this.plugin = plugin;
        this.animationManager = plugin.getAnimationManager();
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        final Player player = event.getPlayer();
        World world = player.getWorld();
        if (this.plugin.getConfigManager().areAnimationsEnabled()) {
            new BukkitRunnable(){

                public void run() {
                    if (player.isOnline() && player.isSleeping()) {
                        SleepEventListener.this.animationManager.startSleepAnimation(player);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 5L);
        }
        int totalPlayers = world.getPlayers().size();
        long sleepingCount = world.getPlayers().stream().filter(LivingEntity::isSleeping).count();
        int sleepingPlayers = (int)sleepingCount;
        Integer sleepPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
        int requiredPlayers = (int)Math.ceil((double)((sleepPercentage != null ? sleepPercentage : 100) * totalPlayers) / 100.0);
        if (this.plugin.getConfigManager().shouldBroadcastSleepMessages()) {
            if (this.plugin.getConfigManager().useReducedMessages()) {
                MessageUtils.broadcastToWorld(world, "&b\u26a1 &e" + player.getName() + " &7is sleeping &8(&a" + sleepingPlayers + "&7/&e" + requiredPlayers + "&8)");
            } else {
                MessageUtils.broadcastToWorld(world, "");
                MessageUtils.broadcastToWorld(world, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                MessageUtils.broadcastToWorld(world, "&b\u26a1 &f&lSLEEP PROTOCOL &b&lINITIATED &b\u26a1");
                MessageUtils.broadcastToWorld(world, "&7\u250c\u2500 &e" + player.getName() + " &7has entered &bdream state");
                MessageUtils.broadcastToWorld(world, "&7\u251c\u2500 &fSleeping: &a" + sleepingPlayers + "&7/&c" + totalPlayers + " &7players");
                MessageUtils.broadcastToWorld(world, "&7\u251c\u2500 &fRequired: &e" + requiredPlayers + " &7players");
                MessageUtils.broadcastToWorld(world, "&7\u2514\u2500 &fStatus: " + (sleepingPlayers >= requiredPlayers ? "&a\u2713 NIGHT SKIP READY" : "&c\u26a0 AWAITING MORE DREAMERS"));
                MessageUtils.broadcastToWorld(world, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                MessageUtils.broadcastToWorld(world, "");
            }
        }
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        this.animationManager.stopAnimation(player);
        int totalPlayers = world.getPlayers().size();
        long sleepingCount = world.getPlayers().stream().filter(LivingEntity::isSleeping).count();
        int sleepingPlayers = (int)sleepingCount;
        if (this.plugin.getConfigManager().shouldBroadcastSleepMessages()) {
            if (this.plugin.getConfigManager().useReducedMessages()) {
                MessageUtils.broadcastToWorld(world, "&c\u26a0 &e" + player.getName() + " &7woke up &8(&a" + sleepingPlayers + "&7/&c" + totalPlayers + "&8)");
            } else {
                MessageUtils.broadcastToWorld(world, "");
                MessageUtils.broadcastToWorld(world, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                MessageUtils.broadcastToWorld(world, "&c\u26a0 &f&lSLEEP PROTOCOL &c&lINTERRUPTED &c\u26a0");
                MessageUtils.broadcastToWorld(world, "&7\u250c\u2500 &e" + player.getName() + " &7has &cleft dream state");
                MessageUtils.broadcastToWorld(world, "&7\u251c\u2500 &fSleeping: &a" + sleepingPlayers + "&7/&c" + totalPlayers + " &7players");
                MessageUtils.broadcastToWorld(world, "&7\u2514\u2500 &fStatus: &c\u26a0 NIGHT SKIP CANCELLED");
                MessageUtils.broadcastToWorld(world, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
                MessageUtils.broadcastToWorld(world, "");
            }
        }
    }

    @EventHandler
    public void onTimeSkip(TimeSkipEvent event) {
        if (event.getSkipReason() == TimeSkipEvent.SkipReason.NIGHT_SKIP) {
            World world = event.getWorld();
            if (this.plugin.getConfigManager().areAnimationsEnabled()) {
                this.plugin.getAnimationManager().startNightSkipAnimation(world);
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        if (this.plugin.getConfigManager().shouldAutoConfigureNewWorlds()) {
            Integer currentPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
            int defaultPercentage = this.plugin.getConfigManager().getDefaultSleepPercentage();
            if (currentPercentage == null || currentPercentage == 100) {
                world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)defaultPercentage);
                this.plugin.getLogger().info("Auto-configured world '" + world.getName() + "' with " + defaultPercentage + "% sleep requirement");
            }
        }
    }
}

