/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AnimationManager {
    private final EasySleep plugin;
    private final Map<Player, BukkitTask> activeAnimations;
    private final Random random;

    public AnimationManager(EasySleep plugin) {
        this.plugin = plugin;
        this.activeAnimations = new HashMap<Player, BukkitTask>();
        this.random = new Random();
    }

    public void startSleepAnimation(final Player player) {
        if (!this.plugin.getConfigManager().areAnimationsEnabled()) {
            return;
        }
        this.stopAnimation(player);
        BukkitTask task = new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!player.isOnline() || !player.isSleeping()) {
                    this.cancel();
                    return;
                }
                Location loc = player.getLocation().add(0.0, 1.0, 0.0);
                if (this.ticks % 10 == 0) {
                    for (int i = 0; i < 5; ++i) {
                        double angle = (double)(this.ticks + i * 72) * Math.PI / 180.0;
                        double x = Math.cos(angle) * 2.0;
                        double z = Math.sin(angle) * 2.0;
                        Location particleLoc = loc.clone().add(x, Math.sin((double)this.ticks * 0.1) * 0.5, z);
                        player.getWorld().spawnParticle(Particle.END_ROD, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                        player.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, particleLoc, 2, 0.1, 0.1, 0.1, 0.0);
                    }
                }
                if (this.ticks % 40 == 0 && AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) {
                    float volume = (float)((double)0.2f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                    player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_CHIME, volume, 1.8f);
                }
                if (this.ticks % 5 == 0 && AnimationManager.this.isPlayerInRange(player, loc)) {
                    player.getWorld().spawnParticle(Particle.CLOUD, loc, 1, 0.5, 0.2, 0.5, 0.01);
                }
                ++this.ticks;
                if (this.ticks > 600) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.activeAnimations.put(player, task);
    }

    private boolean isPlayerInRange(Player player, Location center) {
        int maxDistance = this.plugin.getConfigManager().getMaxAnimationDistance();
        for (Player p : player.getWorld().getPlayers()) {
            if (!(p.getLocation().distance(center) <= (double)maxDistance)) continue;
            return true;
        }
        return false;
    }

    public void startNightSkipAnimation(World world) {
        if (!this.plugin.getConfigManager().areAnimationsEnabled()) {
            MessageUtils.broadcastToWorld(world, "&b\u2726 &f&lNIGHT SKIP ACTIVATED &b\u2726");
            return;
        }
        ArrayList<Player> sleepingPlayers = new ArrayList<Player>();
        ArrayList<Player> awakePlayers = new ArrayList<Player>();
        for (Player player : world.getPlayers()) {
            if (player.isSleeping()) {
                sleepingPlayers.add(player);
                continue;
            }
            awakePlayers.add(player);
        }
        if (!this.plugin.getConfigManager().useReducedMessages()) {
            MessageUtils.broadcastToWorld(world, "");
            MessageUtils.broadcastToWorld(world, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
            MessageUtils.broadcastToWorld(world, "&b\u2726 &f&lNIGHT SKIP PROTOCOL &b&lACTIVATED &b\u2726");
            MessageUtils.broadcastToWorld(world, "&7\u26a1 &eDream sequence initiated... &7\u26a1");
            MessageUtils.broadcastToWorld(world, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
            MessageUtils.broadcastToWorld(world, "");
        } else {
            MessageUtils.broadcastToWorld(world, "&b\u2726 &f&lNIGHT SKIP ACTIVATED &b\u2726");
        }
        this.startEpicSleepAnimation(sleepingPlayers);
        this.startMysticalAwakeAnimation(awakePlayers);
        this.startWorldEffects(world);
    }

    private void startEpicSleepAnimation(final List<Player> players) {
        new BukkitRunnable(){
            int phase = 0;

            public void run() {
                for (Player player : players) {
                    if (!player.isOnline()) continue;
                    Location loc = player.getLocation().add(0.0, 1.0, 0.0);
                    switch (this.phase) {
                        case 0: {
                            double z;
                            double x;
                            double angle;
                            for (int i = 0; i < 8; ++i) {
                                angle = (double)(i * 45) * Math.PI / 180.0;
                                double radius = 1.5 + Math.sin((double)this.phase * 0.2) * 0.5;
                                x = Math.cos(angle) * radius;
                                z = Math.sin(angle) * radius;
                                Location spiralLoc = loc.clone().add(x, Math.sin(angle + (double)this.phase * 0.3) * 0.8, z);
                                player.getWorld().spawnParticle(Particle.END_ROD, spiralLoc, 1, 0.0, 0.0, 0.0, 0.0);
                                player.getWorld().spawnParticle(Particle.DRAGON_BREATH, spiralLoc, 2, 0.1, 0.1, 0.1, 0.0);
                            }
                            if (!AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) break;
                            float volume = (float)((double)0.3f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                            player.playSound(loc, Sound.BLOCK_BEACON_AMBIENT, volume, 1.8f);
                            break;
                        }
                        case 1: {
                            double z;
                            double x;
                            double angle;
                            for (int i = 0; i < 12; ++i) {
                                angle = (double)(i * 30) * Math.PI / 180.0;
                                double distance = 2.5;
                                x = Math.cos(angle) * distance;
                                z = Math.sin(angle) * distance;
                                Location burstLoc = loc.clone().add(x, 1.0, z);
                                player.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, burstLoc, 3, 0.2, 0.2, 0.2, 0.1);
                                player.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, burstLoc, 5, 0.3, 0.3, 0.3, 0.0);
                            }
                            if (!AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) break;
                            float volume = (float)((double)0.4f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                            player.playSound(loc, Sound.ENTITY_FIREWORK_ROCKET_TWINKLE, volume, 1.5f);
                            break;
                        }
                        case 2: {
                            player.getWorld().spawnParticle(Particle.TOTEM, loc, 20, 1.0, 1.0, 1.0, 0.1);
                            player.getWorld().spawnParticle(Particle.END_ROD, loc, 15, 0.8, 0.8, 0.8, 0.05);
                            if (AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) {
                                float volume = (float)(0.5 * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                                player.playSound(loc, Sound.ENTITY_PLAYER_LEVELUP, volume, 2.0f);
                            }
                            if (AnimationManager.this.plugin.getConfigManager().useReducedMessages()) break;
                            MessageUtils.sendMessage((CommandSender)player, "&b\u2726 &f&lDREAM SEQUENCE COMPLETE &b\u2726");
                            MessageUtils.sendMessage((CommandSender)player, "&7Your peaceful slumber has &eaccelerated time&7...");
                        }
                    }
                }
                ++this.phase;
                if (this.phase >= 3) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void startMysticalAwakeAnimation(final List<Player> players) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                for (Player player : players) {
                    if (!player.isOnline()) continue;
                    Location loc = player.getLocation().add(0.0, 1.0, 0.0);
                    if (this.ticks % 5 == 0) {
                        double angle = (double)this.ticks * 0.2;
                        for (int i = 0; i < 6; ++i) {
                            double currentAngle = angle + (double)(i * 60) * Math.PI / 180.0;
                            double x = Math.cos(currentAngle) * 1.2;
                            double z = Math.sin(currentAngle) * 1.2;
                            Location auraLoc = loc.clone().add(x, Math.sin(currentAngle * 2.0) * 0.3, z);
                            player.getWorld().spawnParticle(Particle.PORTAL, auraLoc, 2, 0.1, 0.1, 0.1, 0.0);
                            player.getWorld().spawnParticle(Particle.SPELL_WITCH, auraLoc, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    if (this.ticks % 15 == 0) {
                        player.getWorld().spawnParticle(Particle.REVERSE_PORTAL, loc, 8, 0.5, 0.5, 0.5, 0.02);
                        if (AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) {
                            float volume = (float)((double)0.2f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                            player.playSound(loc, Sound.BLOCK_PORTAL_AMBIENT, volume, 1.8f);
                        }
                    }
                    if (this.ticks != 20 || AnimationManager.this.plugin.getConfigManager().useReducedMessages()) continue;
                    MessageUtils.sendMessage((CommandSender)player, "&5\u2727 &f&lTIME DISTORTION DETECTED &5\u2727");
                    MessageUtils.sendMessage((CommandSender)player, "&7Reality bends around the &edreaming souls&7...");
                }
                ++this.ticks;
                if (this.ticks >= 60) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void startWorldEffects(final World world) {
        new BukkitRunnable(){
            int phase = 0;

            public void run() {
                if (this.phase % 10 == 0) {
                    for (Player player : world.getPlayers()) {
                        if (!(AnimationManager.this.random.nextDouble() < 0.3)) continue;
                        Location strikeLoc = player.getLocation().add((double)(AnimationManager.this.random.nextInt(20) - 10), 0.0, (double)(AnimationManager.this.random.nextInt(20) - 10));
                        world.strikeLightningEffect(strikeLoc);
                    }
                }
                if (this.phase == 0) {
                    for (Player player : world.getPlayers()) {
                        if (!AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) continue;
                        float volume = (float)((double)0.2f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                        player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, volume, 0.8f);
                    }
                } else if (this.phase == 30) {
                    for (Player player : world.getPlayers()) {
                        if (!AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) continue;
                        float volume = (float)((double)0.15f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                        player.playSound(player.getLocation(), Sound.ENTITY_WITHER_SPAWN, volume, 2.0f);
                    }
                } else if (this.phase == 60) {
                    for (Player player : world.getPlayers()) {
                        if (!AnimationManager.this.plugin.getConfigManager().areSoundEffectsEnabled()) continue;
                        float volume = (float)((double)0.4f * AnimationManager.this.plugin.getConfigManager().getSoundVolume());
                        player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, volume, 1.2f);
                    }
                    if (!AnimationManager.this.plugin.getConfigManager().useReducedMessages()) {
                        MessageUtils.broadcastToWorld(world, "");
                        MessageUtils.broadcastToWorld(world, "&a\u2713 &f&lNIGHT SKIP COMPLETE &a\u2713");
                        MessageUtils.broadcastToWorld(world, "&7\u26a1 &eWelcome to a new dawn! &7\u26a1");
                        MessageUtils.broadcastToWorld(world, "");
                    }
                }
                ++this.phase;
                if (this.phase >= 80) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void stopAnimation(Player player) {
        BukkitTask task = this.activeAnimations.remove(player);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    public void stopAllAnimations() {
        for (BukkitTask task : this.activeAnimations.values()) {
            if (task.isCancelled()) continue;
            task.cancel();
        }
        this.activeAnimations.clear();
    }

    public void cleanup() {
        this.stopAllAnimations();
    }
}

