/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AFKManager {
    private final EasySleep plugin;
    private final Map<UUID, PlayerActivity> playerActivity;
    private final Map<UUID, Boolean> afkPlayers;

    public AFKManager(EasySleep plugin) {
        this.plugin = plugin;
        this.playerActivity = new HashMap<UUID, PlayerActivity>();
        this.afkPlayers = new HashMap<UUID, Boolean>();
        this.startAFKChecker();
    }

    public void updateActivity(Player player) {
        if (!this.plugin.getConfigManager().isAFKDetectionEnabled()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        Location currentLoc = player.getLocation();
        long currentTime = System.currentTimeMillis();
        PlayerActivity activity = this.playerActivity.get(uuid);
        if (activity == null) {
            activity = new PlayerActivity(currentLoc, currentTime);
            this.playerActivity.put(uuid, activity);
        } else if (this.isSameWorld(activity.lastLocation, currentLoc) && activity.lastLocation.distance(currentLoc) > 1.0) {
            activity.lastLocation = currentLoc;
            activity.lastActivity = currentTime;
            if (this.afkPlayers.getOrDefault(uuid, false).booleanValue()) {
                this.afkPlayers.put(uuid, false);
                if (this.plugin.getConfigManager().isDebugMode()) {
                    this.plugin.getLogger().info(player.getName() + " is no longer AFK");
                }
            }
        } else if (!this.isSameWorld(activity.lastLocation, currentLoc)) {
            activity.lastLocation = currentLoc;
            activity.lastActivity = currentTime;
        }
    }

    private boolean isSameWorld(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.getWorld() == null || loc2.getWorld() == null) {
            return false;
        }
        return loc1.getWorld().equals((Object)loc2.getWorld());
    }

    public boolean isPlayerAFK(Player player) {
        return this.afkPlayers.getOrDefault(player.getUniqueId(), false);
    }

    private long getAFKThreshold() {
        return (long)(this.plugin.getConfigManager().getAFKThreshold() * 60) * 1000L;
    }

    private void startAFKChecker() {
        new BukkitRunnable(){

            public void run() {
                if (!AFKManager.this.plugin.getConfigManager().isAFKDetectionEnabled()) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                long threshold = AFKManager.this.getAFKThreshold();
                for (Player player : AFKManager.this.plugin.getServer().getOnlinePlayers()) {
                    UUID uuid = player.getUniqueId();
                    PlayerActivity activity = (PlayerActivity)AFKManager.this.playerActivity.get(uuid);
                    if (activity != null) {
                        boolean isNowAFK;
                        boolean wasAFK = AFKManager.this.afkPlayers.getOrDefault(uuid, false);
                        boolean bl = isNowAFK = currentTime - activity.lastActivity > threshold;
                        if (wasAFK || !isNowAFK) continue;
                        AFKManager.this.afkPlayers.put(uuid, true);
                        if (!AFKManager.this.plugin.getConfigManager().isDebugMode()) continue;
                        AFKManager.this.plugin.getLogger().info(player.getName() + " is now AFK");
                        continue;
                    }
                    AFKManager.this.updateActivity(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 200L, 200L);
    }

    public void removePlayer(Player player) {
        UUID uuid = player.getUniqueId();
        this.playerActivity.remove(uuid);
        this.afkPlayers.remove(uuid);
    }

    public int getAFKCount() {
        return this.afkPlayers.values().stream().mapToInt(afk -> afk != false ? 1 : 0).sum();
    }

    public void cleanup() {
        this.playerActivity.clear();
        this.afkPlayers.clear();
    }

    private static class PlayerActivity {
        Location lastLocation;
        long lastActivity;

        PlayerActivity(Location location, long time) {
            this.lastLocation = location;
            this.lastActivity = time;
        }
    }
}

