/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.managers.MoonPhaseManager;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RewardsManager {
    private final EasySleep plugin;
    private final Map<UUID, Integer> playerStreaks;
    private final Map<UUID, Long> lastSleepTime;
    private Economy economy;

    public RewardsManager(EasySleep plugin) {
        this.plugin = plugin;
        this.playerStreaks = new HashMap<UUID, Integer>();
        this.lastSleepTime = new HashMap<UUID, Long>();
        this.setupEconomy();
        this.loadStreakData();
    }

    private void setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().info("Vault not found - economy rewards disabled");
            return;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.plugin.getLogger().info("No economy plugin found - economy rewards disabled");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.plugin.getLogger().info("Economy integration enabled with " + this.economy.getName());
    }

    public void giveSleepRewards(Player player) {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("rewards.enabled", true)) {
            return;
        }
        if (!player.hasPermission("easysleep.rewards")) {
            return;
        }
        this.updatePlayerStreak(player);
        int streak = this.getPlayerStreak(player);
        double multiplier = this.calculateMultiplier(player, streak);
        this.giveMoneyReward(player, multiplier);
        this.giveExperienceReward(player, multiplier);
        this.giveItemRewards(player);
        this.givePotionEffects(player);
        int baseDreamCoins = this.plugin.getConfigManager().getConfig().getInt("rewards.economy.dream-coins-per-sleep", 5);
        this.plugin.getSleepEconomyManager().awardDreamCoins(player, baseDreamCoins);
        this.checkStreakMilestones(player, streak);
        if (this.plugin.getConfigManager().getConfig().getBoolean("sounds.enabled", true)) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.5f);
        }
    }

    private void giveMoneyReward(Player player, double multiplier) {
        if (this.economy == null || !this.plugin.getConfigManager().getConfig().getBoolean("rewards.economy.enabled", true)) {
            return;
        }
        double baseAmount = this.plugin.getConfigManager().getConfig().getDouble("rewards.economy.money-per-sleep", 25.0);
        double amount = baseAmount * multiplier;
        try {
            EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, amount);
            if (response.transactionSuccess()) {
                String message = this.plugin.getConfigManager().getConfig().getString("messages.rewards.money-received", "&a+ $%amount% &7(Sleep reward)");
                MessageUtils.sendMessage((CommandSender)player, message.replace("%amount%", String.format("%.2f", amount)));
                if (this.plugin.getConfigManager().isDebugMode()) {
                    this.plugin.getLogger().info("Successfully deposited $" + amount + " to " + player.getName());
                }
            } else {
                this.plugin.getLogger().warning("Failed to deposit money to " + player.getName() + ": " + response.errorMessage);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error depositing money to " + player.getName() + ": " + e.getMessage());
        }
    }

    private void giveExperienceReward(Player player, double multiplier) {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("rewards.experience.enabled", true)) {
            return;
        }
        int baseXP = this.plugin.getConfigManager().getConfig().getInt("rewards.experience.xp-per-sleep", 100);
        int levels = this.plugin.getConfigManager().getConfig().getInt("rewards.experience.levels-per-sleep", 0);
        int xpAmount = (int)((double)baseXP * multiplier);
        player.giveExp(xpAmount);
        if (levels > 0) {
            player.giveExpLevels(levels);
        }
        String message = this.plugin.getConfigManager().getConfig().getString("messages.rewards.xp-received", "&a+ %amount% XP &7(Sleep reward)");
        MessageUtils.sendMessage((CommandSender)player, message.replace("%amount%", String.valueOf(xpAmount)));
    }

    private void giveItemRewards(Player player) {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("rewards.items.enabled", true)) {
            return;
        }
        List itemList = this.plugin.getConfigManager().getConfig().getStringList("rewards.items.sleep-rewards");
        for (String itemString : itemList) {
            ItemStack item = this.parseItemString(itemString);
            if (item == null) continue;
            player.getInventory().addItem(new ItemStack[]{item});
            String message = this.plugin.getConfigManager().getConfig().getString("messages.rewards.item-received", "&a+ %item% &7(Sleep reward)");
            MessageUtils.sendMessage((CommandSender)player, message.replace("%item%", item.getAmount() + "x " + item.getType().name().toLowerCase().replace("_", " ")));
        }
    }

    private void givePotionEffects(Player player) {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("rewards.effects.enabled", true)) {
            return;
        }
        List effectList = this.plugin.getConfigManager().getConfig().getStringList("rewards.effects.sleep-effects");
        for (String effectString : effectList) {
            PotionEffect effect = this.parseEffectString(effectString);
            if (effect == null) continue;
            player.addPotionEffect(effect);
            String message = this.plugin.getConfigManager().getConfig().getString("messages.rewards.effect-received", "&b+ %effect% &7(Sleep bonus)");
            MessageUtils.sendMessage((CommandSender)player, message.replace("%effect%", effect.getType().getName().toLowerCase().replace("_", " ")));
        }
    }

    private void updatePlayerStreak(Player player) {
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long lastSleep = this.lastSleepTime.getOrDefault(uuid, 0L);
        long timeDiff = currentTime - lastSleep;
        long twoDays = 172800000L;
        if (lastSleep == 0L || timeDiff <= twoDays) {
            int currentStreak = this.playerStreaks.getOrDefault(uuid, 0);
            this.playerStreaks.put(uuid, currentStreak + 1);
        } else if (this.plugin.getConfigManager().getConfig().getBoolean("rewards.streaks.reset-on-miss", false)) {
            this.playerStreaks.put(uuid, 1);
        }
        this.lastSleepTime.put(uuid, currentTime);
        this.saveStreakData();
    }

    private double calculateMultiplier(Player player, int streak) {
        MoonPhaseManager.MoonPhase moonPhase;
        double streakBonus;
        double multiplier = 1.0;
        if (streak > 1 && (multiplier += (double)(streak - 1) * 0.1) > (streakBonus = this.plugin.getConfigManager().getConfig().getDouble("rewards.economy.bonus-multiplier", 1.5))) {
            multiplier = streakBonus;
        }
        if (this.plugin.getConfigManager().getConfig().getBoolean("features.moon-phases.affect-rewards", true) && (moonPhase = this.plugin.getMoonPhaseManager().getCurrentMoonPhase(player.getWorld())) != null) {
            String phaseName = moonPhase.name();
            double phaseMultiplier = this.plugin.getConfigManager().getConfig().getDouble("features.moon-phases.bonus-multipliers." + phaseName, 1.0);
            multiplier *= phaseMultiplier;
        }
        return multiplier;
    }

    private void checkStreakMilestones(Player player, int streak) {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("rewards.streaks.milestone-rewards", true)) {
            return;
        }
        if (this.plugin.getConfigManager().getConfig().contains("rewards.items.streak-rewards." + streak)) {
            List milestoneRewards = this.plugin.getConfigManager().getConfig().getStringList("rewards.items.streak-rewards." + streak);
            for (String itemString : milestoneRewards) {
                ItemStack item = this.parseItemString(itemString);
                if (item == null) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
            if (this.plugin.getConfigManager().getConfig().getBoolean("rewards.streaks.announce-milestones", true)) {
                String message = this.plugin.getConfigManager().getConfig().getString("messages.rewards.streak-milestone", "&6\ud83c\udfc6 &e%days%-day sleep streak! &6Bonus rewards unlocked!");
                MessageUtils.sendMessage((CommandSender)player, message.replace("%days%", String.valueOf(streak)));
                player.getWorld().spawnParticle(Particle.TOTEM, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
                player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            }
        }
    }

    private ItemStack parseItemString(String itemString) {
        try {
            String[] parts = itemString.split(":");
            Material material = Material.valueOf((String)parts[0].toUpperCase());
            int amount = parts.length > 1 ? Integer.parseInt(parts[1]) : 1;
            return new ItemStack(material, amount);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid item format: " + itemString);
            return null;
        }
    }

    private PotionEffect parseEffectString(String effectString) {
        try {
            int amplifier;
            String[] parts = effectString.split(":");
            PotionEffectType effectType = PotionEffectType.getByName((String)parts[0].toUpperCase());
            int duration = parts.length > 1 ? Integer.parseInt(parts[1]) * 20 : 600;
            int n = amplifier = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            if (effectType != null) {
                return new PotionEffect(effectType, duration, amplifier);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid effect format: " + effectString);
        }
        return null;
    }

    public int getPlayerStreak(Player player) {
        return this.playerStreaks.getOrDefault(player.getUniqueId(), 0);
    }

    public void resetPlayerStreak(Player player) {
        this.playerStreaks.put(player.getUniqueId(), 0);
        this.saveStreakData();
    }

    private void loadStreakData() {
    }

    private void saveStreakData() {
    }

    public void cleanup() {
        this.saveStreakData();
        this.playerStreaks.clear();
        this.lastSleepTime.clear();
    }
}

