/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SleepAchievementManager {
    private final EasySleep plugin;
    private final Map<UUID, Set<String>> playerAchievements;
    private final Map<UUID, Map<String, Integer>> playerProgress;
    private File achievementFile;
    private FileConfiguration achievementConfig;

    public SleepAchievementManager(EasySleep plugin) {
        this.plugin = plugin;
        this.playerAchievements = new HashMap<UUID, Set<String>>();
        this.playerProgress = new HashMap<UUID, Map<String, Integer>>();
        this.setupAchievementFile();
        this.loadAchievements();
    }

    private void setupAchievementFile() {
        this.achievementFile = new File(this.plugin.getDataFolder(), "achievements.yml");
        if (!this.achievementFile.exists()) {
            try {
                this.achievementFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not create achievement file: " + e.getMessage());
            }
        }
        this.achievementConfig = YamlConfiguration.loadConfiguration((File)this.achievementFile);
    }

    private void loadAchievements() {
        for (String uuidString : this.achievementConfig.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                HashSet achievements = new HashSet(this.achievementConfig.getStringList(uuidString + ".achievements"));
                this.playerAchievements.put(uuid, achievements);
                HashMap<String, Integer> progress = new HashMap<String, Integer>();
                if (this.achievementConfig.contains(uuidString + ".progress")) {
                    for (String key : this.achievementConfig.getConfigurationSection(uuidString + ".progress").getKeys(false)) {
                        progress.put(key, this.achievementConfig.getInt(uuidString + ".progress." + key));
                    }
                }
                this.playerProgress.put(uuid, progress);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in achievements file: " + uuidString);
            }
        }
    }

    private void saveAchievements() {
        for (Map.Entry<UUID, Set<String>> entry : this.playerAchievements.entrySet()) {
            String uuidString = entry.getKey().toString();
            this.achievementConfig.set(uuidString + ".achievements", new ArrayList(entry.getValue()));
            Map<String, Integer> progress = this.playerProgress.get(entry.getKey());
            if (progress == null) continue;
            for (Map.Entry<String, Integer> progressEntry : progress.entrySet()) {
                this.achievementConfig.set(uuidString + ".progress." + progressEntry.getKey(), (Object)progressEntry.getValue());
            }
        }
        try {
            this.achievementConfig.save(this.achievementFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save achievements: " + e.getMessage());
        }
    }

    public void checkSleepAchievements(Player player) {
        if (!player.hasPermission("easysleep.achievements")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.incrementProgress(uuid, "sleep_count");
        this.checkAchievement(player, SleepAchievement.FIRST_DREAM, this.getProgress(uuid, "sleep_count"));
        this.checkAchievement(player, SleepAchievement.DREAM_WALKER, this.getProgress(uuid, "sleep_count"));
        this.checkAchievement(player, SleepAchievement.NIGHT_GUARDIAN, this.getProgress(uuid, "sleep_count"));
        this.checkAchievement(player, SleepAchievement.SLEEP_MASTER, this.getProgress(uuid, "sleep_count"));
        this.checkAchievement(player, SleepAchievement.DREAM_ARCHITECT, this.getProgress(uuid, "sleep_count"));
    }

    public void checkStreakAchievements(Player player, int streak) {
        this.checkAchievement(player, SleepAchievement.STREAK_STARTER, streak);
        this.checkAchievement(player, SleepAchievement.STREAK_CHAMPION, streak);
        this.checkAchievement(player, SleepAchievement.STREAK_LEGEND, streak);
    }

    public void checkRitualAchievements(Player player) {
        UUID uuid = player.getUniqueId();
        this.incrementProgress(uuid, "ritual_count");
        this.checkAchievement(player, SleepAchievement.RITUAL_INITIATE, this.getProgress(uuid, "ritual_count"));
        this.checkAchievement(player, SleepAchievement.RITUAL_MASTER, this.getProgress(uuid, "ritual_count"));
    }

    public void checkQuantumAchievements(Player player) {
        UUID uuid = player.getUniqueId();
        this.incrementProgress(uuid, "quantum_count");
        this.checkAchievement(player, SleepAchievement.QUANTUM_EXPLORER, this.getProgress(uuid, "quantum_count"));
    }

    public void checkDimensionalAchievements(Player player) {
        UUID uuid = player.getUniqueId();
        String worldType = player.getWorld().getEnvironment().name();
        Set<String> dimensions = this.getStringSetProgress(uuid, "dimensions_slept");
        dimensions.add(worldType);
        this.setStringSetProgress(uuid, "dimensions_slept", dimensions);
        this.checkAchievement(player, SleepAchievement.DIMENSIONAL_TRAVELER, dimensions.size());
    }

    public void checkMoonPhaseAchievements(Player player, String moonPhase) {
        UUID uuid = player.getUniqueId();
        Set<String> phases = this.getStringSetProgress(uuid, "moon_phases");
        phases.add(moonPhase);
        this.setStringSetProgress(uuid, "moon_phases", phases);
        this.checkAchievement(player, SleepAchievement.MOON_BLESSED, phases.size());
        if ("FULL_MOON".equals(moonPhase)) {
            this.incrementProgress(uuid, "full_moon_sleeps");
            this.checkAchievement(player, SleepAchievement.LUNAR_CHAMPION, this.getProgress(uuid, "full_moon_sleeps"));
        }
    }

    public void checkDreamTypeAchievements(Player player, String dreamType) {
        UUID uuid = player.getUniqueId();
        Set<String> dreamTypes = this.getStringSetProgress(uuid, "dream_types");
        dreamTypes.add(dreamType);
        this.setStringSetProgress(uuid, "dream_types", dreamTypes);
        this.checkAchievement(player, SleepAchievement.DREAM_COLLECTOR, dreamTypes.size());
    }

    private void checkAchievement(Player player, SleepAchievement achievement, int currentProgress) {
        UUID uuid = player.getUniqueId();
        String achievementName = achievement.name();
        Set earned = this.playerAchievements.getOrDefault(uuid, new HashSet());
        if (earned.contains(achievementName)) {
            return;
        }
        if (currentProgress >= achievement.getRequirement()) {
            this.awardAchievement(player, achievement);
        }
    }

    private void awardAchievement(Player player, SleepAchievement achievement) {
        UUID uuid = player.getUniqueId();
        Set earned = this.playerAchievements.getOrDefault(uuid, new HashSet());
        earned.add(achievement.name());
        this.playerAchievements.put(uuid, earned);
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("achievement-messages")) {
            MessageUtils.sendMessage((CommandSender)player, "");
            MessageUtils.sendMessage((CommandSender)player, this.plugin.getConfigManager().getMessage("decorations.achievement-border", new String[0]));
            MessageUtils.sendMessage((CommandSender)player, this.plugin.getConfigManager().getMessage("achievements.unlocked", new String[0]));
            MessageUtils.sendMessage((CommandSender)player, this.plugin.getConfigManager().getMessage("decorations.achievement-separator", new String[0]));
            MessageUtils.sendMessage((CommandSender)player, "&6\u2551 &f" + String.format("%-37s", achievement.getName()) + " &6\u2551");
            MessageUtils.sendMessage((CommandSender)player, "&6\u2551 &7" + String.format("%-37s", achievement.getDescription()) + " &6\u2551");
            MessageUtils.sendMessage((CommandSender)player, this.plugin.getConfigManager().getMessage("decorations.achievement-footer", new String[0]));
            MessageUtils.sendMessage((CommandSender)player, "");
        }
        this.giveAchievementReward(player, achievement.getReward());
        Location loc = player.getLocation().add(0.0, 2.0, 0.0);
        player.getWorld().spawnParticle(Particle.TOTEM, loc, 20, 1.0, 1.0, 1.0, 0.2);
        player.getWorld().spawnParticle(Particle.FIREWORKS_SPARK, loc, 15, 1.5, 1.5, 1.5, 0.1);
        player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.8f, 2.0f);
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("achievement-messages")) {
            String broadcastMessage = this.plugin.getConfigManager().getMessage("achievements.broadcast-unlock", "%player%", player.getName(), "%achievement%", achievement.getName());
            MessageUtils.broadcastToWorld(player.getWorld(), broadcastMessage);
        }
        if (earned.size() >= SleepAchievement.values().length - 1) {
            this.checkAchievement(player, SleepAchievement.SLEEP_SAGE, 1);
        }
        this.saveAchievements();
    }

    private void giveAchievementReward(Player player, String rewardString) {
        try {
            String[] parts = rewardString.split(":");
            Material material = Material.valueOf((String)parts[0]);
            int amount = Integer.parseInt(parts[1]);
            ItemStack reward = new ItemStack(material, amount);
            player.getInventory().addItem(new ItemStack[]{reward});
            MessageUtils.sendMessage((CommandSender)player, "&a+ " + amount + "x " + material.name().toLowerCase().replace("_", " ") + " &7(Achievement reward)");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid achievement reward format: " + rewardString);
        }
    }

    private int getProgress(UUID uuid, String progressType) {
        return ((Map)this.playerProgress.getOrDefault(uuid, new HashMap())).getOrDefault(progressType, 0);
    }

    private void incrementProgress(UUID uuid, String progressType) {
        Map progress = this.playerProgress.getOrDefault(uuid, new HashMap());
        progress.put(progressType, progress.getOrDefault(progressType, 0) + 1);
        this.playerProgress.put(uuid, progress);
    }

    private Set<String> getStringSetProgress(UUID uuid, String progressType) {
        String data = this.achievementConfig.getString(uuid.toString() + ".string_progress." + progressType, "");
        HashSet<String> result = new HashSet<String>();
        if (!data.isEmpty()) {
            result.addAll(Arrays.asList(data.split(",")));
        }
        return result;
    }

    private void setStringSetProgress(UUID uuid, String progressType, Set<String> data) {
        String dataString = String.join((CharSequence)",", data);
        this.achievementConfig.set(uuid.toString() + ".string_progress." + progressType, (Object)dataString);
    }

    public Set<String> getPlayerAchievements(Player player) {
        return this.playerAchievements.getOrDefault(player.getUniqueId(), new HashSet());
    }

    public int getAchievementCount(Player player) {
        return this.getPlayerAchievements(player).size();
    }

    public void showAchievements(Player player) {
        Set<String> earned = this.getPlayerAchievements(player);
        MessageUtils.sendMessage((CommandSender)player, "&6\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        MessageUtils.sendMessage((CommandSender)player, "&6\u2551 &e\ud83c\udfc6 &f&lYOUR SLEEP ACHIEVEMENTS &e\ud83c\udfc6 &6\u2551");
        MessageUtils.sendMessage((CommandSender)player, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage((CommandSender)player, "&6\u2551 &fProgress: &e" + earned.size() + "&7/&e" + SleepAchievement.values().length + " &funlocked &6\u2551");
        MessageUtils.sendMessage((CommandSender)player, "&6\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        for (SleepAchievement achievement : SleepAchievement.values()) {
            String status = earned.contains(achievement.name()) ? "&a\u2713" : "&c\u2717";
            String name = achievement.getName();
            MessageUtils.sendMessage((CommandSender)player, "&6\u2551 " + status + " &f" + String.format("%-35s", name) + " &6\u2551");
        }
        MessageUtils.sendMessage((CommandSender)player, "&6\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public void cleanup() {
        this.saveAchievements();
    }

    private static enum SleepAchievement {
        FIRST_DREAM("First Dream", "Sleep for the first time", 1, "GOLDEN_APPLE:1"),
        DREAM_WALKER("Dream Walker", "Sleep 10 times", 10, "DIAMOND:3"),
        NIGHT_GUARDIAN("Night Guardian", "Sleep 50 times", 50, "NETHERITE_INGOT:1"),
        SLEEP_MASTER("Sleep Master", "Sleep 100 times", 100, "BEACON:1"),
        DREAM_ARCHITECT("Dream Architect", "Sleep 500 times", 500, "NETHER_STAR:5"),
        STREAK_STARTER("Streak Starter", "Maintain 7-day sleep streak", 7, "EMERALD_BLOCK:2"),
        STREAK_CHAMPION("Streak Champion", "Maintain 30-day sleep streak", 30, "DIAMOND_BLOCK:5"),
        STREAK_LEGEND("Streak Legend", "Maintain 100-day sleep streak", 100, "ENCHANTED_GOLDEN_APPLE:10"),
        RITUAL_INITIATE("Ritual Initiate", "Participate in 5 sleep rituals", 5, "SOUL_TORCH:10"),
        RITUAL_MASTER("Ritual Master", "Participate in 25 sleep rituals", 25, "SOUL_LANTERN:5"),
        QUANTUM_EXPLORER("Quantum Explorer", "Experience 10 quantum entanglements", 10, "END_CRYSTAL:3"),
        DIMENSIONAL_TRAVELER("Dimensional Traveler", "Sleep in 3 different dimensions", 3, "ENDER_PEARL:16"),
        MOON_BLESSED("Moon Blessed", "Sleep during all 8 moon phases", 8, "GLOWSTONE:32"),
        LUNAR_CHAMPION("Lunar Champion", "Sleep during 10 full moons", 10, "BEACON:2"),
        DREAM_COLLECTOR("Dream Collector", "Experience all 6 dream types", 6, "TOTEM_OF_UNDYING:1"),
        SLEEP_SAGE("Sleep Sage", "Achieve all other sleep achievements", 1, "DRAGON_EGG:1");

        private final String name;
        private final String description;
        private final int requirement;
        private final String reward;

        private SleepAchievement(String name, String description, int requirement, String reward) {
            this.name = name;
            this.description = description;
            this.requirement = requirement;
            this.reward = reward;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getRequirement() {
            return this.requirement;
        }

        public String getReward() {
            return this.reward;
        }
    }
}

