/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SleepEconomyManager {
    private final EasySleep plugin;
    private final Map<UUID, Long> dreamCoins;
    private final Map<UUID, Map<String, Integer>> sleepShopPurchases;
    private File economyFile;
    private FileConfiguration economyConfig;
    private final Map<String, SleepShopItem> sleepShop = new HashMap<String, SleepShopItem>(){
        {
            this.put("dream_boost", new SleepShopItem("Dream Boost", "2x sleep rewards for 1 hour", 50, "POTION:1"));
            this.put("lunar_blessing", new SleepShopItem("Lunar Blessing", "Permanent moon phase bonus", 200, "NETHER_STAR:1"));
            this.put("quantum_stabilizer", new SleepShopItem("Quantum Stabilizer", "Guaranteed quantum entanglement", 150, "END_CRYSTAL:1"));
            this.put("dream_catcher", new SleepShopItem("Dream Catcher", "Collect rare dream fragments", 100, "COBWEB:1"));
            this.put("sleep_multiplier", new SleepShopItem("Sleep Multiplier", "3x sleep effectiveness", 300, "BEACON:1"));
            this.put("dimensional_key", new SleepShopItem("Dimensional Key", "Access to exclusive dream realms", 500, "ENDER_EYE:1"));
            this.put("time_crystal", new SleepShopItem("Time Crystal", "Control time acceleration", 750, "DIAMOND_BLOCK:1"));
            this.put("dream_crown", new SleepShopItem("Dream Crown", "Ultimate sleep mastery item", 1000, "NETHERITE_HELMET:1"));
        }
    };

    public SleepEconomyManager(EasySleep plugin) {
        this.plugin = plugin;
        this.dreamCoins = new HashMap<UUID, Long>();
        this.sleepShopPurchases = new HashMap<UUID, Map<String, Integer>>();
        this.setupEconomyFile();
        this.loadEconomyData();
    }

    private void setupEconomyFile() {
        this.economyFile = new File(this.plugin.getDataFolder(), "sleep_economy.yml");
        if (!this.economyFile.exists()) {
            try {
                this.economyFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not create sleep economy file: " + e.getMessage());
            }
        }
        this.economyConfig = YamlConfiguration.loadConfiguration((File)this.economyFile);
    }

    private void loadEconomyData() {
        for (String uuidString : this.economyConfig.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                long coins = this.economyConfig.getLong(uuidString + ".dream_coins", 0L);
                this.dreamCoins.put(uuid, coins);
                HashMap<String, Integer> purchases = new HashMap<String, Integer>();
                if (this.economyConfig.contains(uuidString + ".purchases")) {
                    for (String item : this.economyConfig.getConfigurationSection(uuidString + ".purchases").getKeys(false)) {
                        purchases.put(item, this.economyConfig.getInt(uuidString + ".purchases." + item));
                    }
                }
                this.sleepShopPurchases.put(uuid, purchases);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in economy file: " + uuidString);
            }
        }
    }

    private void saveEconomyData() {
        for (Map.Entry<UUID, Long> entry : this.dreamCoins.entrySet()) {
            String uuidString = entry.getKey().toString();
            this.economyConfig.set(uuidString + ".dream_coins", (Object)entry.getValue());
            Map<String, Integer> purchases = this.sleepShopPurchases.get(entry.getKey());
            if (purchases == null) continue;
            for (Map.Entry<String, Integer> purchase : purchases.entrySet()) {
                this.economyConfig.set(uuidString + ".purchases." + purchase.getKey(), (Object)purchase.getValue());
            }
        }
        try {
            this.economyConfig.save(this.economyFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save sleep economy: " + e.getMessage());
        }
    }

    public void awardDreamCoins(Player player, int baseAmount) {
        if (!player.hasPermission("easysleep.balance")) {
            return;
        }
        UUID uuid = player.getUniqueId();
        int streak = this.plugin.getRewardsManager().getPlayerStreak(player);
        double multiplier = 1.0 + (double)streak * 0.1;
        int finalAmount = (int)((double)baseAmount * multiplier);
        long currentCoins = this.dreamCoins.getOrDefault(uuid, 0L);
        this.dreamCoins.put(uuid, currentCoins + (long)finalAmount);
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("economy-messages")) {
            String message = this.plugin.getConfigManager().getMessage("economy.coins-received", "%amount%", String.valueOf(finalAmount));
            MessageUtils.sendMessage((CommandSender)player, message);
        }
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, loc, finalAmount, 0.5, 0.5, 0.5, 0.1);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 2.0f);
        this.saveEconomyData();
    }

    public long getDreamCoins(Player player) {
        return this.dreamCoins.getOrDefault(player.getUniqueId(), 0L);
    }

    public void showSleepShop(Player player) {
        long playerCoins = this.getDreamCoins(player);
        MessageUtils.sendMessage((CommandSender)player, "&d\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        MessageUtils.sendMessage((CommandSender)player, "&d\u2551 &e\ud83d\udc8e &f&lDREAM COIN SHOP &e\ud83d\udc8e &d\u2551");
        MessageUtils.sendMessage((CommandSender)player, "&d\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage((CommandSender)player, "&d\u2551 &fYour Balance: &e" + playerCoins + " &dDream Coins &d\u2551");
        MessageUtils.sendMessage((CommandSender)player, "&d\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        for (Map.Entry<String, SleepShopItem> entry : this.sleepShop.entrySet()) {
            SleepShopItem item = entry.getValue();
            String affordability = playerCoins >= (long)item.price ? "&a" : "&c";
            MessageUtils.sendMessage((CommandSender)player, "&d\u2551 " + affordability + item.name + " &7- &e" + item.price + " &dcoins &d\u2551");
            MessageUtils.sendMessage((CommandSender)player, "&d\u2551 &7  " + String.format("%-35s", item.description) + " &d\u2551");
        }
        MessageUtils.sendMessage((CommandSender)player, "&d\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563");
        MessageUtils.sendMessage((CommandSender)player, "&d\u2551 &7Use: &e/sleep shop buy <item> &d\u2551");
        MessageUtils.sendMessage((CommandSender)player, "&d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public boolean purchaseShopItem(Player player, String itemId) {
        SleepShopItem item = this.sleepShop.get(itemId.toLowerCase());
        if (item == null) {
            MessageUtils.sendMessage((CommandSender)player, "&cItem not found: " + itemId);
            return false;
        }
        UUID uuid = player.getUniqueId();
        long playerCoins = this.getDreamCoins(player);
        if (playerCoins < (long)item.price) {
            MessageUtils.sendMessage((CommandSender)player, "&cInsufficient Dream Coins! Need: &e" + item.price + " &cHave: &e" + playerCoins);
            return false;
        }
        this.dreamCoins.put(uuid, playerCoins - (long)item.price);
        this.giveShopItemReward(player, itemId);
        Map purchases = this.sleepShopPurchases.getOrDefault(uuid, new HashMap());
        purchases.put(itemId, purchases.getOrDefault(itemId, 0) + 1);
        this.sleepShopPurchases.put(uuid, purchases);
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("economy-messages")) {
            String purchaseMessage = this.plugin.getConfigManager().getMessage("economy.purchase-success", "%item%", item.name, "%price%", String.valueOf(item.price));
            String balanceMessage = this.plugin.getConfigManager().getMessage("economy.remaining-balance", "%balance%", String.valueOf(this.getDreamCoins(player)));
            MessageUtils.sendMessage((CommandSender)player, purchaseMessage);
            MessageUtils.sendMessage((CommandSender)player, balanceMessage);
        }
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        player.getWorld().spawnParticle(Particle.TOTEM, loc, 10, 0.5, 0.5, 0.5, 0.1);
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 0.8f, 1.5f);
        this.saveEconomyData();
        return true;
    }

    private void giveShopItemReward(Player player, String itemId) {
        switch (itemId.toLowerCase()) {
            case "food_bundle": {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BREAD, 16), new ItemStack(Material.COOKED_BEEF, 8), new ItemStack(Material.GOLDEN_CARROT, 4)});
                break;
            }
            case "tool_kit": {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_PICKAXE, 1), new ItemStack(Material.IRON_AXE, 1), new ItemStack(Material.IRON_SHOVEL, 1), new ItemStack(Material.IRON_SWORD, 1)});
                break;
            }
            case "armor_set": {
                ItemStack helmet = new ItemStack(Material.IRON_HELMET);
                ItemStack chestplate = new ItemStack(Material.IRON_CHESTPLATE);
                ItemStack leggings = new ItemStack(Material.IRON_LEGGINGS);
                ItemStack boots = new ItemStack(Material.IRON_BOOTS);
                helmet.addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
                chestplate.addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
                leggings.addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
                boots.addUnsafeEnchantment(Enchantment.PROTECTION_ENVIRONMENTAL, 1);
                helmet.addUnsafeEnchantment(Enchantment.DURABILITY, 2);
                chestplate.addUnsafeEnchantment(Enchantment.DURABILITY, 2);
                leggings.addUnsafeEnchantment(Enchantment.DURABILITY, 2);
                boots.addUnsafeEnchantment(Enchantment.DURABILITY, 2);
                player.getInventory().addItem(new ItemStack[]{helmet, chestplate, leggings, boots});
                break;
            }
            case "building_blocks": {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.STONE_BRICKS, 64), new ItemStack(Material.OAK_PLANKS, 32), new ItemStack(Material.GLASS, 16), new ItemStack(Material.TORCH, 8)});
                break;
            }
            case "potion_bundle": {
                ItemStack healingPotion = new ItemStack(Material.POTION, 3);
                PotionMeta healingMeta = (PotionMeta)healingPotion.getItemMeta();
                healingMeta.addCustomEffect(new PotionEffect(PotionEffectType.HEAL, 1, 1), true);
                healingPotion.setItemMeta((ItemMeta)healingMeta);
                ItemStack speedPotion = new ItemStack(Material.POTION, 2);
                PotionMeta speedMeta = (PotionMeta)speedPotion.getItemMeta();
                speedMeta.addCustomEffect(new PotionEffect(PotionEffectType.SPEED, 3600, 0), true);
                speedPotion.setItemMeta((ItemMeta)speedMeta);
                player.getInventory().addItem(new ItemStack[]{healingPotion, speedPotion});
                break;
            }
            case "dream_boost": {
                ItemStack dreamBoost = new ItemStack(Material.POTION, 1);
                PotionMeta dreamMeta = (PotionMeta)dreamBoost.getItemMeta();
                dreamMeta.setDisplayName("\u00a7d\u00a7lDream Boost Potion");
                dreamBoost.setItemMeta((ItemMeta)dreamMeta);
                player.getInventory().addItem(new ItemStack[]{dreamBoost});
                player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 1200, 1));
                break;
            }
            case "lunar_blessing": {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.NETHER_STAR, 1)});
                player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 12000, 0));
                break;
            }
            case "quantum_stabilizer": {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.END_CRYSTAL, 1)});
                player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 6000, 1));
                break;
            }
            case "time_crystal": {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND_BLOCK, 1)});
                player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 12000, 1));
                break;
            }
            default: {
                try {
                    SleepShopItem item = this.sleepShop.get(itemId);
                    if (item == null) break;
                    String[] parts = item.reward.split(":");
                    Material material = Material.valueOf((String)parts[0]);
                    int amount = Integer.parseInt(parts[1]);
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(material, amount)});
                    break;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Invalid shop item: " + itemId);
                }
            }
        }
    }

    public Set<String> getShopItems() {
        return this.sleepShop.keySet();
    }

    public void cleanup() {
        this.saveEconomyData();
    }

    private static class SleepShopItem {
        final String name;
        final String description;
        final int price;
        final String reward;

        SleepShopItem(String name, String description, int price, String reward) {
            this.name = name;
            this.description = description;
            this.price = price;
            this.reward = reward;
        }
    }
}

