/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SleepShopGUI
implements Listener {
    private final EasySleep plugin;
    private final Map<UUID, Inventory> openShops;
    private final Map<String, ShopItem> shopItems = new HashMap<String, ShopItem>(){
        {
            this.put("dream_boost", new ShopItem("Dream Boost", Material.POTION, 50, Arrays.asList("\u00a77Double your sleep rewards", "\u00a77for the next hour!", "", "\u00a7e\u00a7lPrice: 50 Dream Coins")));
            this.put("lunar_blessing", new ShopItem("Lunar Blessing", Material.NETHER_STAR, 200, Arrays.asList("\u00a77Permanent moon phase bonus", "\u00a77for all future sleeps!", "", "\u00a7e\u00a7lPrice: 200 Dream Coins")));
            this.put("quantum_stabilizer", new ShopItem("Quantum Stabilizer", Material.END_CRYSTAL, 150, Arrays.asList("\u00a77Guaranteed quantum entanglement", "\u00a77in your next sleep!", "", "\u00a7e\u00a7lPrice: 150 Dream Coins")));
            this.put("dream_catcher", new ShopItem("Dream Catcher", Material.COBWEB, 100, Arrays.asList("\u00a77Collect rare dream fragments", "\u00a77while you sleep!", "", "\u00a7e\u00a7lPrice: 100 Dream Coins")));
            this.put("sleep_multiplier", new ShopItem("Sleep Multiplier", Material.BEACON, 300, Arrays.asList("\u00a77Triple your sleep effectiveness", "\u00a77for maximum benefits!", "", "\u00a7e\u00a7lPrice: 300 Dream Coins")));
            this.put("dimensional_key", new ShopItem("Dimensional Key", Material.ENDER_EYE, 500, Arrays.asList("\u00a77Access exclusive dream realms", "\u00a77and hidden dimensions!", "", "\u00a7e\u00a7lPrice: 500 Dream Coins")));
            this.put("time_crystal", new ShopItem("Time Crystal", Material.DIAMOND_BLOCK, 750, Arrays.asList("\u00a77Control time acceleration", "\u00a77during sleep events!", "", "\u00a7e\u00a7lPrice: 750 Dream Coins")));
            this.put("dream_crown", new ShopItem("Dream Crown", Material.NETHERITE_HELMET, 1000, Arrays.asList("\u00a77Ultimate sleep mastery item", "\u00a77for true dream masters!", "", "\u00a7e\u00a7lPrice: 1000 Dream Coins")));
        }
    };

    public SleepShopGUI(EasySleep plugin) {
        this.plugin = plugin;
        this.openShops = new HashMap<UUID, Inventory>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openShop(Player player) {
        if (!player.hasPermission("easysleep.shop")) {
            MessageUtils.sendMessage((CommandSender)player, "&cYou don't have permission to access the shop!");
            return;
        }
        long playerCoins = this.plugin.getSleepEconomyManager().getDreamCoins(player);
        Inventory shop = Bukkit.createInventory(null, (int)54, (String)"\u00a7d\u00a7l\ud83d\udc8e Dream Coin Shop \ud83d\udc8e");
        ItemStack balanceItem = this.createBalanceItem(playerCoins);
        shop.setItem(4, balanceItem);
        int[] shopSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25};
        int slotIndex = 0;
        for (Map.Entry<String, ShopItem> entry : this.shopItems.entrySet()) {
            if (slotIndex >= shopSlots.length) break;
            ShopItem item = entry.getValue();
            ItemStack shopItemStack = this.createShopItem(item, playerCoins >= (long)item.price, entry.getKey());
            shop.setItem(shopSlots[slotIndex], shopItemStack);
            ++slotIndex;
        }
        this.addDecorativeItems(shop);
        ItemStack closeItem = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = closeItem.getItemMeta();
        closeMeta.setDisplayName("\u00a7c\u00a7lClose Shop");
        closeMeta.setLore(Arrays.asList("\u00a77Click to close the shop"));
        closeItem.setItemMeta(closeMeta);
        shop.setItem(49, closeItem);
        player.openInventory(shop);
        this.openShops.put(player.getUniqueId(), shop);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.5f, 1.2f);
    }

    private ItemStack createBalanceItem(long balance) {
        ItemStack balanceItem = new ItemStack(Material.EMERALD);
        ItemMeta balanceMeta = balanceItem.getItemMeta();
        balanceMeta.setDisplayName("\u00a7a\u00a7lYour Balance");
        balanceMeta.setLore(Arrays.asList("\u00a77Current Dream Coins:", "\u00a7e\u00a7l" + balance + " \u00a7d\u00a7lDream Coins", "", "\u00a77Earn more by sleeping!"));
        balanceItem.setItemMeta(balanceMeta);
        return balanceItem;
    }

    private ItemStack createShopItem(ShopItem item, boolean canAfford, String itemId) {
        ItemStack shopItem = new ItemStack(item.material);
        ItemMeta meta = shopItem.getItemMeta();
        String nameColor = canAfford ? "\u00a7a\u00a7l" : "\u00a7c\u00a7l";
        meta.setDisplayName(nameColor + item.name);
        ArrayList<String> lore = new ArrayList<String>(item.description);
        lore.add("");
        if (canAfford) {
            lore.add("\u00a7a\u00a7l\u2713 You can afford this!");
            lore.add("\u00a77Click to purchase");
        } else {
            lore.add("\u00a7c\u00a7l\u2717 Not enough Dream Coins");
            lore.add("\u00a77Sleep more to earn coins!");
        }
        meta.setLore(lore);
        shopItem.setItemMeta(meta);
        return shopItem;
    }

    private void addDecorativeItems(Inventory shop) {
        int[] glassSlots;
        ItemStack glass = new ItemStack(Material.PURPLE_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        glassMeta.setDisplayName("\u00a7d\u00a7l\u2726");
        glass.setItemMeta(glassMeta);
        for (int slot : glassSlots = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 50, 51, 52, 53}) {
            shop.setItem(slot, glass);
        }
        ItemStack star = new ItemStack(Material.NETHER_STAR);
        ItemMeta starMeta = star.getItemMeta();
        starMeta.setDisplayName("\u00a7e\u00a7l\u2726 Dream Shop \u2726");
        starMeta.setLore(Arrays.asList("\u00a77Welcome to the mystical", "\u00a77Dream Coin marketplace!"));
        star.setItemMeta(starMeta);
        shop.setItem(13, star);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.openShops.containsKey(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.BARRIER) {
            player.closeInventory();
            return;
        }
        String itemId = this.getItemIdFromSlot(event.getSlot());
        if (itemId != null) {
            this.handlePurchase(player, itemId);
        }
    }

    private String getItemIdFromSlot(int slot) {
        int[] shopSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25};
        String[] itemIds = new String[]{"food_bundle", "tool_kit", "armor_set", "building_blocks", "potion_bundle", "dream_boost", "lunar_blessing", "quantum_stabilizer", "time_crystal"};
        for (int i = 0; i < shopSlots.length && i < itemIds.length; ++i) {
            if (shopSlots[i] != slot) continue;
            return itemIds[i];
        }
        return null;
    }

    private void handlePurchase(Player player, String itemId) {
        ShopItem item = this.shopItems.get(itemId);
        if (item == null) {
            return;
        }
        long playerCoins = this.plugin.getSleepEconomyManager().getDreamCoins(player);
        if (playerCoins < (long)item.price) {
            MessageUtils.sendMessage((CommandSender)player, "\u00a7c\u00a7l\u2717 Insufficient Dream Coins!");
            MessageUtils.sendMessage((CommandSender)player, "\u00a7cNeed: \u00a7e" + item.price + " \u00a7cHave: \u00a7e" + playerCoins);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
            return;
        }
        boolean success = this.plugin.getSleepEconomyManager().purchaseShopItem(player, itemId);
        if (success) {
            MessageUtils.sendMessage((CommandSender)player, "\u00a7a\u00a7l\u2713 Purchase Successful!");
            MessageUtils.sendMessage((CommandSender)player, "\u00a7aYou bought: \u00a7e" + item.name);
            MessageUtils.sendMessage((CommandSender)player, "\u00a7aRemaining balance: \u00a7e" + (playerCoins - (long)item.price) + " \u00a7dDream Coins");
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.8f, 1.5f);
            player.getWorld().spawnParticle(Particle.TOTEM, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.1);
            player.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.openShop(player), 5L);
        } else {
            MessageUtils.sendMessage((CommandSender)player, "\u00a7c\u00a7l\u2717 Purchase failed! Please try again.");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.5f, 1.0f);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            this.openShops.remove(player.getUniqueId());
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.3f, 1.0f);
        }
    }

    public void cleanup() {
        this.openShops.clear();
    }

    private static class ShopItem {
        final String name;
        final Material material;
        final int price;
        final List<String> description;

        ShopItem(String name, Material material, int price, List<String> description) {
            this.name = name;
            this.material = material;
            this.price = price;
            this.description = description;
        }
    }
}

