/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StatisticsManager {
    private final EasySleep plugin;
    private File statsFile;
    private FileConfiguration statsConfig;
    private long totalSleepEvents = 0L;
    private long totalNightSkips = 0L;
    private long totalDaysTracked = 0L;
    private long totalPlayersServed = 0L;

    public StatisticsManager(EasySleep plugin) {
        this.plugin = plugin;
        this.setupStatsFile();
        this.loadStatistics();
    }

    private void setupStatsFile() {
        this.statsFile = new File(this.plugin.getDataFolder(), "statistics.yml");
        if (!this.statsFile.exists()) {
            try {
                this.statsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not create statistics file: " + e.getMessage());
            }
        }
        this.statsConfig = YamlConfiguration.loadConfiguration((File)this.statsFile);
    }

    private void loadStatistics() {
        this.totalSleepEvents = this.statsConfig.getLong("total-sleep-events", 0L);
        this.totalNightSkips = this.statsConfig.getLong("total-night-skips", 0L);
        this.totalDaysTracked = this.statsConfig.getLong("total-days-tracked", 0L);
        this.totalPlayersServed = this.statsConfig.getLong("total-players-served", 0L);
    }

    private void saveStatistics() {
        this.statsConfig.set("total-sleep-events", (Object)this.totalSleepEvents);
        this.statsConfig.set("total-night-skips", (Object)this.totalNightSkips);
        this.statsConfig.set("total-days-tracked", (Object)this.totalDaysTracked);
        this.statsConfig.set("total-players-served", (Object)this.totalPlayersServed);
        this.statsConfig.set("last-updated", (Object)System.currentTimeMillis());
        try {
            this.statsConfig.save(this.statsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save statistics: " + e.getMessage());
        }
    }

    public void recordSleepEvent() {
        ++this.totalSleepEvents;
        this.saveStatistics();
    }

    public void recordNightSkip() {
        ++this.totalNightSkips;
        this.saveStatistics();
    }

    public void recordNewDay() {
        ++this.totalDaysTracked;
        this.saveStatistics();
    }

    public void updatePlayerCount(int currentPlayers) {
        if ((long)currentPlayers > this.totalPlayersServed) {
            this.totalPlayersServed = currentPlayers;
            this.saveStatistics();
        }
    }

    public long getTotalSleepEvents() {
        return this.totalSleepEvents;
    }

    public long getTotalNightSkips() {
        return this.totalNightSkips;
    }

    public long getTotalDaysTracked() {
        return this.totalDaysTracked;
    }

    public long getTotalPlayersServed() {
        return this.totalPlayersServed;
    }

    public String getFormattedStats() {
        return String.format("Sleep Events: %d | Night Skips: %d | Days Tracked: %d | Players Served: %d", this.totalSleepEvents, this.totalNightSkips, this.totalDaysTracked, this.totalPlayersServed);
    }
}

