/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.utils;

import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtils {
    public static void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(MessageUtils.colorize(message));
    }

    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void sendMessages(CommandSender sender, String ... messages) {
        for (String message : messages) {
            MessageUtils.sendMessage(sender, message);
        }
    }

    public static String getPrefix() {
        return MessageUtils.colorize("&8[&6EasySleep&8] &r");
    }

    public static void sendPrefixedMessage(CommandSender sender, String message) {
        MessageUtils.sendMessage(sender, MessageUtils.getPrefix() + message);
    }

    public static void broadcastToWorld(World world, String message) {
        for (Player player : world.getPlayers()) {
            MessageUtils.sendMessage((CommandSender)player, message);
        }
    }
}

