/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.listeners;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.managers.AnimationManager;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.List;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepEventListener
implements Listener {
    private final EasySleep plugin;
    private final AnimationManager animationManager;

    public SleepEventListener(EasySleep plugin) {
        this.plugin = plugin;
        this.animationManager = plugin.getAnimationManager();
    }

    @EventHandler
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.getBedEnterResult() != PlayerBedEnterEvent.BedEnterResult.OK) {
            return;
        }
        final Player player = event.getPlayer();
        World world = player.getWorld();
        this.plugin.getStatisticsManager().recordSleepEvent();
        this.plugin.getRewardsManager().giveSleepRewards(player);
        if (!this.plugin.getAntiSpamManager().canSendSleepMessage(player)) {
            return;
        }
        this.startTimeAcceleration(world);
        if (this.plugin.getConfigManager().areAnimationsEnabled()) {
            new BukkitRunnable(){

                public void run() {
                    if (player.isOnline() && player.isSleeping()) {
                        SleepEventListener.this.animationManager.startSleepAnimation(player);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 5L);
        }
        int totalPlayers = world.getPlayers().size();
        int sleepingPlayers = this.getSleepingPlayerCount(world);
        int activePlayers = this.getActivePlayerCount(world);
        Integer sleepPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
        int requiredPlayers = (int)Math.ceil((double)((sleepPercentage != null ? sleepPercentage : 50) * activePlayers) / 100.0);
        if (this.plugin.getConfigManager().getConfig().getBoolean("sleep.broadcast-sleep-messages", true)) {
            String sleepMessage = this.plugin.getConfigManager().getConfig().getString("messages.sleep.player-sleeping", "&7\ud83c\udf19 &e%player% &7enters dream state &8(&a%sleeping%&7/&e%required%&8)");
            sleepMessage = sleepMessage.replace("%player%", player.getName()).replace("%sleeping%", String.valueOf(sleepingPlayers)).replace("%required%", String.valueOf(requiredPlayers));
            for (Player p : world.getPlayers()) {
                if (p.equals((Object)player)) continue;
                MessageUtils.sendMessage((CommandSender)p, sleepMessage);
            }
        }
    }

    private void startTimeAcceleration(final World world) {
        final double acceleration = this.plugin.getConfigManager().getConfig().getDouble("sleep.time-acceleration", 1.75);
        if (acceleration > 1.0) {
            new BukkitRunnable(){

                public void run() {
                    if (SleepEventListener.this.getSleepingPlayerCount(world) == 0) {
                        this.cancel();
                        return;
                    }
                    long currentTime = world.getTime();
                    long newTime = currentTime + (long)(20.0 * (acceleration - 1.0));
                    world.setTime(newTime);
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
            String accelMessage = this.plugin.getConfigManager().getConfig().getString("messages.sleep.time-acceleration", "&b\u26a1 &fTime flowing faster... &7(&e%speed%x speed&7)");
            MessageUtils.broadcastToWorld(world, accelMessage.replace("%speed%", String.format("%.1f", acceleration)));
        }
    }

    private int getSleepingPlayerCount(World world) {
        int count = 0;
        for (Player player : world.getPlayers()) {
            if (!player.isSleeping() || this.plugin.getAFKManager().isPlayerAFK(player)) continue;
            ++count;
        }
        return count;
    }

    private int getActivePlayerCount(World world) {
        int count = 0;
        for (Player player : world.getPlayers()) {
            if (this.plugin.getAFKManager().isPlayerAFK(player)) continue;
            ++count;
        }
        return count;
    }

    @EventHandler
    public void onPlayerBedLeave(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!this.plugin.getAntiSpamManager().canSendWakeMessage(player)) {
            return;
        }
        this.animationManager.stopAnimation(player);
        int totalPlayers = world.getPlayers().size();
        int sleepingPlayers = this.getSleepingPlayerCount(world);
        if (this.plugin.getConfigManager().getConfig().getBoolean("sleep.broadcast-sleep-messages", true)) {
            String wakeMessage = this.plugin.getConfigManager().getConfig().getString("messages.sleep.player-waking", "&7\u2600 &e%player% &7wakes up &8(&a%sleeping%&7/&e%total%&8)");
            wakeMessage = wakeMessage.replace("%player%", player.getName()).replace("%sleeping%", String.valueOf(sleepingPlayers)).replace("%total%", String.valueOf(totalPlayers));
            MessageUtils.broadcastToWorld(world, wakeMessage);
        }
    }

    @EventHandler
    public void onTimeSkip(TimeSkipEvent event) {
        if (event.getSkipReason() == TimeSkipEvent.SkipReason.NIGHT_SKIP) {
            World world = event.getWorld();
            this.plugin.getStatisticsManager().recordNightSkip();
            this.giveMorningEffects(world);
            if (this.plugin.getConfigManager().areAnimationsEnabled()) {
                this.plugin.getAnimationManager().startNightSkipAnimation(world);
            }
            double acceleration = this.plugin.getConfigManager().getConfig().getDouble("sleep.time-acceleration", 1.75);
            String skipMessage = this.plugin.getConfigManager().getConfig().getString("messages.sleep.night-skip", "&a\u2713 &fNight skipped! &7Time acceleration: &e%speed%x");
            MessageUtils.broadcastToWorld(world, skipMessage.replace("%speed%", String.format("%.1f", acceleration)));
        }
    }

    private void giveMorningEffects(World world) {
        if (!this.plugin.getConfigManager().getConfig().getBoolean("rewards.effects.enabled", true)) {
            return;
        }
        List morningEffects = this.plugin.getConfigManager().getConfig().getStringList("rewards.effects.morning-effects");
        for (Player player : world.getPlayers()) {
            for (String effectString : morningEffects) {
                PotionEffect effect = this.parseEffectString(effectString);
                if (effect == null) continue;
                player.addPotionEffect(effect);
            }
        }
    }

    private PotionEffect parseEffectString(String effectString) {
        try {
            int amplifier;
            String[] parts = effectString.split(":");
            PotionEffectType effectType = PotionEffectType.getByName((String)parts[0].toUpperCase());
            int duration = parts.length > 1 ? Integer.parseInt(parts[1]) * 20 : 600;
            int n = amplifier = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
            if (effectType != null) {
                return new PotionEffect(effectType, duration, amplifier);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Invalid effect format: " + effectString);
        }
        return null;
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        World world = event.getWorld();
        if (this.plugin.getConfigManager().getConfig().getBoolean("sleep.auto-configure-new-worlds", true)) {
            Integer currentPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
            int defaultPercentage = this.plugin.getConfigManager().getConfig().getInt("sleep.default-percentage", 50);
            if (currentPercentage == null || currentPercentage != defaultPercentage) {
                world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)defaultPercentage);
                this.plugin.getLogger().info("Auto-configured world '" + world.getName() + "' with " + defaultPercentage + "% sleep requirement");
            }
        }
    }
}

