/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DayCounterManager {
    private final EasySleep plugin;
    private final Map<String, Long> worldDays;
    private final Map<String, Long> lastTimeCheck;
    private File dataFile;
    private FileConfiguration dataConfig;

    public DayCounterManager(EasySleep plugin) {
        this.plugin = plugin;
        this.worldDays = new HashMap<String, Long>();
        this.lastTimeCheck = new HashMap<String, Long>();
        this.setupDataFile();
        this.loadDayData();
        this.startDayTracker();
    }

    private void setupDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "daydata.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not create day data file: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void loadDayData() {
        for (World world : Bukkit.getWorlds()) {
            String worldName = world.getName();
            long days = this.dataConfig.getLong("worlds." + worldName + ".days", 1L);
            long lastTime = this.dataConfig.getLong("worlds." + worldName + ".lastTime", world.getTime());
            this.worldDays.put(worldName, days);
            this.lastTimeCheck.put(worldName, lastTime);
        }
    }

    private void saveDayData() {
        for (Map.Entry<String, Long> entry : this.worldDays.entrySet()) {
            String worldName = entry.getKey();
            long days = entry.getValue();
            long lastTime = this.lastTimeCheck.getOrDefault(worldName, 0L);
            this.dataConfig.set("worlds." + worldName + ".days", (Object)days);
            this.dataConfig.set("worlds." + worldName + ".lastTime", (Object)lastTime);
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save day data: " + e.getMessage());
        }
    }

    private void startDayTracker() {
        new BukkitRunnable(){

            public void run() {
                if (!DayCounterManager.this.plugin.getConfigManager().isDayCounterEnabled()) {
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    DayCounterManager.this.checkDayChange(world);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private void checkDayChange(World world) {
        long currentTime;
        String worldName = world.getName();
        long lastTime = this.lastTimeCheck.getOrDefault(worldName, currentTime = world.getTime());
        if (lastTime > 12000L && currentTime < 6000L) {
            long currentDay = this.worldDays.getOrDefault(worldName, 1L);
            long newDay = currentDay + 1L;
            this.worldDays.put(worldName, newDay);
            this.lastTimeCheck.put(worldName, currentTime);
            this.showDayTitle(world, newDay);
            this.saveDayData();
            if (this.plugin.getConfigManager().isDebugMode()) {
                this.plugin.getLogger().info("New day detected in " + worldName + ": Day " + newDay);
            }
        } else {
            this.lastTimeCheck.put(worldName, currentTime);
        }
    }

    private void showDayTitle(World world, long day) {
        List<String> messages = this.plugin.getConfigManager().getRandomMorningMessages();
        String message = "Day " + day + " - A new adventure begins!";
        if (!messages.isEmpty()) {
            Random random = new Random();
            message = messages.get(random.nextInt(messages.size()));
            message = message.replace("%day%", String.valueOf(day));
        }
        String title = "\u00a7fDay " + day;
        String subtitle = "\u00a77" + (message.contains(" - ") ? message.substring(message.indexOf(" - ") + 3) : "A new adventure begins!");
        for (Player player : world.getPlayers()) {
            player.sendTitle(title, subtitle, 10, 60, 20);
        }
        if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("Displayed day title for " + world.getName() + ": " + title);
        }
    }

    public long getCurrentDay(World world) {
        return this.worldDays.getOrDefault(world.getName(), 1L);
    }

    public void setDay(World world, long day) {
        this.worldDays.put(world.getName(), day);
        this.saveDayData();
    }

    public void resetDay(World world) {
        this.worldDays.put(world.getName(), 1L);
        this.lastTimeCheck.put(world.getName(), world.getTime());
        this.saveDayData();
    }

    public void cleanup() {
        this.saveDayData();
    }
}

