/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepRitualManager {
    private final EasySleep plugin;
    private final Map<String, SleepRitual> activeRituals;
    private final Random random;

    public SleepRitualManager(EasySleep plugin) {
        this.plugin = plugin;
        this.activeRituals = new HashMap<String, SleepRitual>();
        this.random = new Random();
    }

    public void checkSleepRitual(World world) {
        if (!this.plugin.getConfigManager().areAnimationsEnabled()) {
            return;
        }
        ArrayList<Player> sleepingPlayers = new ArrayList<Player>();
        for (Player player : world.getPlayers()) {
            if (!player.isSleeping()) continue;
            sleepingPlayers.add(player);
        }
        String worldName = world.getName();
        if (sleepingPlayers.size() >= 2 && !this.activeRituals.containsKey(worldName)) {
            RitualType ritualType = this.determineRitualType(sleepingPlayers.size());
            this.startSleepRitual(world, sleepingPlayers, ritualType);
        } else if (sleepingPlayers.size() < 2 && this.activeRituals.containsKey(worldName)) {
            this.endSleepRitual(world);
        }
    }

    private RitualType determineRitualType(int playerCount) {
        if (playerCount >= 6) {
            return RitualType.COSMIC_ALIGNMENT;
        }
        if (playerCount >= 5) {
            return RitualType.SOUL_BINDING;
        }
        if (playerCount >= 4) {
            return RitualType.TEMPORAL_SYNC;
        }
        if (playerCount >= 3) {
            return RitualType.ASTRAL_PROJECTION;
        }
        if (playerCount >= 2) {
            return RitualType.DREAM_CONVERGENCE;
        }
        return RitualType.HARMONY_CIRCLE;
    }

    private void startSleepRitual(World world, List<Player> participants, RitualType ritualType) {
        String worldName = world.getName();
        SleepRitual ritual = new SleepRitual(ritualType, participants, System.currentTimeMillis());
        this.activeRituals.put(worldName, ritual);
        Location center = this.calculateRitualCenter(participants);
        MessageUtils.broadcastToWorld(world, "");
        MessageUtils.broadcastToWorld(world, "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        MessageUtils.broadcastToWorld(world, "&5\ud83d\udd2e &f&lSLEEP RITUAL &5&lACTIVATED &5\ud83d\udd2e");
        MessageUtils.broadcastToWorld(world, "&7\u2728 &fRitual Type: &d" + this.getRitualName(ritualType));
        MessageUtils.broadcastToWorld(world, "&7\ud83d\udc65 &fParticipants: &e" + participants.size() + " &7dreamers");
        MessageUtils.broadcastToWorld(world, "&7\ud83c\udf1f &fCollective dream energy &bconverging&f...");
        MessageUtils.broadcastToWorld(world, "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
        MessageUtils.broadcastToWorld(world, "");
        this.startRitualSequence(world, ritual, center);
        for (Player participant : participants) {
            this.startParticipantEffects(participant, ritualType);
        }
        world.playSound(center, Sound.BLOCK_BEACON_ACTIVATE, 0.5f, 1.5f);
    }

    private Location calculateRitualCenter(List<Player> participants) {
        double totalX = 0.0;
        double totalY = 0.0;
        double totalZ = 0.0;
        for (Player player : participants) {
            Location loc = player.getLocation();
            totalX += loc.getX();
            totalY += loc.getY();
            totalZ += loc.getZ();
        }
        return new Location(participants.get(0).getWorld(), totalX / (double)participants.size(), totalY / (double)participants.size() + 3.0, totalZ / (double)participants.size());
    }

    private void startRitualSequence(final World world, final SleepRitual ritual, final Location center) {
        new BukkitRunnable(){
            int ticks = 0;
            int phase = 0;

            public void run() {
                if (!SleepRitualManager.this.activeRituals.containsKey(world.getName())) {
                    this.cancel();
                    return;
                }
                switch (this.phase) {
                    case 0: {
                        SleepRitualManager.this.createRitualFormation(world, ritual, center, this.ticks);
                        if (this.ticks < 80) break;
                        ++this.phase;
                        this.ticks = 0;
                        break;
                    }
                    case 1: {
                        SleepRitualManager.this.createEnergyConvergence(world, ritual, center, this.ticks);
                        if (this.ticks < 80) break;
                        ++this.phase;
                        this.ticks = 0;
                        break;
                    }
                    case 2: {
                        SleepRitualManager.this.createRitualClimax(world, ritual, center, this.ticks);
                        if (this.ticks < 80) break;
                        ++this.phase;
                        this.ticks = 0;
                        break;
                    }
                    case 3: {
                        SleepRitualManager.this.createSustainedRitual(world, ritual, center, this.ticks);
                    }
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createRitualFormation(World world, SleepRitual ritual, Location center, int ticks) {
        int participantCount = ritual.participants.size();
        block8: for (int i = 0; i < participantCount; ++i) {
            double angle = 360.0 / (double)participantCount * (double)i + (double)ticks * 0.5;
            double radius = 3.0 + Math.sin((double)ticks * 0.05) * 0.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.08 + (double)i) * 0.3;
            Location ritualLoc = center.clone().add(x, y, z);
            switch (ritual.ritualType.ordinal()) {
                case 0: {
                    world.spawnParticle(Particle.HEART, ritualLoc, 1, 0.1, 0.1, 0.1, 0.01);
                    continue block8;
                }
                case 1: {
                    world.spawnParticle(Particle.SOUL_FIRE_FLAME, ritualLoc, 1, 0.1, 0.1, 0.1, 0.01);
                    continue block8;
                }
                case 2: {
                    world.spawnParticle(Particle.END_ROD, ritualLoc, 1, 0.1, 0.1, 0.1, 0.02);
                    continue block8;
                }
                case 3: {
                    world.spawnParticle(Particle.PORTAL, ritualLoc, 2, 0.1, 0.1, 0.1, 0.03);
                    continue block8;
                }
                case 4: {
                    world.spawnParticle(Particle.SOUL, ritualLoc, 1, 0.1, 0.1, 0.1, 0.01);
                    continue block8;
                }
                case 5: {
                    world.spawnParticle(Particle.TOTEM, ritualLoc, 1, 0.1, 0.1, 0.1, 0.02);
                }
            }
        }
        if (ticks % 20 == 0) {
            world.spawnParticle(Particle.ENCHANTMENT_TABLE, center, 5, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private void createEnergyConvergence(World world, SleepRitual ritual, Location center, int ticks) {
        for (int i = 0; i < ritual.participants.size(); ++i) {
            Player participant = ritual.participants.get(i);
            if (!participant.isOnline() || !participant.isSleeping()) continue;
            Location playerLoc = participant.getLocation().add(0.0, 1.5, 0.0);
            for (int j = 0; j < 3; ++j) {
                double progress = (double)j / 3.0;
                Location streamLoc = playerLoc.clone().add((center.getX() - playerLoc.getX()) * progress, (center.getY() - playerLoc.getY()) * progress, (center.getZ() - playerLoc.getZ()) * progress);
                world.spawnParticle(Particle.ENCHANTMENT_TABLE, streamLoc, 1, 0.05, 0.05, 0.05, 0.02);
            }
        }
        if (ticks == 40) {
            MessageUtils.broadcastToWorld(world, "&7\ud83c\udf1f &fDream energies &bconverging&f... ritual power &dincreasing&f... &7\ud83c\udf1f");
        }
    }

    private void createRitualClimax(World world, SleepRitual ritual, Location center, int ticks) {
        if (ticks % 10 == 0) {
            for (int i = 0; i < 8; ++i) {
                double angle = i * 45 + ticks * 2;
                double radius = 2.0 + Math.sin((double)ticks * 0.1) * 0.8;
                double x = Math.cos(Math.toRadians(angle)) * radius;
                double z = Math.sin(Math.toRadians(angle)) * radius;
                double y = Math.sin((double)ticks * 0.15 + (double)i) * 1.0;
                Location climaxLoc = center.clone().add(x, y, z);
                world.spawnParticle(Particle.TOTEM, climaxLoc, 2, 0.2, 0.2, 0.2, 0.05);
            }
        }
        if (ticks == 40) {
            MessageUtils.broadcastToWorld(world, "&7\u26a1 &fRitual &dclimax &freached! &bCollective consciousness &factivated! &7\u26a1");
            world.playSound(center, Sound.ENTITY_ENDER_DRAGON_GROWL, 0.3f, 2.0f);
        }
    }

    private void createSustainedRitual(World world, SleepRitual ritual, Location center, int ticks) {
        if (ticks % 40 == 0) {
            world.spawnParticle(Particle.SOUL_FIRE_FLAME, center, 3, 1.0, 1.0, 1.0, 0.02);
            world.playSound(center, Sound.BLOCK_BEACON_AMBIENT, 0.1f, 1.8f);
        }
        if (ticks % 80 == 0) {
            for (Player participant : ritual.participants) {
                if (!participant.isOnline() || !participant.isSleeping()) continue;
                Location playerLoc = participant.getLocation().add(0.0, 1.5, 0.0);
                world.spawnParticle(Particle.END_ROD, playerLoc, 1, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    private void startParticipantEffects(final Player participant, final RitualType ritualType) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!participant.isOnline() || !participant.isSleeping()) {
                    this.cancel();
                    return;
                }
                Location loc = participant.getLocation().add(0.0, 1.2, 0.0);
                switch (ritualType.ordinal()) {
                    case 0: {
                        if (this.ticks % 30 != 0) break;
                        participant.getWorld().spawnParticle(Particle.HEART, loc, 1, 0.3, 0.3, 0.3, 0.01);
                        break;
                    }
                    case 1: {
                        if (this.ticks % 25 != 0) break;
                        participant.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 2, 0.2, 0.2, 0.2, 0.02);
                        break;
                    }
                    case 2: {
                        if (this.ticks % 20 != 0) break;
                        participant.getWorld().spawnParticle(Particle.END_ROD, loc, 1, 0.4, 0.4, 0.4, 0.03);
                        break;
                    }
                    case 3: {
                        if (this.ticks % 35 != 0) break;
                        participant.getWorld().spawnParticle(Particle.PORTAL, loc, 3, 0.3, 0.3, 0.3, 0.05);
                        break;
                    }
                    case 4: {
                        if (this.ticks % 40 != 0) break;
                        participant.getWorld().spawnParticle(Particle.SOUL, loc, 2, 0.2, 0.2, 0.2, 0.02);
                        break;
                    }
                    case 5: {
                        if (this.ticks % 15 != 0) break;
                        participant.getWorld().spawnParticle(Particle.TOTEM, loc, 1, 0.5, 0.5, 0.5, 0.04);
                    }
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 1L);
    }

    private void endSleepRitual(World world) {
        String worldName = world.getName();
        SleepRitual ritual = this.activeRituals.remove(worldName);
        if (ritual != null) {
            long duration = (System.currentTimeMillis() - ritual.startTime) / 1000L;
            MessageUtils.broadcastToWorld(world, "");
            MessageUtils.broadcastToWorld(world, "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            MessageUtils.broadcastToWorld(world, "&a\u2713 &f&lSLEEP RITUAL &a&lCOMPLETED &a\u2713");
            MessageUtils.broadcastToWorld(world, "&7\ud83c\udf1f &fRitual Type: &d" + this.getRitualName(ritual.ritualType));
            MessageUtils.broadcastToWorld(world, "&7\u23f1 &fDuration: &e" + duration + "s");
            MessageUtils.broadcastToWorld(world, "&7\ud83d\udcab &fCollective dream energy &adissipating&f...");
            MessageUtils.broadcastToWorld(world, "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            MessageUtils.broadcastToWorld(world, "");
            Location center = this.calculateRitualCenter(ritual.participants);
            world.spawnParticle(Particle.TOTEM, center, 10, 2.0, 2.0, 2.0, 0.2);
            world.playSound(center, Sound.UI_TOAST_CHALLENGE_COMPLETE, 0.5f, 1.5f);
        }
    }

    private String getRitualName(RitualType ritualType) {
        switch (ritualType.ordinal()) {
            case 0: {
                return "Harmony Circle Ritual";
            }
            case 1: {
                return "Dream Convergence Ceremony";
            }
            case 2: {
                return "Astral Projection Rite";
            }
            case 3: {
                return "Temporal Synchronization";
            }
            case 4: {
                return "Soul Binding Ritual";
            }
            case 5: {
                return "Cosmic Alignment Ceremony";
            }
        }
        return "Unknown Ritual";
    }

    public boolean hasActiveRitual(World world) {
        return this.activeRituals.containsKey(world.getName());
    }

    public int getActiveRitualCount() {
        return this.activeRituals.size();
    }

    public void cleanup() {
        this.activeRituals.clear();
    }

    private static class SleepRitual {
        final RitualType ritualType;
        final List<Player> participants;
        final long startTime;

        SleepRitual(RitualType ritualType, List<Player> participants, long startTime) {
            this.ritualType = ritualType;
            this.participants = new ArrayList<Player>(participants);
            this.startTime = startTime;
        }
    }

    private static enum RitualType {
        HARMONY_CIRCLE,
        DREAM_CONVERGENCE,
        ASTRAL_PROJECTION,
        TEMPORAL_SYNC,
        SOUL_BINDING,
        COSMIC_ALIGNMENT;

    }
}

