/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep;

import com.turjo.easysleep.commands.SleepCommand;
import com.turjo.easysleep.listeners.SleepEventListener;
import com.turjo.easysleep.managers.AnimationManager;
import com.turjo.easysleep.managers.ConfigManager;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EasySleep
extends JavaPlugin {
    private static EasySleep instance;
    private AnimationManager animationManager;
    private ConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.animationManager = new AnimationManager(this);
        this.initializeCommands();
        this.registerEventListeners();
        this.setDefaultSleepPercentage();
        this.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.getLogger().info("\u2551          \ud83c\udf19 EASYSLEEP ACTIVATED \ud83c\udf19        \u2551");
        this.getLogger().info("\u2551                                           \u2551");
        this.getLogger().info("\u2551 \u26a1 Sleep Protocol: INITIALIZED           \u2551");
        this.getLogger().info("\u2551 \ud83c\udf19 Night Skip System: ACTIVE             \u2551");
        this.getLogger().info("\u2551 \u2728 Animation Engine: LOADED              \u2551");
        this.getLogger().info("\u2551 \ud83d\udd27 Developer: Turjo                      \u2551");
        this.getLogger().info("\u2551 \ud83d\udce6 Version: " + this.getDescription().getVersion() + "                      \u2551");
        this.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public void onDisable() {
        this.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.getLogger().info("\u2551        \ud83c\udf19 EASYSLEEP DEACTIVATED \ud83c\udf19        \u2551");
        this.getLogger().info("\u2551                                           \u2551");
        this.getLogger().info("\u2551 \ud83c\udf19 EasySleep Protocol: TERMINATED        \u2551");
        this.getLogger().info("\u2551 \u26a1 All systems: OFFLINE                  \u2551");
        this.getLogger().info("\u2551 \ud83d\udcab Thanks for using EasySleep!           \u2551");
        this.getLogger().info("\u2551 \u2728 Animation threads: STOPPED            \u2551");
        this.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        if (this.animationManager != null) {
            this.animationManager.cleanup();
        }
        instance = null;
    }

    private void initializeCommands() {
        SleepCommand sleepCommand = new SleepCommand(this);
        this.getCommand("sleep").setExecutor((CommandExecutor)sleepCommand);
        this.getCommand("sleep").setTabCompleter((TabCompleter)sleepCommand);
    }

    private void registerEventListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new SleepEventListener(this), (Plugin)this);
    }

    private void setDefaultSleepPercentage() {
        for (World world : this.getServer().getWorlds()) {
            world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)1);
        }
    }

    public static EasySleep getInstance() {
        return instance;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

