/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final EasySleep plugin;
    private FileConfiguration config;

    public ConfigManager(EasySleep plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.config.addDefault("settings.default-sleep-percentage", (Object)1);
        this.config.addDefault("settings.enable-animations", (Object)true);
        this.config.addDefault("settings.enable-sound-effects", (Object)true);
        this.config.addDefault("settings.broadcast-sleep-messages", (Object)true);
        this.config.addDefault("settings.auto-configure-new-worlds", (Object)true);
        this.config.options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    public int getDefaultSleepPercentage() {
        return this.config.getInt("settings.default-sleep-percentage", 1);
    }

    public boolean areAnimationsEnabled() {
        return this.config.getBoolean("settings.enable-animations", true);
    }

    public boolean areSoundEffectsEnabled() {
        return this.config.getBoolean("settings.enable-sound-effects", true);
    }

    public boolean shouldBroadcastSleepMessages() {
        return this.config.getBoolean("settings.broadcast-sleep-messages", true);
    }

    public boolean shouldAutoConfigureNewWorlds() {
        return this.config.getBoolean("settings.auto-configure-new-worlds", true);
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }
}

