/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AnimationManager {
    private final EasySleep plugin;
    private final Map<Player, BukkitTask> activeAnimations;
    private final Random random;

    public AnimationManager(EasySleep plugin) {
        this.plugin = plugin;
        this.activeAnimations = new HashMap<Player, BukkitTask>();
        this.random = new Random();
    }

    public void startSleepAnimation(final Player player) {
        if (!this.plugin.getConfigManager().areAnimationsEnabled()) {
            return;
        }
        this.stopAnimation(player);
        BukkitTask task = new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!player.isOnline() || !player.isSleeping()) {
                    this.cancel();
                    return;
                }
                if (this.ticks % 40 == 0) {
                    AnimationManager.this.createModernSleepEffect(player);
                }
                if (this.ticks % 80 == 0) {
                    AnimationManager.this.playModernSleepSound(player);
                }
                ++this.ticks;
                if (this.ticks > 80) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.activeAnimations.put(player, task);
    }

    private void createModernSleepEffect(Player player) {
        Location loc = player.getLocation().add(0.0, 1.2, 0.0);
        double x = (this.random.nextDouble() - 0.5) * 0.3;
        double z = (this.random.nextDouble() - 0.5) * 0.3;
        Location particleLoc = loc.clone().add(x, 0.2, z);
        try {
            Particle sleepParticle = Particle.valueOf((String)this.plugin.getConfigManager().getSleepParticle());
            player.getWorld().spawnParticle(sleepParticle, particleLoc, 1, 0.02, 0.02, 0.02, 0.001);
        }
        catch (IllegalArgumentException e) {
            player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, particleLoc, 1, 0.02, 0.02, 0.02, 0.001);
        }
    }

    private void playModernSleepSound(Player player) {
        if (!this.plugin.getConfigManager().areSoundEffectsEnabled()) {
            return;
        }
        float volume = (float)((double)0.08f * this.plugin.getConfigManager().getSoundVolume());
        try {
            Sound sleepSound = Sound.valueOf((String)this.plugin.getConfigManager().getSleepSound());
            player.playSound(player.getLocation(), sleepSound, volume, 1.9f);
        }
        catch (IllegalArgumentException e) {
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_CHIME, volume, 1.9f);
        }
    }

    public void startNightSkipAnimation(World world) {
        if (!this.plugin.getConfigManager().areAnimationsEnabled()) {
            return;
        }
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("night-skip-messages")) {
            MessageUtils.broadcastToWorld(world, "");
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getBorderLine());
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("night-skip.protocol-activated", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("night-skip.time-acceleration-progress", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getBorderLine());
            MessageUtils.broadcastToWorld(world, "");
        }
        this.startModernNightSkipSequence(world);
        for (Player player : world.getPlayers()) {
            if (player.isSleeping()) {
                this.startModernDreamEffect(player);
                continue;
            }
            this.startModernAwakeEffect(player);
        }
    }

    private void startModernNightSkipSequence(final World world) {
        new BukkitRunnable(){
            int phase = 0;
            int ticks = 0;

            public void run() {
                if (world.getPlayers().isEmpty()) {
                    this.cancel();
                    return;
                }
                Player randomPlayer = (Player)world.getPlayers().get(AnimationManager.this.random.nextInt(world.getPlayers().size()));
                Location skyLoc = randomPlayer.getLocation().add(0.0, 8.0, 0.0);
                switch (this.phase) {
                    case 0: {
                        AnimationManager.this.createModernTimeVortex(randomPlayer, skyLoc, this.ticks);
                        break;
                    }
                    case 1: {
                        AnimationManager.this.createModernCompletion(randomPlayer, skyLoc, this.ticks);
                    }
                }
                ++this.ticks;
                if (this.ticks >= 30) {
                    ++this.phase;
                    this.ticks = 0;
                    if (this.phase >= 2) {
                        if (AnimationManager.this.plugin.getConfigManager().isMessageCategoryEnabled("night-skip-messages")) {
                            MessageUtils.broadcastToWorld(world, "");
                            MessageUtils.broadcastToWorld(world, AnimationManager.this.plugin.getConfigManager().getBorderLine());
                            MessageUtils.broadcastToWorld(world, AnimationManager.this.plugin.getConfigManager().getMessage("night-skip.protocol-complete", new String[0]));
                            MessageUtils.broadcastToWorld(world, AnimationManager.this.plugin.getConfigManager().getMessage("night-skip.new-dawn", new String[0]));
                            MessageUtils.broadcastToWorld(world, AnimationManager.this.plugin.getConfigManager().getBorderLine());
                            MessageUtils.broadcastToWorld(world, "");
                        }
                        this.cancel();
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createModernTimeVortex(Player player, Location center, int ticks) {
        double angle = (double)ticks * 0.2;
        double radius = 1.5;
        double x = Math.cos(angle) * radius;
        double z = Math.sin(angle) * radius;
        double y = Math.sin((double)ticks * 0.1) * 0.3;
        Location vortexLoc = center.clone().add(x, y, z);
        player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, vortexLoc, 1, 0.0, 0.0, 0.0, 0.0);
        if (ticks == 0) {
            this.playModernTimeSound(player, Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 0.15f, 1.5f);
        }
    }

    private void createModernCompletion(Player player, Location center, int ticks) {
        if (ticks == 0) {
            for (int i = 0; i < 3; ++i) {
                double angle = (double)(i * 120) * Math.PI / 180.0;
                double x = Math.cos(angle) * 0.8;
                double z = Math.sin(angle) * 0.8;
                Location burstLoc = center.clone().add(x, 0.0, z);
                player.getWorld().spawnParticle(Particle.TOTEM, burstLoc, 1, 0.1, 0.1, 0.1, 0.02);
            }
            this.playModernTimeSound(player, Sound.UI_TOAST_CHALLENGE_COMPLETE, 0.2f, 1.8f);
        }
    }

    private void startModernDreamEffect(final Player player) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                if (this.ticks % 20 == 0) {
                    Location loc = player.getLocation().add(0.0, 1.5, 0.0);
                    player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 1, 0.1, 0.1, 0.1, 0.001);
                }
                ++this.ticks;
                if (this.ticks >= 60) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 10L, 1L);
    }

    private void startModernAwakeEffect(final Player player) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                if (this.ticks % 30 == 0) {
                    Location loc = player.getLocation().add(0.0, 1.2, 0.0);
                    double x = (AnimationManager.this.random.nextDouble() - 0.5) * 0.4;
                    double z = (AnimationManager.this.random.nextDouble() - 0.5) * 0.4;
                    Location particleLoc = loc.clone().add(x, 0.0, z);
                    player.getWorld().spawnParticle(Particle.END_ROD, particleLoc, 1, 0.02, 0.02, 0.02, 0.001);
                }
                ++this.ticks;
                if (this.ticks >= 40) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 1L);
    }

    private void playModernTimeSound(Player player, Sound sound, float volume, float pitch) {
        if (this.plugin.getConfigManager().areSoundEffectsEnabled()) {
            float adjustedVolume = (float)((double)volume * this.plugin.getConfigManager().getSoundVolume());
            player.playSound(player.getLocation(), sound, adjustedVolume, pitch);
        }
    }

    public void stopAnimation(Player player) {
        BukkitTask task = this.activeAnimations.remove(player);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
    }

    public void stopAllAnimations() {
        for (BukkitTask task : this.activeAnimations.values()) {
            if (task.isCancelled()) continue;
            task.cancel();
        }
        this.activeAnimations.clear();
    }

    public void cleanup() {
        this.stopAllAnimations();
    }
}

