/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ClockAnimationManager {
    private final EasySleep plugin;
    private BukkitRunnable clockTask;

    public ClockAnimationManager(EasySleep plugin) {
        this.plugin = plugin;
        this.startClockAnimation();
    }

    private void startClockAnimation() {
        if (!this.plugin.getConfigManager().isClockAnimationEnabled()) {
            return;
        }
        this.clockTask = new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!ClockAnimationManager.this.plugin.getConfigManager().isClockAnimationEnabled()) {
                    return;
                }
                if (this.ticks % 60 == 0) {
                    for (Player player : ClockAnimationManager.this.plugin.getServer().getOnlinePlayers()) {
                        if (!player.isSleeping()) continue;
                        ClockAnimationManager.this.showModernClock(player);
                    }
                }
                if (this.ticks % 6000 == 0) {
                    ClockAnimationManager.this.playModernClockChime();
                }
                ++this.ticks;
            }
        };
        this.clockTask.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void showModernClock(Player player) {
        World world = player.getWorld();
        Location loc = player.getLocation().add(0.0, 2.5, 0.0);
        long time = world.getTime();
        double hours = (double)((time + 6000L) % 24000L) / 1000.0;
        double minutes = hours % 1.0 * 60.0;
        this.createModernClockFace(loc, world);
        this.createModernClockHand(loc, world, hours * 30.0, 0.6, this.getModernTimeParticle(time));
        this.createModernClockHand(loc, world, minutes * 6.0, 0.9, this.getModernTimeParticle(time));
        world.spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void createModernClockFace(Location center, World world) {
        for (int i = 0; i < 4; ++i) {
            double angle = (double)(i * 90) * Math.PI / 180.0;
            double x = Math.cos(angle) * 0.8;
            double z = Math.sin(angle) * 0.8;
            Location markerLoc = center.clone().add(x, 0.0, z);
            world.spawnParticle(Particle.END_ROD, markerLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void createModernClockHand(Location center, World world, double angleDegrees, double length, Particle particle) {
        double angle = (angleDegrees - 90.0) * Math.PI / 180.0;
        double x = Math.cos(angle) * length;
        double z = Math.sin(angle) * length;
        Location handLoc = center.clone().add(x, 0.0, z);
        world.spawnParticle(particle, handLoc, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private Particle getModernTimeParticle(long time) {
        if (time >= 0L && time < 12000L) {
            return Particle.SOUL_FIRE_FLAME;
        }
        return Particle.SOUL;
    }

    private void playModernClockChime() {
        if (!this.plugin.getConfigManager().areSoundEffectsEnabled()) {
            return;
        }
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            if (!player.isSleeping()) continue;
            float volume = (float)((double)0.05f * this.plugin.getConfigManager().getSoundVolume());
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_CHIME, volume, 2.2f);
        }
    }

    public void restart() {
        if (this.clockTask != null && !this.clockTask.isCancelled()) {
            this.clockTask.cancel();
        }
        this.startClockAnimation();
    }

    public void cleanup() {
        if (this.clockTask != null) {
            this.clockTask.cancel();
            this.clockTask.cancel();
        }
    }
}

