/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DreamSequenceManager {
    private final EasySleep plugin;
    private final Map<UUID, DreamState> activeDreams;
    private final Map<UUID, BukkitTask> dreamTasks;
    private final Random random;

    public DreamSequenceManager(EasySleep plugin) {
        this.plugin = plugin;
        this.activeDreams = new HashMap<UUID, DreamState>();
        this.dreamTasks = new HashMap<UUID, BukkitTask>();
        this.random = new Random();
    }

    public void startDreamSequence(final Player player) {
        if (!this.plugin.getConfigManager().areAnimationsEnabled()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        final DreamType dreamType = DreamType.values()[this.random.nextInt(DreamType.values().length)];
        DreamState dreamState = new DreamState(dreamType, System.currentTimeMillis());
        this.activeDreams.put(uuid, dreamState);
        MessageUtils.sendMessage((CommandSender)player, "");
        MessageUtils.sendMessage((CommandSender)player, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        MessageUtils.sendMessage((CommandSender)player, "&d\u2728 &f&lDREAM REALM &d&lACCESS GRANTED &d\u2728");
        MessageUtils.sendMessage((CommandSender)player, "&7\ud83c\udf19 &fEntering: &b" + this.getDreamName(dreamType));
        MessageUtils.sendMessage((CommandSender)player, "&7\u26a1 &fDream ID: &e#" + Math.abs(uuid.hashCode() % 10000));
        MessageUtils.sendMessage((CommandSender)player, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        MessageUtils.sendMessage((CommandSender)player, "");
        BukkitTask task = new BukkitRunnable(this){
            int phase = 0;
            int ticks = 0;
            final /* synthetic */ DreamSequenceManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !player.isSleeping()) {
                    this.this$0.endDreamSequence(player);
                    this.cancel();
                    return;
                }
                switch (this.phase) {
                    case 0: {
                        this.this$0.createDreamEntry(player, dreamType, this.ticks);
                        if (this.ticks < 60) break;
                        ++this.phase;
                        this.ticks = 0;
                        break;
                    }
                    case 1: {
                        this.this$0.createMainDreamExperience(player, dreamType, this.ticks);
                        if (this.ticks < 100) break;
                        ++this.phase;
                        this.ticks = 0;
                        break;
                    }
                    case 2: {
                        this.this$0.createDreamDeepening(player, dreamType, this.ticks);
                        if (this.ticks < 80) break;
                        ++this.phase;
                        this.ticks = 0;
                        break;
                    }
                    case 3: {
                        this.this$0.createContinuousDream(player, dreamType, this.ticks);
                    }
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 1L);
        this.dreamTasks.put(uuid, task);
    }

    private void createDreamEntry(Player player, DreamType dreamType, int ticks) {
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        for (int i = 0; i < 3; ++i) {
            double angle = (double)ticks * 0.3 + (double)(i * 120);
            double radius = 1.5 - (double)ticks * 0.02;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.1) * 0.5;
            Location portalLoc = loc.clone().add(x, y, z);
            player.getWorld().spawnParticle(Particle.PORTAL, portalLoc, 2, 0.1, 0.1, 0.1, 0.02);
        }
        switch (dreamType.ordinal()) {
            case 0: {
                player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, loc, 1, 0.5, 0.5, 0.5, 0.01);
                break;
            }
            case 1: {
                player.getWorld().spawnParticle(Particle.END_ROD, loc, 2, 0.3, 0.3, 0.3, 0.05);
                break;
            }
            case 2: {
                player.getWorld().spawnParticle(Particle.DRIP_WATER, loc, 3, 0.4, 0.4, 0.4, 0.01);
                break;
            }
            case 3: {
                player.getWorld().spawnParticle(Particle.CLOUD, loc, 2, 0.6, 0.2, 0.6, 0.02);
                break;
            }
            case 4: {
                player.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, loc, 3, 0.5, 0.5, 0.5, 0.03);
                break;
            }
            case 5: {
                player.getWorld().spawnParticle(Particle.TOTEM, loc, 1, 0.8, 0.8, 0.8, 0.02);
            }
        }
        if (ticks == 0) {
            player.playSound(player.getLocation(), Sound.BLOCK_PORTAL_AMBIENT, 0.3f, 1.8f);
        }
    }

    private void createMainDreamExperience(Player player, DreamType dreamType, int ticks) {
        Location loc = player.getLocation().add(0.0, 2.0, 0.0);
        switch (dreamType.ordinal()) {
            case 0: {
                this.createPeacefulMeadowDream(player, loc, ticks);
                break;
            }
            case 1: {
                this.createCosmicVoyageDream(player, loc, ticks);
                break;
            }
            case 2: {
                this.createUnderwaterPalaceDream(player, loc, ticks);
                break;
            }
            case 3: {
                this.createFloatingIslandsDream(player, loc, ticks);
                break;
            }
            case 4: {
                this.createCrystalCavernsDream(player, loc, ticks);
                break;
            }
            case 5: {
                this.createAuroraRealmDream(player, loc, ticks);
            }
        }
        if (ticks == 50) {
            MessageUtils.sendMessage((CommandSender)player, "&7\ud83d\udcab &fDream sequence &bdeepening&f... &7\ud83d\udcab");
        }
    }

    private void createPeacefulMeadowDream(Player player, Location center, int ticks) {
        for (int i = 0; i < 2; ++i) {
            double angle = (double)ticks * 0.1 + (double)(i * 180);
            double radius = 1.2 + Math.sin((double)ticks * 0.05) * 0.3;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.08 + (double)i) * 0.4;
            Location flowerLoc = center.clone().add(x, y, z);
            player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, flowerLoc, 1, 0.1, 0.1, 0.1, 0.01);
        }
        if (ticks % 30 == 0) {
            player.getWorld().spawnParticle(Particle.CLOUD, center, 3, 1.5, 0.5, 1.5, 0.02);
            player.playSound(player.getLocation(), Sound.BLOCK_GRASS_STEP, 0.1f, 2.0f);
        }
    }

    private void createCosmicVoyageDream(Player player, Location center, int ticks) {
        for (int i = 0; i < 4; ++i) {
            double angle = (double)ticks * 0.2 + (double)(i * 90);
            double radius = 2.0 + Math.sin((double)ticks * 0.03 + (double)i) * 0.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.cos((double)ticks * 0.04 + (double)i) * 0.8;
            Location starLoc = center.clone().add(x, y, z);
            player.getWorld().spawnParticle(Particle.END_ROD, starLoc, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (ticks % 25 == 0) {
            player.getWorld().spawnParticle(Particle.DRAGON_BREATH, center, 2, 1.0, 1.0, 1.0, 0.05);
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_AMBIENT, 0.08f, 2.5f);
        }
    }

    private void createUnderwaterPalaceDream(Player player, Location center, int ticks) {
        for (int i = 0; i < 3; ++i) {
            double angle = i * 120;
            double x = Math.cos(Math.toRadians(angle)) * 0.8;
            double z = Math.sin(Math.toRadians(angle)) * 0.8;
            double y = (double)(ticks % 40) * 0.1;
            Location bubbleLoc = center.clone().add(x, y, z);
            player.getWorld().spawnParticle(Particle.BUBBLE_POP, bubbleLoc, 1, 0.1, 0.1, 0.1, 0.01);
        }
        if (ticks % 20 == 0) {
            player.getWorld().spawnParticle(Particle.DRIP_WATER, center, 5, 1.2, 0.8, 1.2, 0.02);
            player.playSound(player.getLocation(), Sound.AMBIENT_UNDERWATER_LOOP, 0.12f, 1.5f);
        }
    }

    private void createFloatingIslandsDream(Player player, Location center, int ticks) {
        for (int i = 0; i < 2; ++i) {
            double angle = (double)ticks * 0.08 + (double)(i * 180);
            double radius = 1.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.06 + (double)i) * 0.6 + 1.0;
            Location cloudLoc = center.clone().add(x, y, z);
            player.getWorld().spawnParticle(Particle.CLOUD, cloudLoc, 2, 0.3, 0.1, 0.3, 0.01);
        }
        if (ticks % 35 == 0) {
            player.getWorld().spawnParticle(Particle.SWEEP_ATTACK, center, 1, 1.5, 1.5, 1.5, 0.1);
            player.playSound(player.getLocation(), Sound.ITEM_ELYTRA_FLYING, 0.1f, 1.8f);
        }
    }

    private void createCrystalCavernsDream(Player player, Location center, int ticks) {
        for (int i = 0; i < 6; ++i) {
            double angle = i * 60;
            double radius = 1.0 + Math.sin((double)ticks * 0.04 + (double)i) * 0.2;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.cos((double)ticks * 0.05 + (double)i) * 0.3;
            Location crystalLoc = center.clone().add(x, y, z);
            player.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, crystalLoc, 1, 0.05, 0.05, 0.05, 0.02);
        }
        if (ticks % 40 == 0) {
            player.getWorld().spawnParticle(Particle.CRIT_MAGIC, center, 4, 1.0, 1.0, 1.0, 0.1);
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 0.15f, 2.2f);
        }
    }

    private void createAuroraRealmDream(Player player, Location center, int ticks) {
        for (int i = 0; i < 8; ++i) {
            double angle = (double)ticks * 0.15 + (double)(i * 45);
            double radius = 2.5 + Math.sin((double)ticks * 0.02 + (double)i) * 0.8;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.07 + (double)i) * 1.2;
            Location auroraLoc = center.clone().add(x, y, z);
            Particle auroraParticle = i % 3 == 0 ? Particle.TOTEM : (i % 3 == 1 ? Particle.SOUL_FIRE_FLAME : Particle.END_ROD);
            player.getWorld().spawnParticle(auroraParticle, auroraLoc, 1, 0.1, 0.1, 0.1, 0.01);
        }
        if (ticks % 45 == 0) {
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_AMBIENT, 0.1f, 2.0f);
        }
    }

    private void createDreamDeepening(Player player, DreamType dreamType, int ticks) {
        Location loc = player.getLocation().add(0.0, 1.8, 0.0);
        double angle = (double)ticks * 0.4;
        double radius = 0.8 + Math.sin((double)ticks * 0.1) * 0.3;
        double x = Math.cos(Math.toRadians(angle)) * radius;
        double z = Math.sin(Math.toRadians(angle)) * radius;
        double y = Math.sin((double)ticks * 0.12) * 0.4;
        Location spiralLoc = loc.clone().add(x, y, z);
        player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, spiralLoc, 1, 0.05, 0.05, 0.05, 0.01);
        if (ticks == 40) {
            MessageUtils.sendMessage((CommandSender)player, "&7\ud83c\udf19 &fDream state &dstabilized&f... entering &bdeep sleep&f... &7\ud83c\udf19");
        }
    }

    private void createContinuousDream(Player player, DreamType dreamType, int ticks) {
        if (ticks % 60 == 0) {
            Location loc = player.getLocation().add(0.0, 1.5, 0.0);
            player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 1, 0.2, 0.2, 0.2, 0.005);
            player.playSound(player.getLocation(), Sound.BLOCK_AMETHYST_BLOCK_CHIME, 0.05f, 2.5f);
        }
    }

    public void endDreamSequence(Player player) {
        UUID uuid = player.getUniqueId();
        DreamState dreamState = this.activeDreams.remove(uuid);
        BukkitTask task = this.dreamTasks.remove(uuid);
        if (task != null && !task.isCancelled()) {
            task.cancel();
        }
        if (dreamState != null) {
            long duration = (System.currentTimeMillis() - dreamState.startTime) / 1000L;
            MessageUtils.sendMessage((CommandSender)player, "");
            MessageUtils.sendMessage((CommandSender)player, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
            MessageUtils.sendMessage((CommandSender)player, "&c\u26a0 &f&lDREAM SEQUENCE &c&lTERMINATED &c\u26a0");
            MessageUtils.sendMessage((CommandSender)player, "&7\ud83c\udf05 &fReturning to &areality&f...");
            MessageUtils.sendMessage((CommandSender)player, "&7\u23f1 &fDream Duration: &e" + duration + "s");
            MessageUtils.sendMessage((CommandSender)player, "&7\ud83d\udcab &fDream Type: &b" + this.getDreamName(dreamState.dreamType));
            MessageUtils.sendMessage((CommandSender)player, "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
            MessageUtils.sendMessage((CommandSender)player, "");
            Location loc = player.getLocation().add(0.0, 1.5, 0.0);
            player.getWorld().spawnParticle(Particle.TOTEM, loc, 5, 0.5, 0.5, 0.5, 0.1);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.2f, 2.0f);
        }
    }

    private String getDreamName(DreamType dreamType) {
        switch (dreamType.ordinal()) {
            case 0: {
                return "Peaceful Meadow Sanctuary";
            }
            case 1: {
                return "Cosmic Voyage Dimension";
            }
            case 2: {
                return "Underwater Crystal Palace";
            }
            case 3: {
                return "Floating Sky Islands";
            }
            case 4: {
                return "Enchanted Crystal Caverns";
            }
            case 5: {
                return "Aurora Borealis Realm";
            }
        }
        return "Unknown Dream Realm";
    }

    public boolean isInDreamState(Player player) {
        return this.activeDreams.containsKey(player.getUniqueId());
    }

    public int getActiveDreamCount() {
        return this.activeDreams.size();
    }

    public void cleanup() {
        for (BukkitTask task : this.dreamTasks.values()) {
            if (task.isCancelled()) continue;
            task.cancel();
        }
        this.dreamTasks.clear();
        this.activeDreams.clear();
    }

    private static enum DreamType {
        PEACEFUL_MEADOW,
        COSMIC_VOYAGE,
        UNDERWATER_PALACE,
        FLOATING_ISLANDS,
        CRYSTAL_CAVERNS,
        AURORA_REALM;

    }

    private static class DreamState {
        final DreamType dreamType;
        final long startTime;

        DreamState(DreamType dreamType, long startTime) {
            this.dreamType = dreamType;
            this.startTime = startTime;
        }
    }
}

