/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class QuantumSleepManager {
    private final EasySleep plugin;
    private final Map<UUID, QuantumState> quantumStates;
    private final Map<String, Set<UUID>> quantumNetworks;
    private final Random random;

    public QuantumSleepManager(EasySleep plugin) {
        this.plugin = plugin;
        this.quantumStates = new HashMap<UUID, QuantumState>();
        this.quantumNetworks = new HashMap<String, Set<UUID>>();
        this.random = new Random();
        this.startQuantumMonitoring();
    }

    private void startQuantumMonitoring() {
        new BukkitRunnable(){

            public void run() {
                QuantumSleepManager.this.checkQuantumEntanglement();
                QuantumSleepManager.this.maintainQuantumCoherence();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 40L);
    }

    private void checkQuantumEntanglement() {
        HashMap<String, List<Player>> worldSleepers = new HashMap<String, List<Player>>();
        for (World world : this.plugin.getServer().getWorlds()) {
            ArrayList<Player> sleepers = new ArrayList<Player>();
            for (Player player : world.getPlayers()) {
                if (!player.isSleeping() || this.plugin.getAFKManager().isPlayerAFK(player)) continue;
                sleepers.add(player);
            }
            if (sleepers.isEmpty()) continue;
            worldSleepers.put(world.getName(), sleepers);
        }
        if (worldSleepers.size() >= 2) {
            this.createQuantumEntanglement(worldSleepers);
        }
    }

    private void createQuantumEntanglement(Map<String, List<Player>> worldSleepers) {
        String networkId = "quantum_" + System.currentTimeMillis();
        HashSet<UUID> entangledPlayers = new HashSet<UUID>();
        for (List<Player> sleepers : worldSleepers.values()) {
            for (Player player : sleepers) {
                UUID uuid = player.getUniqueId();
                this.quantumStates.put(uuid, QuantumState.ENTANGLED);
                entangledPlayers.add(uuid);
            }
        }
        this.quantumNetworks.put(networkId, entangledPlayers);
        for (List<Player> sleepers : worldSleepers.values()) {
            World world = sleepers.get(0).getWorld();
            if (!this.plugin.getConfigManager().isMessageCategoryEnabled("quantum-messages")) continue;
            MessageUtils.broadcastToWorld(world, "");
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getBorderLine());
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("quantum.entanglement-detected", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("quantum.cross-dimensional-sync", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("quantum.entangled-players", "%count%", String.valueOf(entangledPlayers.size()), "%dimensions%", String.valueOf(worldSleepers.size())));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("quantum.quantum-coherence", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getBorderLine());
            MessageUtils.broadcastToWorld(world, "");
        }
        this.startQuantumEffects(networkId, worldSleepers);
    }

    private void startQuantumEffects(final String networkId, final Map<String, List<Player>> worldSleepers) {
        new BukkitRunnable(this){
            int ticks = 0;
            final /* synthetic */ QuantumSleepManager this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Set network = (Set)this.this$0.quantumNetworks.get(networkId);
                if (network == null || network.isEmpty()) {
                    this.cancel();
                    return;
                }
                boolean anyStillSleeping = false;
                for (UUID uuid : network) {
                    Player player = this.this$0.plugin.getServer().getPlayer(uuid);
                    if (player == null || !player.isOnline() || !player.isSleeping()) continue;
                    anyStillSleeping = true;
                    break;
                }
                if (!anyStillSleeping) {
                    this.this$0.endQuantumEntanglement(networkId);
                    this.cancel();
                    return;
                }
                for (List sleepers : worldSleepers.values()) {
                    for (Player player : sleepers) {
                        if (!player.isOnline() || !player.isSleeping()) continue;
                        this.this$0.createQuantumParticles(player, this.ticks);
                    }
                }
                if (this.ticks % 60 == 0) {
                    this.this$0.createQuantumSynchronization(worldSleepers);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createQuantumParticles(Player player, int ticks) {
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        for (int i = 0; i < 2; ++i) {
            double angle = (double)ticks * 0.1 + (double)(i * 180);
            double radius = 0.8 + Math.sin((double)ticks * 0.05) * 0.2;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.08 + (double)i) * 0.3;
            Location quantumLoc = loc.clone().add(x, y, z);
            Particle quantumParticle = i % 2 == 0 ? Particle.END_ROD : Particle.SOUL_FIRE_FLAME;
            player.getWorld().spawnParticle(quantumParticle, quantumLoc, 1, 0.05, 0.05, 0.05, 0.01);
        }
        if (ticks % 40 == 0) {
            player.getWorld().spawnParticle(Particle.PORTAL, loc, 3, 0.5, 0.5, 0.5, 0.02);
        }
    }

    private void createQuantumSynchronization(Map<String, List<Player>> worldSleepers) {
        for (List<Player> sleepers : worldSleepers.values()) {
            if (sleepers.isEmpty()) continue;
            World world = sleepers.get(0).getWorld();
            Location center = this.calculateWorldCenter(sleepers);
            world.spawnParticle(Particle.TOTEM, center, 5, 2.0, 2.0, 2.0, 0.1);
            world.playSound(center, Sound.BLOCK_BEACON_POWER_SELECT, 0.2f, 2.0f);
            if (!this.plugin.getConfigManager().isMessageCategoryEnabled("quantum-messages")) continue;
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("quantum.synchronization-pulse", new String[0]));
        }
    }

    private Location calculateWorldCenter(List<Player> players) {
        double totalX = 0.0;
        double totalY = 0.0;
        double totalZ = 0.0;
        for (Player player : players) {
            Location loc = player.getLocation();
            totalX += loc.getX();
            totalY += loc.getY();
            totalZ += loc.getZ();
        }
        return new Location(players.get(0).getWorld(), totalX / (double)players.size(), totalY / (double)players.size() + 3.0, totalZ / (double)players.size());
    }

    private void endQuantumEntanglement(String networkId) {
        Set<UUID> network = this.quantumNetworks.remove(networkId);
        if (network == null) {
            return;
        }
        for (UUID uuid : network) {
            this.quantumStates.remove(uuid);
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) continue;
            if (this.plugin.getConfigManager().isMessageCategoryEnabled("quantum-messages")) {
                MessageUtils.sendMessage((CommandSender)player, this.plugin.getConfigManager().getMessage("quantum.entanglement-collapsed", new String[0]));
            }
            Location loc = player.getLocation().add(0.0, 1.5, 0.0);
            player.getWorld().spawnParticle(Particle.SMOKE_LARGE, loc, 5, 0.5, 0.5, 0.5, 0.05);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.3f, 0.8f);
        }
    }

    private void maintainQuantumCoherence() {
        for (String networkId : new ArrayList<String>(this.quantumNetworks.keySet())) {
            Set<UUID> network = this.quantumNetworks.get(networkId);
            network.removeIf(uuid -> {
                Player player = this.plugin.getServer().getPlayer(uuid);
                return player == null || !player.isOnline() || !player.isSleeping();
            });
            if (!network.isEmpty()) continue;
            this.quantumNetworks.remove(networkId);
        }
    }

    public boolean isQuantumEntangled(Player player) {
        return this.quantumStates.containsKey(player.getUniqueId());
    }

    public int getActiveQuantumNetworks() {
        return this.quantumNetworks.size();
    }

    public void cleanup() {
        this.quantumStates.clear();
        this.quantumNetworks.clear();
    }

    private static enum QuantumState {
        ENTANGLED,
        SUPERPOSITION,
        COLLAPSED,
        COHERENT,
        DECOHERENT;

    }
}

