/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep;

import com.turjo.easysleep.commands.SleepCommand;
import com.turjo.easysleep.listeners.PlayerEventListener;
import com.turjo.easysleep.listeners.SleepEventListener;
import com.turjo.easysleep.managers.AFKManager;
import com.turjo.easysleep.managers.AnimationManager;
import com.turjo.easysleep.managers.AntiSpamManager;
import com.turjo.easysleep.managers.ClockAnimationManager;
import com.turjo.easysleep.managers.ConfigManager;
import com.turjo.easysleep.managers.DayCounterManager;
import com.turjo.easysleep.managers.DayNightCycleManager;
import com.turjo.easysleep.managers.DimensionalSleepManager;
import com.turjo.easysleep.managers.DreamSequenceManager;
import com.turjo.easysleep.managers.MoonPhaseManager;
import com.turjo.easysleep.managers.QuantumSleepManager;
import com.turjo.easysleep.managers.RewardsManager;
import com.turjo.easysleep.managers.SleepAchievementManager;
import com.turjo.easysleep.managers.SleepEconomyManager;
import com.turjo.easysleep.managers.SleepRitualManager;
import com.turjo.easysleep.managers.StatisticsManager;
import com.turjo.easysleep.managers.UpdateChecker;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EasySleep
extends JavaPlugin {
    private static EasySleep instance;
    private AnimationManager animationManager;
    private ConfigManager configManager;
    private DayCounterManager dayCounterManager;
    private UpdateChecker updateChecker;
    private AFKManager afkManager;
    private AntiSpamManager antiSpamManager;
    private ClockAnimationManager clockAnimationManager;
    private DayNightCycleManager dayNightCycleManager;
    private StatisticsManager statisticsManager;
    private DreamSequenceManager dreamSequenceManager;
    private SleepRitualManager sleepRitualManager;
    private MoonPhaseManager moonPhaseManager;
    private RewardsManager rewardsManager;
    private QuantumSleepManager quantumSleepManager;
    private DimensionalSleepManager dimensionalSleepManager;
    private SleepAchievementManager sleepAchievementManager;
    private SleepEconomyManager sleepEconomyManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.rewardsManager = new RewardsManager(this);
        this.animationManager = new AnimationManager(this);
        this.dayCounterManager = new DayCounterManager(this);
        this.updateChecker = new UpdateChecker(this);
        this.afkManager = new AFKManager(this);
        this.antiSpamManager = new AntiSpamManager(this);
        this.clockAnimationManager = new ClockAnimationManager(this);
        this.dayNightCycleManager = new DayNightCycleManager(this);
        this.statisticsManager = new StatisticsManager(this);
        this.dreamSequenceManager = new DreamSequenceManager(this);
        this.sleepRitualManager = new SleepRitualManager(this);
        this.moonPhaseManager = new MoonPhaseManager(this);
        this.quantumSleepManager = new QuantumSleepManager(this);
        this.dimensionalSleepManager = new DimensionalSleepManager(this);
        this.sleepAchievementManager = new SleepAchievementManager(this);
        this.sleepEconomyManager = new SleepEconomyManager(this);
        this.initializeCommands();
        this.registerEventListeners();
        this.setDefaultSleepPercentage();
        this.updateChecker.startPeriodicCheck();
        this.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.getLogger().info("\u2551       \ud83c\udf19 EASYSLEEP v1.5.2 ACTIVATED \ud83c\udf19    \u2551");
        this.getLogger().info("\u2551                                           \u2551");
        this.getLogger().info("\u2551 \ud83d\udcac Customizable Messages: FULL CONTROL   \u2551");
        this.getLogger().info("\u2551 \ud83c\udf9b\ufe0f Message Categories: ENABLE/DISABLE    \u2551");
        this.getLogger().info("\u2551 \ud83c\udf0c Quantum Entanglement: REVOLUTIONARY   \u2551");
        this.getLogger().info("\u2551 \ud83c\udf0d Dimensional Portals: CROSS-WORLD      \u2551");
        this.getLogger().info("\u2551 \ud83c\udfc6 Achievement System: 16 EXCLUSIVE      \u2551");
        this.getLogger().info("\u2551 \ud83d\udc8e Dream Coin Economy: UNIQUE CURRENCY   \u2551");
        this.getLogger().info("\u2551 \ud83c\udf81 Rewards System: ACTIVE                \u2551");
        this.getLogger().info("\u2551 \u26a1 Time Acceleration: 1.5-2x SPEED       \u2551");
        this.getLogger().info("\u2551 \ud83c\udfa8 Gentle Animations: OPTIMIZED         \u2551");
        this.getLogger().info("\u2551 \ud83c\udf05 Day-Night Cycle: STUNNING             \u2551");
        this.getLogger().info("\u2551 \ud83d\udcca Statistics Tracking: COMPREHENSIVE    \u2551");
        this.getLogger().info("\u2551 \ud83e\udd16 AFK Detection: INTELLIGENT            \u2551");
        this.getLogger().info("\u2551 \ud83c\udf19 Moon Phases: MYSTICAL BONUSES         \u2551");
        this.getLogger().info("\u2551 \ud83c\udfc6 Achievement System: UNLOCKED          \u2551");
        this.getLogger().info("\u2551 \ud83d\udcb0 Economy Integration: VAULT READY      \u2551");
        this.getLogger().info("\u2551 \ud83c\udfae Modern GUI: FULLY FUNCTIONAL          \u2551");
        this.getLogger().info("\u2551 \ud83d\ude80 Status: ULTIMATE SLEEP EXPERIENCE     \u2551");
        this.getLogger().info("\u2551 \ud83d\udd27 Multiverse Compatible: FIXED v1.5.2   \u2551");
        this.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
    }

    public void onDisable() {
        this.getLogger().info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        this.getLogger().info("\u2551     \ud83c\udf19 EASYSLEEP v1.5.2 DEACTIVATED \ud83c\udf19    \u2551");
        this.getLogger().info("\u2551                                           \u2551");
        this.getLogger().info("\u2551 \ud83c\udf0c Quantum states: COLLAPSED             \u2551");
        this.getLogger().info("\u2551 \ud83c\udf0d Dimensional portals: CLOSED           \u2551");
        this.getLogger().info("\u2551 \ud83c\udfc6 Achievements: SAVED                   \u2551");
        this.getLogger().info("\u2551 \ud83d\udc8e Dream economy: SECURED                \u2551");
        this.getLogger().info("\u2551 \ud83c\udf81 Rewards saved and secured             \u2551");
        this.getLogger().info("\u2551 \u26a1 All systems: OFFLINE                  \u2551");
        this.getLogger().info("\u2551 \ud83d\udcab Thanks for using EasySleep v1.5.2!    \u2551");
        this.getLogger().info("\u2551 \ud83d\udcca Statistics: SAVED                     \u2551");
        this.getLogger().info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        if (this.rewardsManager != null) {
            this.rewardsManager.cleanup();
        }
        if (this.animationManager != null) {
            this.animationManager.cleanup();
        }
        if (this.dayCounterManager != null) {
            this.dayCounterManager.cleanup();
        }
        if (this.afkManager != null) {
            this.afkManager.cleanup();
        }
        if (this.antiSpamManager != null) {
            this.antiSpamManager.cleanup();
        }
        if (this.clockAnimationManager != null) {
            this.clockAnimationManager.cleanup();
        }
        if (this.dayNightCycleManager != null) {
            this.dayNightCycleManager.cleanup();
        }
        if (this.dreamSequenceManager != null) {
            this.dreamSequenceManager.cleanup();
        }
        if (this.sleepRitualManager != null) {
            this.sleepRitualManager.cleanup();
        }
        if (this.moonPhaseManager != null) {
            this.moonPhaseManager.cleanup();
        }
        if (this.quantumSleepManager != null) {
            this.quantumSleepManager.cleanup();
        }
        if (this.dimensionalSleepManager != null) {
            this.dimensionalSleepManager.cleanup();
        }
        if (this.sleepAchievementManager != null) {
            this.sleepAchievementManager.cleanup();
        }
        if (this.sleepEconomyManager != null) {
            this.sleepEconomyManager.cleanup();
        }
        instance = null;
    }

    private void initializeCommands() {
        SleepCommand sleepCommand = new SleepCommand(this);
        this.getCommand("sleep").setExecutor((CommandExecutor)sleepCommand);
        this.getCommand("sleep").setTabCompleter((TabCompleter)sleepCommand);
        this.getCommand("sleepmanager").setExecutor((CommandExecutor)sleepCommand);
        this.getCommand("sleepmanager").setTabCompleter((TabCompleter)sleepCommand);
        this.getCommand("sleepmgr").setExecutor((CommandExecutor)sleepCommand);
        this.getCommand("sleepmgr").setTabCompleter((TabCompleter)sleepCommand);
        this.getCommand("nightskip").setExecutor((CommandExecutor)sleepCommand);
        this.getCommand("nightskip").setTabCompleter((TabCompleter)sleepCommand);
    }

    private void registerEventListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new SleepEventListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventListener(this), (Plugin)this);
    }

    private void setDefaultSleepPercentage() {
        int defaultPercentage = this.configManager.getConfig().getInt("sleep.default-percentage", 50);
        for (World world : this.getServer().getWorlds()) {
            Integer currentPercentage = (Integer)world.getGameRuleValue(GameRule.PLAYERS_SLEEPING_PERCENTAGE);
            if (currentPercentage != null && currentPercentage == defaultPercentage) continue;
            world.setGameRule(GameRule.PLAYERS_SLEEPING_PERCENTAGE, (Object)defaultPercentage);
            this.getLogger().info("Configured world '" + world.getName() + "' with " + defaultPercentage + "% sleep requirement");
        }
    }

    public static EasySleep getInstance() {
        return instance;
    }

    public RewardsManager getRewardsManager() {
        return this.rewardsManager;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DayCounterManager getDayCounterManager() {
        return this.dayCounterManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public AFKManager getAFKManager() {
        return this.afkManager;
    }

    public AntiSpamManager getAntiSpamManager() {
        return this.antiSpamManager;
    }

    public ClockAnimationManager getClockAnimationManager() {
        return this.clockAnimationManager;
    }

    public DayNightCycleManager getDayNightCycleManager() {
        return this.dayNightCycleManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public DreamSequenceManager getDreamSequenceManager() {
        return this.dreamSequenceManager;
    }

    public SleepRitualManager getSleepRitualManager() {
        return this.sleepRitualManager;
    }

    public MoonPhaseManager getMoonPhaseManager() {
        return this.moonPhaseManager;
    }

    public QuantumSleepManager getQuantumSleepManager() {
        return this.quantumSleepManager;
    }

    public DimensionalSleepManager getDimensionalSleepManager() {
        return this.dimensionalSleepManager;
    }

    public SleepAchievementManager getSleepAchievementManager() {
        return this.sleepAchievementManager;
    }

    public SleepEconomyManager getSleepEconomyManager() {
        return this.sleepEconomyManager;
    }
}

