/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class AntiSpamManager {
    private final EasySleep plugin;
    private final Map<UUID, Long> lastSleepMessage;
    private final Map<UUID, Long> lastWakeMessage;
    private final Map<UUID, Long> lastCommand;

    public AntiSpamManager(EasySleep plugin) {
        this.plugin = plugin;
        this.lastSleepMessage = new HashMap<UUID, Long>();
        this.lastWakeMessage = new HashMap<UUID, Long>();
        this.lastCommand = new HashMap<UUID, Long>();
    }

    public boolean canSendSleepMessage(Player player) {
        long cooldown;
        long lastTime;
        if (!this.plugin.getConfigManager().isAntiSpamEnabled()) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastSleepMessage.getOrDefault(uuid, 0L).longValue()) >= (cooldown = (long)this.plugin.getConfigManager().getSleepMessageCooldown() * 1000L)) {
            this.lastSleepMessage.put(uuid, currentTime);
            return true;
        }
        return false;
    }

    public boolean canSendWakeMessage(Player player) {
        long cooldown;
        long lastTime;
        if (!this.plugin.getConfigManager().isAntiSpamEnabled()) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastWakeMessage.getOrDefault(uuid, 0L).longValue()) >= (cooldown = (long)this.plugin.getConfigManager().getWakeMessageCooldown() * 1000L)) {
            this.lastWakeMessage.put(uuid, currentTime);
            return true;
        }
        return false;
    }

    public boolean canUseCommand(Player player) {
        long cooldown;
        long lastTime;
        if (!this.plugin.getConfigManager().isAntiSpamEnabled()) {
            return true;
        }
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = this.lastCommand.getOrDefault(uuid, 0L).longValue()) >= (cooldown = (long)this.plugin.getConfigManager().getCommandCooldown() * 1000L)) {
            this.lastCommand.put(uuid, currentTime);
            return true;
        }
        return false;
    }

    public long getSleepMessageCooldown(Player player) {
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long lastTime = this.lastSleepMessage.getOrDefault(uuid, 0L);
        long cooldown = (long)this.plugin.getConfigManager().getSleepMessageCooldown() * 1000L;
        return Math.max(0L, cooldown - (currentTime - lastTime)) / 1000L;
    }

    public long getCommandCooldown(Player player) {
        UUID uuid = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long lastTime = this.lastCommand.getOrDefault(uuid, 0L);
        long cooldown = (long)this.plugin.getConfigManager().getCommandCooldown() * 1000L;
        return Math.max(0L, cooldown - (currentTime - lastTime)) / 1000L;
    }

    public void removePlayer(Player player) {
        UUID uuid = player.getUniqueId();
        this.lastSleepMessage.remove(uuid);
        this.lastWakeMessage.remove(uuid);
        this.lastCommand.remove(uuid);
    }

    public void cleanup() {
        this.lastSleepMessage.clear();
        this.lastWakeMessage.clear();
        this.lastCommand.clear();
    }
}

