/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final EasySleep plugin;
    private FileConfiguration config;

    public ConfigManager(EasySleep plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        if (this.config.getInt("config-version", 0) < 16) {
            this.plugin.getLogger().info("Updating configuration to version 16...");
            this.updateConfigToV16();
        }
        this.config.options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    private void updateConfigToV16() {
        if (this.config.contains("settings.default-sleep-percentage")) {
            this.config.set("sleep.default-percentage", (Object)this.config.getInt("settings.default-sleep-percentage", 50));
            this.config.set("settings.default-sleep-percentage", null);
        }
        this.config.addDefault("sleep.default-percentage", (Object)50);
        this.config.addDefault("sleep.time-acceleration", (Object)1.75);
        this.config.addDefault("rewards.enabled", (Object)true);
        this.config.addDefault("rewards.economy.enabled", (Object)true);
        this.config.addDefault("rewards.economy.money-per-sleep", (Object)25.0);
        this.config.addDefault("animations.enabled", (Object)true);
        this.config.addDefault("animations.gentle-mode", (Object)true);
        this.config.addDefault("animations.sleep-particle", (Object)"SOUL_FIRE_FLAME");
        this.config.addDefault("sounds.sleep-sound.sound", (Object)"BLOCK_AMETHYST_BLOCK_CHIME");
        this.config.addDefault("daily-messages.enabled", (Object)true);
        this.config.addDefault("messages.enabled.sleep-messages", (Object)true);
        this.config.addDefault("messages.enabled.night-skip-messages", (Object)true);
        this.config.addDefault("messages.enabled.time-acceleration", (Object)true);
        this.config.addDefault("messages.enabled.reward-messages", (Object)true);
        this.config.addDefault("messages.enabled.dream-messages", (Object)true);
        this.config.addDefault("messages.enabled.ritual-messages", (Object)true);
        this.config.addDefault("messages.enabled.moon-phase-messages", (Object)true);
        this.config.addDefault("messages.enabled.day-counter-messages", (Object)true);
        this.config.addDefault("messages.enabled.command-responses", (Object)true);
        this.config.addDefault("messages.enabled.error-messages", (Object)true);
        this.config.addDefault("messages.enabled.achievement-messages", (Object)true);
        this.config.addDefault("messages.enabled.economy-messages", (Object)true);
        this.config.addDefault("messages.enabled.quantum-messages", (Object)true);
        this.config.addDefault("messages.enabled.dimensional-messages", (Object)true);
        this.config.set("config-version", (Object)16);
        this.plugin.saveConfig();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public boolean areAnimationsEnabled() {
        return this.config.getBoolean("animations.enabled", true);
    }

    public boolean areSoundEffectsEnabled() {
        return this.config.getBoolean("sounds.enabled", true);
    }

    public boolean areEnhancedParticlesEnabled() {
        return this.config.getBoolean("animations.enhanced-particles", true);
    }

    public int getAnimationIntensity() {
        return this.config.getInt("animations.intensity", 2);
    }

    public double getSoundVolume() {
        return this.config.getDouble("sounds.master-volume", 0.3);
    }

    public int getMaxAnimationDistance() {
        return this.config.getInt("animations.max-distance", 32);
    }

    public boolean isDebugMode() {
        return this.config.getBoolean("technical.debug-mode", false);
    }

    public boolean isDayCounterEnabled() {
        return this.config.getBoolean("features.day-counter.enabled", true);
    }

    public boolean isClockAnimationEnabled() {
        return this.config.getBoolean("animations.clock-animation", true);
    }

    public boolean isDayNightAnimationEnabled() {
        return this.config.getBoolean("animations.day-night-cycle", true);
    }

    public boolean isAntiSpamEnabled() {
        return this.config.getBoolean("features.anti-spam.enabled", true);
    }

    public boolean isAFKDetectionEnabled() {
        return this.config.getBoolean("features.afk-detection.enabled", true);
    }

    public int getAFKThreshold() {
        return this.config.getInt("features.afk-detection.threshold-minutes", 5);
    }

    public int getSleepMessageCooldown() {
        return this.config.getInt("features.anti-spam.sleep-message-cooldown", 5);
    }

    public int getWakeMessageCooldown() {
        return this.config.getInt("features.anti-spam.wake-message-cooldown", 3);
    }

    public int getCommandCooldown() {
        return this.config.getInt("features.anti-spam.command-cooldown", 2);
    }

    public String getSleepParticle() {
        return this.config.getString("animations.sleep-particle", "SOUL_FIRE_FLAME");
    }

    public String getSleepSound() {
        return this.config.getString("sounds.sleep-sound.sound", "BLOCK_AMETHYST_BLOCK_CHIME");
    }

    public List<String> getRandomMorningMessages() {
        return this.config.getStringList("daily-messages.messages");
    }

    public boolean isMessageCategoryEnabled(String category) {
        return this.config.getBoolean("messages.enabled." + category, true);
    }

    public String getMessage(String path, String ... placeholders) {
        String message = this.config.getString("messages." + path, "");
        for (int i = 0; i < placeholders.length - 1; i += 2) {
            message = message.replace(placeholders[i], placeholders[i + 1]);
        }
        return message;
    }

    public String getBorderLine() {
        return this.config.getString("messages.decorations.border-line", "&8\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
    }

    public String getSectionSeparator() {
        return this.config.getString("messages.decorations.section-separator", "&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
    }

    public boolean isPerformanceMode() {
        return this.config.getBoolean("animations.performance-mode", false);
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        if (this.plugin.getClockAnimationManager() != null) {
            this.plugin.getClockAnimationManager().restart();
        }
        this.plugin.getLogger().info("Configuration reloaded successfully");
    }
}

