/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DayNightCycleManager {
    private final EasySleep plugin;
    private final Map<String, Long> lastTimeCheck;
    private final Map<String, Boolean> animationActive;

    public DayNightCycleManager(EasySleep plugin) {
        this.plugin = plugin;
        this.lastTimeCheck = new HashMap<String, Long>();
        this.animationActive = new HashMap<String, Boolean>();
        this.startModernCycleMonitoring();
    }

    private void startModernCycleMonitoring() {
        new BukkitRunnable(){

            public void run() {
                if (!DayNightCycleManager.this.plugin.getConfigManager().isDayNightAnimationEnabled()) {
                    return;
                }
                for (World world : DayNightCycleManager.this.plugin.getServer().getWorlds()) {
                    DayNightCycleManager.this.checkModernTimeAcceleration(world);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void checkModernTimeAcceleration(World world) {
        long lastTime;
        final String worldName = world.getName();
        long currentTime = world.getTime();
        long timeDiff = Math.abs(currentTime - (lastTime = this.lastTimeCheck.getOrDefault(worldName, currentTime).longValue()));
        if (timeDiff > 200L && !this.animationActive.getOrDefault(worldName, false).booleanValue()) {
            this.triggerModernTimeAcceleration(world);
            this.animationActive.put(worldName, true);
            new BukkitRunnable(){

                public void run() {
                    DayNightCycleManager.this.animationActive.put(worldName, false);
                }
            }.runTaskLater((Plugin)this.plugin, 100L);
        }
        this.lastTimeCheck.put(worldName, currentTime);
    }

    private void triggerModernTimeAcceleration(World world) {
        if (this.plugin.getConfigManager().isDebugMode()) {
            this.plugin.getLogger().info("Modern time acceleration in " + world.getName());
        }
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("time-acceleration")) {
            MessageUtils.broadcastToWorld(world, "");
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getBorderLine());
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("time-acceleration.active", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getMessage("time-acceleration.reality-shifting", new String[0]));
            MessageUtils.broadcastToWorld(world, this.plugin.getConfigManager().getBorderLine());
            MessageUtils.broadcastToWorld(world, "");
        }
        this.startModernAccelerationSequence(world);
    }

    private void startModernAccelerationSequence(final World world) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (world.getPlayers().isEmpty()) {
                    this.cancel();
                    return;
                }
                Player player = (Player)world.getPlayers().get(0);
                Location skyLoc = player.getLocation().add(0.0, 6.0, 0.0);
                if (this.ticks < 40) {
                    DayNightCycleManager.this.createModernAcceleration(player, skyLoc, this.ticks);
                } else if (this.ticks < 60) {
                    DayNightCycleManager.this.createModernStabilization(player, skyLoc, this.ticks - 40);
                } else {
                    if (DayNightCycleManager.this.plugin.getConfigManager().isMessageCategoryEnabled("time-acceleration")) {
                        MessageUtils.broadcastToWorld(world, "");
                        MessageUtils.broadcastToWorld(world, DayNightCycleManager.this.plugin.getConfigManager().getBorderLine());
                        MessageUtils.broadcastToWorld(world, DayNightCycleManager.this.plugin.getConfigManager().getMessage("time-acceleration.complete", new String[0]));
                        MessageUtils.broadcastToWorld(world, DayNightCycleManager.this.plugin.getConfigManager().getMessage("time-acceleration.timeline-established", new String[0]));
                        MessageUtils.broadcastToWorld(world, DayNightCycleManager.this.plugin.getConfigManager().getBorderLine());
                        MessageUtils.broadcastToWorld(world, "");
                    }
                    this.cancel();
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createModernAcceleration(Player player, Location center, int ticks) {
        double angle = (double)ticks * 0.3;
        double radius = 1.0 + Math.sin((double)ticks * 0.1) * 0.2;
        double x = Math.cos(angle) * radius;
        double z = Math.sin(angle) * radius;
        double y = Math.sin((double)ticks * 0.05) * 0.3;
        Location accelLoc = center.clone().add(x, y, z);
        player.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, accelLoc, 1, 0.0, 0.0, 0.0, 0.0);
        if (ticks == 0) {
            this.playModernSound(player, Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 0.1f, 1.2f);
        }
    }

    private void createModernStabilization(Player player, Location center, int ticks) {
        for (int i = 0; i < 3; ++i) {
            double angle = (double)(i * 120) * Math.PI / 180.0;
            double progress = (double)ticks / 20.0;
            double radius = 1.5 * (1.0 - progress);
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location stabilizeLoc = center.clone().add(x, 0.0, z);
            player.getWorld().spawnParticle(Particle.TOTEM, stabilizeLoc, 1, 0.05, 0.05, 0.05, 0.01);
        }
        if (ticks == 15) {
            this.playModernSound(player, Sound.UI_TOAST_CHALLENGE_COMPLETE, 0.15f, 1.6f);
        }
    }

    private void playModernSound(Player player, Sound sound, float volume, float pitch) {
        if (this.plugin.getConfigManager().areSoundEffectsEnabled()) {
            float adjustedVolume = (float)((double)volume * this.plugin.getConfigManager().getSoundVolume());
            player.playSound(player.getLocation(), sound, adjustedVolume, pitch);
        }
    }

    public void cleanup() {
        this.lastTimeCheck.clear();
        this.animationActive.clear();
    }
}

