/*
 * Decompiled with CFR 0.152.
 */
package com.turjo.easysleep.managers;

import com.turjo.easysleep.EasySleep;
import com.turjo.easysleep.utils.MessageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DimensionalSleepManager {
    private final EasySleep plugin;
    private final Map<String, DimensionalPortal> activePortals;
    private final Map<UUID, String> playerDimensions;
    private final Random random;

    public DimensionalSleepManager(EasySleep plugin) {
        this.plugin = plugin;
        this.activePortals = new HashMap<String, DimensionalPortal>();
        this.playerDimensions = new HashMap<UUID, String>();
        this.random = new Random();
        this.startDimensionalMonitoring();
    }

    private void startDimensionalMonitoring() {
        new BukkitRunnable(){

            public void run() {
                DimensionalSleepManager.this.checkDimensionalSleep();
                DimensionalSleepManager.this.maintainPortals();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 60L);
    }

    private void checkDimensionalSleep() {
        HashMap<World.Environment, List<Player>> dimensionSleepers = new HashMap<World.Environment, List<Player>>();
        for (World world : this.plugin.getServer().getWorlds()) {
            ArrayList<Player> sleepers = new ArrayList<Player>();
            for (Player player : world.getPlayers()) {
                if (!player.isSleeping() || this.plugin.getAFKManager().isPlayerAFK(player)) continue;
                sleepers.add(player);
            }
            if (sleepers.isEmpty()) continue;
            dimensionSleepers.put(world.getEnvironment(), sleepers);
        }
        if (dimensionSleepers.size() >= 2) {
            this.createDimensionalPortals(dimensionSleepers);
        }
    }

    private void createDimensionalPortals(Map<World.Environment, List<Player>> dimensionSleepers) {
        ArrayList<World.Environment> dimensions = new ArrayList<World.Environment>(dimensionSleepers.keySet());
        for (int i = 0; i < dimensions.size(); ++i) {
            for (int j = i + 1; j < dimensions.size(); ++j) {
                World.Environment dim1 = (World.Environment)dimensions.get(i);
                World.Environment dim2 = (World.Environment)dimensions.get(j);
                String portalId = dim1.name() + "_" + dim2.name();
                if (this.activePortals.containsKey(portalId)) continue;
                PortalType portalType = this.determinePortalType(dim1, dim2);
                DimensionalPortal portal = new DimensionalPortal(portalType, dim1, dim2, System.currentTimeMillis());
                this.activePortals.put(portalId, portal);
                this.announceDimensionalPortal(dimensionSleepers.get(dim1), dimensionSleepers.get(dim2), portalType);
                this.startPortalEffects(portalId, dimensionSleepers.get(dim1), dimensionSleepers.get(dim2));
            }
        }
    }

    private PortalType determinePortalType(World.Environment dim1, World.Environment dim2) {
        if (dim1 == World.Environment.NORMAL && dim2 == World.Environment.NETHER || dim1 == World.Environment.NETHER && dim2 == World.Environment.NORMAL) {
            return PortalType.OVERWORLD_NETHER;
        }
        if (dim1 == World.Environment.NORMAL && dim2 == World.Environment.THE_END || dim1 == World.Environment.THE_END && dim2 == World.Environment.NORMAL) {
            return PortalType.OVERWORLD_END;
        }
        if (dim1 == World.Environment.NETHER && dim2 == World.Environment.THE_END || dim1 == World.Environment.THE_END && dim2 == World.Environment.NETHER) {
            return PortalType.NETHER_END;
        }
        return PortalType.CUSTOM_DIMENSION;
    }

    private void announceDimensionalPortal(List<Player> sleepers1, List<Player> sleepers2, PortalType portalType) {
        String portalName = this.getPortalName(portalType);
        if (!sleepers1.isEmpty()) {
            World world1 = sleepers1.get(0).getWorld();
            if (this.plugin.getConfigManager().isMessageCategoryEnabled("dimensional-messages")) {
                MessageUtils.broadcastToWorld(world1, "");
                MessageUtils.broadcastToWorld(world1, this.plugin.getConfigManager().getBorderLine());
                MessageUtils.broadcastToWorld(world1, this.plugin.getConfigManager().getMessage("dimensional.portal-opened", new String[0]));
                MessageUtils.broadcastToWorld(world1, this.plugin.getConfigManager().getMessage("dimensional.portal-type", "%portal_type%", portalName));
                MessageUtils.broadcastToWorld(world1, this.plugin.getConfigManager().getMessage("dimensional.connected-dreamers", "%count%", String.valueOf(sleepers1.size() + sleepers2.size())));
                MessageUtils.broadcastToWorld(world1, this.plugin.getConfigManager().getMessage("dimensional.bridge-stabilizing", new String[0]));
                MessageUtils.broadcastToWorld(world1, this.plugin.getConfigManager().getBorderLine());
                MessageUtils.broadcastToWorld(world1, "");
            }
        }
        if (!sleepers2.isEmpty()) {
            World world2 = sleepers2.get(0).getWorld();
            if (this.plugin.getConfigManager().isMessageCategoryEnabled("dimensional-messages")) {
                MessageUtils.broadcastToWorld(world2, "");
                MessageUtils.broadcastToWorld(world2, this.plugin.getConfigManager().getBorderLine());
                MessageUtils.broadcastToWorld(world2, this.plugin.getConfigManager().getMessage("dimensional.portal-opened", new String[0]));
                MessageUtils.broadcastToWorld(world2, this.plugin.getConfigManager().getMessage("dimensional.portal-type", "%portal_type%", portalName));
                MessageUtils.broadcastToWorld(world2, this.plugin.getConfigManager().getMessage("dimensional.connected-dreamers", "%count%", String.valueOf(sleepers1.size() + sleepers2.size())));
                MessageUtils.broadcastToWorld(world2, this.plugin.getConfigManager().getMessage("dimensional.bridge-stabilizing", new String[0]));
                MessageUtils.broadcastToWorld(world2, this.plugin.getConfigManager().getBorderLine());
                MessageUtils.broadcastToWorld(world2, "");
            }
        }
    }

    private void startPortalEffects(final String portalId, final List<Player> sleepers1, final List<Player> sleepers2) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!DimensionalSleepManager.this.activePortals.containsKey(portalId)) {
                    this.cancel();
                    return;
                }
                DimensionalSleepManager.this.createPortalEffectsInDimension(sleepers1, this.ticks);
                DimensionalSleepManager.this.createPortalEffectsInDimension(sleepers2, this.ticks);
                if (this.ticks % 80 == 0) {
                    DimensionalSleepManager.this.createDimensionalResonance(sleepers1, sleepers2);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createPortalEffectsInDimension(List<Player> sleepers, int ticks) {
        if (sleepers.isEmpty()) {
            return;
        }
        Location center = this.calculateWorldCenter(sleepers);
        for (int i = 0; i < 8; ++i) {
            double angle = (double)ticks * 0.2 + (double)(i * 45);
            double radius = 3.0 + Math.sin((double)ticks * 0.05) * 0.5;
            double x = Math.cos(Math.toRadians(angle)) * radius;
            double z = Math.sin(Math.toRadians(angle)) * radius;
            double y = Math.sin((double)ticks * 0.08 + (double)i) * 0.8;
            Location portalLoc = center.clone().add(x, y, z);
            Particle portalParticle = i % 2 == 0 ? Particle.PORTAL : Particle.END_ROD;
            center.getWorld().spawnParticle(portalParticle, portalLoc, 1, 0.1, 0.1, 0.1, 0.02);
        }
        if (ticks % 30 == 0) {
            center.getWorld().spawnParticle(Particle.DRAGON_BREATH, center, 3, 1.0, 1.0, 1.0, 0.05);
        }
    }

    private void createDimensionalResonance(List<Player> sleepers1, List<Player> sleepers2) {
        if (sleepers1.isEmpty() || sleepers2.isEmpty()) {
            return;
        }
        Location center1 = this.calculateWorldCenter(sleepers1);
        Location center2 = this.calculateWorldCenter(sleepers2);
        center1.getWorld().spawnParticle(Particle.TOTEM, center1, 8, 2.0, 2.0, 2.0, 0.15);
        center2.getWorld().spawnParticle(Particle.TOTEM, center2, 8, 2.0, 2.0, 2.0, 0.15);
        center1.getWorld().playSound(center1, Sound.BLOCK_BEACON_POWER_SELECT, 0.3f, 1.8f);
        center2.getWorld().playSound(center2, Sound.BLOCK_BEACON_POWER_SELECT, 0.3f, 1.8f);
        if (this.plugin.getConfigManager().isMessageCategoryEnabled("dimensional-messages")) {
            MessageUtils.broadcastToWorld(center1.getWorld(), this.plugin.getConfigManager().getMessage("dimensional.resonance-detected", new String[0]));
            MessageUtils.broadcastToWorld(center2.getWorld(), this.plugin.getConfigManager().getMessage("dimensional.resonance-detected", new String[0]));
        }
    }

    private Location calculateWorldCenter(List<Player> players) {
        double totalX = 0.0;
        double totalY = 0.0;
        double totalZ = 0.0;
        for (Player player : players) {
            Location loc = player.getLocation();
            totalX += loc.getX();
            totalY += loc.getY();
            totalZ += loc.getZ();
        }
        return new Location(players.get(0).getWorld(), totalX / (double)players.size(), totalY / (double)players.size() + 5.0, totalZ / (double)players.size());
    }

    private String getPortalName(PortalType portalType) {
        switch (portalType.ordinal()) {
            case 0: {
                return "Overworld \u2194 Nether Bridge";
            }
            case 1: {
                return "Overworld \u2194 End Void Gateway";
            }
            case 2: {
                return "Nether \u2194 End Chaos Portal";
            }
            case 3: {
                return "Custom Dimensional Gateway";
            }
        }
        return "Unknown Portal";
    }

    private void maintainPortals() {
        this.activePortals.entrySet().removeIf(entry -> {
            long duration = System.currentTimeMillis() - ((DimensionalPortal)entry.getValue()).creationTime;
            return duration > 300000L;
        });
    }

    public int getActivePortalCount() {
        return this.activePortals.size();
    }

    public void cleanup() {
        this.activePortals.clear();
        this.playerDimensions.clear();
    }

    private static enum PortalType {
        OVERWORLD_NETHER,
        OVERWORLD_END,
        NETHER_END,
        CUSTOM_DIMENSION;

    }

    private static class DimensionalPortal {
        final PortalType portalType;
        final World.Environment dimension1;
        final World.Environment dimension2;
        final long creationTime;

        DimensionalPortal(PortalType portalType, World.Environment dimension1, World.Environment dimension2, long creationTime) {
            this.portalType = portalType;
            this.dimension1 = dimension1;
            this.dimension2 = dimension2;
            this.creationTime = creationTime;
        }
    }
}

